/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.payloads;

import com.huawei.us.common.regexfuzzer.payloads.PayloadFormatter;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SequencePayloads
implements Payloads {
    private final Payloads head;
    private final Payloads tail;

    public SequencePayloads(Payloads head, Payloads tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Iterator<String> iterator() {
        return new SequenceIterator(this.head, this.tail);
    }

    @Override
    public int size() {
        if (this.head.size() == 0) {
            return this.tail.size();
        }
        if (this.tail.size() == 0) {
            return this.head.size();
        }
        return Math.min(Integer.MAX_VALUE, this.head.size() * this.tail.size());
    }

    @Override
    public boolean isEmpty() {
        return this.head.isEmpty() && this.tail.isEmpty();
    }

    public String toString() {
        return PayloadFormatter.format(this);
    }

    private static class SequenceIterator
    implements Iterator<String> {
        private final Payloads head;
        private final Payloads tail;
        int size;
        int count = 0;
        private Iterator<String> heads;
        private Iterator<String> tails;

        SequenceIterator(Payloads head, Payloads tail) {
            this.head = head;
            this.tail = tail;
            this.heads = head.iterator();
            this.tails = tail.iterator();
            this.size = Math.min(Integer.MAX_VALUE, head.size() * tail.size());
        }

        @Override
        public boolean hasNext() {
            return (this.heads.hasNext() || this.tails.hasNext()) && this.count < this.size;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.heads.hasNext()) {
                this.heads = this.head.iterator();
            }
            if (!this.tails.hasNext()) {
                this.tails = this.tail.iterator();
            }
            StringBuilder payload = new StringBuilder();
            if (this.heads.hasNext()) {
                payload.append(this.heads.next());
            }
            if (this.tails.hasNext()) {
                payload.append(this.tails.next());
            }
            ++this.count;
            return payload.toString();
        }
    }
}

