/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.resource;

import com.huawei.us.common.resource.SpringResourceUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class ResourceUtil {
    private static final Logger logger = Logger.getLogger(ResourceUtil.class.getName());

    static Map<String, String> getPropertiesAsMap() {
        HashMap<String, String> map = new HashMap();
        try {
            if (null != Class.forName("org.springframework.core.io.support.PathMatchingResourcePatternResolver")) {
                map = SpringResourceUtil.getPropertiesAsMap();
            }
        }
        catch (Throwable e) {
            logger.log(Level.CONFIG, "if you want to use 1+n ability, please import spring-core", e);
        }
        ResourceUtil.readResources(map, "/us.config.properties");
        ResourceUtil.readResources(map, "/conf/us.config.properties");
        String extConfigPath = (String)map.get("us.external.config.path");
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{extConfigPath})) {
            ResourceUtil.reloadFromExternalConfig(extConfigPath, map);
        }
        return map;
    }

    private static void readResources(Map<String, String> map, String resourcePath) {
        if (map.size() == 0) {
            try (InputStream inStream = ResourceUtil.class.getResourceAsStream(resourcePath);){
                if (inStream != null) {
                    Properties props = new Properties();
                    props.load(inStream);
                    ResourceUtil.loadToMap(props, map);
                    props.clear();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "load file us.config.properties occurred an error!", e);
            }
        }
    }

    private static void loadToMap(Properties properties, Map<String, String> result) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = String.valueOf(propertyNames.nextElement());
            String value = properties.getProperty(name);
            result.put(name, value);
        }
    }

    private static void reloadFromExternalConfig(String extConfigPath, Map<String, String> result) {
        try (FileInputStream inStream = new FileInputStream(extConfigPath);){
            Properties props = new Properties();
            props.load(inStream);
            ResourceUtil.loadToMap(props, result);
            props.clear();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "load config file " + extConfigPath + " occurred an error!", e);
        }
    }
}

