/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.resource;

import com.huawei.us.common.consts.UsConst;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

abstract class SpringResourceUtil {
    private static final Logger logger = Logger.getLogger(SpringResourceUtil.class.getName());
    private static PathMatchingResourcePatternResolver pmr;
    private static Resource[] resourcesRoot;
    private static Resource[] resourcesSub;

    SpringResourceUtil() {
    }

    static Map<String, String> getPropertiesAsMap() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pmr == null) {
            pmr = new PathMatchingResourcePatternResolver();
        }
        if (resourcesRoot == null) {
            resourcesRoot = pmr.getResources("classpath*:us.config*.properties");
        }
        if (resourcesSub == null) {
            resourcesSub = pmr.getResources("classpath*:conf/us.config*.properties");
        }
        SpringResourceUtil.readResources(map, resourcesRoot);
        SpringResourceUtil.readResources(map, resourcesSub);
        return map;
    }

    private static void readResources(Map<String, String> map, Resource[] resources) {
        for (Resource resource : resources) {
            logger.log(Level.CONFIG, "load us config: " + resource.getFilename());
            try (InputStream inStream = resource.getInputStream();){
                Properties props = new Properties();
                props.load(inStream);
                SpringResourceUtil.loadToMap(props, map, resource);
                props.clear();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "load resource " + resource.getFilename() + " occurred an error!", e);
            }
        }
    }

    private static void loadToMap(Properties properties, Map<String, String> result, Resource resource) throws IOException {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = String.valueOf(propertyNames.nextElement());
            String value = properties.getProperty(name);
            if (result.containsKey(name) && UsConst.ONE_PLUS_N_SET.contains(name)) {
                value = result.get(name) + "," + value;
                String[] val = value.split(",");
                if (val.length > 0) {
                    List<String> list = Arrays.asList(val);
                    HashSet<String> set = new HashSet<String>(list);
                    set.remove("");
                    value = StringUtils.join(set, (String)",");
                    result.put(name, value);
                }
                logger.log(Level.CONFIG, name + " is merged by " + resource.getURL().getPath());
                continue;
            }
            if (result.containsKey(name) && !UsConst.ONE_PLUS_N_SET.contains(name)) {
                logger.log(Level.CONFIG, "Multiple configuration items were found, but this item do not support 1+n and only take the first value.Name is " + name);
                try {
                    if (!resource.getURL().getPath().contains(".cars" + File.separator) || resource.getURL().getPath().contains("us-common")) continue;
                    result.put(name, value);
                    logger.log(Level.CONFIG, name + " is override by " + resource.getURL().getPath());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "getURL error!", e);
                }
                continue;
            }
            result.put(name, value);
        }
    }
}

