/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.sqlinjection.check;

import com.huawei.us.common.sqlinjection.check.CheckResult;
import com.huawei.us.common.sqlinjection.check.CheckState;
import com.huawei.us.common.sqlinjection.thread.CheckerMatcher;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class SqlInjectionChecker {
    private static final long FIVE_MILLION = 0x500000L;

    public CheckResult check(String sqlStr) {
        CheckResult result = new CheckResult();
        if ((long)sqlStr.getBytes(Charset.defaultCharset()).length > 0x500000L) {
            result.setState(CheckState.TOO_LONG_SQL);
            return result;
        }
        ArrayList<String> hitRule = new ArrayList<String>();
        long start = System.nanoTime();
        result.setState(this.match(sqlStr, hitRule));
        result.setSqlStr(sqlStr);
        result.setHitRule(hitRule);
        result.setCostTime(System.nanoTime() - start);
        return result;
    }

    private CheckState match(String sqlStr, List<String> hitRule) {
        CheckState state;
        CheckerMatcher matcher = new CheckerMatcher();
        try {
            state = matcher.match(sqlStr, hitRule);
        }
        catch (IllegalStateException ex) {
            state = ex.getCause() instanceof TimeoutException ? CheckState.TIME_OUT : CheckState.NOT_KNOW;
        }
        return state;
    }
}

