/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.sqlinjection.pattern;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class SqlInjectionPatterns {
    public static final Map<String, Pattern> SQL_INJECTION_PATTERNS;
    public static final Pattern SHIELDED_PATTERN;

    static {
        ConcurrentHashMap<String, Pattern> sqlInjectPatterns = new ConcurrentHashMap<String, Pattern>();
        sqlInjectPatterns.put("aa", Pattern.compile("(?:and|or|case\\swhen|having|\\bmake_set\\b)\\s*\\(?(\\d+\\s*(?:[><=!]|[<>!]=)\\s*\\d+)"));
        sqlInjectPatterns.put("ab", Pattern.compile("(\"\\w+\")\\s*((?:[><=!]|[<>!]=))\\s*(\\1)"));
        sqlInjectPatterns.put("ac", Pattern.compile("('\\w+')\\s*((?:[><=!]|[<>!]=))\\s*(\\1)"));
        sqlInjectPatterns.put("ad", Pattern.compile("IIF\\(\\d+=\\d+,\\s*\\d+/(?:0|\\(select\\s0),\\s*\\d+/(?:0|\\(select\\s0)"));
        sqlInjectPatterns.put("ae", Pattern.compile("(?:geometrycollection|multipoint|polygon|multipolygon|linestring|multilinestring).*user\\("));
        sqlInjectPatterns.put("af", Pattern.compile("(?:st_latfromgeohash|st_longfromgeohash|st_pointfromgeohash|gtid_subset|gtid_subtract).*concat\\("));
        sqlInjectPatterns.put("ag", Pattern.compile("\\bexp\\b\\(~"));
        sqlInjectPatterns.put("ah", Pattern.compile("union\\s*(?:all)?\\s*select\\s*(?:\\d|concat\\(\\d)"));
        sqlInjectPatterns.put("ai", Pattern.compile("(?:or|where|having|and)\\s*(?:\\d+[\\*\\+-/])+\\d+=(?:\\d+[\\*\\+-/])+\\d+"));
        sqlInjectPatterns.put("aj", Pattern.compile("\\d{3,}\\s*\\*\\s*\\(select\\s*\\d{3,}\\s*from\\s*information_schema"));
        sqlInjectPatterns.put("ak", Pattern.compile("json_key\\(select\\s*convert"));
        sqlInjectPatterns.put("al", Pattern.compile("select\\s*count\\(\\*\\).*?floor\\(rand\\(0\\)\\*\\d+\\).*?group\\s*by"));
        sqlInjectPatterns.put("am", Pattern.compile("\\bselect\\scount\\(\\*\\)\\sfrom\\s(?:generate_series|all_users|DOMAIN\\.DOMAINS|\\bRDB\\$FIELDS|SYSIBM\\.SYSTABLES|\\bsysusers|\\bsysmaster\\:)"));
        sqlInjectPatterns.put("an", Pattern.compile("[^\\._](?:\\bsleep\\b|\\bpg_sleep\\b|\\bdbms_lock\\.sleep\\b|\\buser_lock\\.sleep\\b)\\(\\d+"));
        sqlInjectPatterns.put("ao", Pattern.compile("(?:\\bupdatexml|\\bextractvalue)\\(.*?,\\s*concat\\("));
        sqlInjectPatterns.put("ap", Pattern.compile("union\\s*(?:all)?\\s*select\\s*.*\\binformation_schema\\."));
        sqlInjectPatterns.put("aq", Pattern.compile("exec\\s*xp_cmdshell\\b"));
        sqlInjectPatterns.put("ar", Pattern.compile("like.*hex\\(randomblob\\(\\d"));
        sqlInjectPatterns.put("as", Pattern.compile("\\bif\\(ascii\\(mid\\("));
        sqlInjectPatterns.put("at", Pattern.compile("\\border\\sby.*select\\sversion\\("));
        sqlInjectPatterns.put("au", Pattern.compile("\\belt\\(\\d+"));
        sqlInjectPatterns.put("av", Pattern.compile("\\bbenchmark\\(\\d{6,},\\s*\\bmd5\\("));
        SQL_INJECTION_PATTERNS = Collections.unmodifiableMap(sqlInjectPatterns);
        SHIELDED_PATTERN = Pattern.compile("((?:n\\s*\\d+\\))|(?:\\d{4}-\\d+-\\d+))");
    }
}

