/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.string;

import com.huawei.us.common.exception.NormalizeOutOfLimitException;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsStringUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsStringUtils.class);

    public static String[] strToArray(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new String[0];
        }
        String urlSplitPattern = "[, ;\\r\\n]";
        String[] urlArray = str.split(urlSplitPattern);
        return (String[])Arrays.stream(urlArray).map(String::trim).filter(url -> url.length() != 0).toArray(String[]::new);
    }

    public static Set<String> strToSet(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new HashSet<String>();
        }
        String urlSplitPattern = "[, ;\\r\\n]";
        String[] urlArray = str.split(urlSplitPattern);
        return Arrays.stream(urlArray).map(String::trim).filter(url -> url.length() != 0).collect(Collectors.toSet());
    }

    public static String getCarsPath(String classPath) {
        if (StringUtils.isNotEmpty((CharSequence)classPath) && classPath.indexOf("/WEB-INF/") > 0) {
            return classPath.substring(5, classPath.indexOf("/WEB-INF")) + ".cars";
        }
        return "";
    }

    public static String normalizeString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Normalizer.normalize(str, Normalizer.Form.NFKC);
        }
        return str;
    }

    public static String normalizeStringLimitLen(String str) {
        return UsStringUtils.normalizeStringLimitLen(str, Normalizer.Form.NFKC);
    }

    public static String normalizeStringLimitLen(String str, Normalizer.Form form) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            int maxLen = Integer.parseInt(SystemConfigUtil.getStringValueByName("string.normalize.max.length", "2083"));
            if (str.length() >= maxLen) {
                logger.error("The string normalize max length is out of limit, you can modify it by 'string.normalize.max.length' in us.config.properties.");
                throw new NormalizeOutOfLimitException("The string normalize max length is out of limit, you can modify it by 'string.normalize.max.length' in us.config.properties");
            }
            return Normalizer.normalize(str, form);
        }
        return str;
    }
}

