/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.url;

import com.huawei.us.common.string.UsStringUtils;
import com.huawei.us.common.url.UDecoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsUriUtils {
    private static final Logger logger = LoggerFactory.getLogger(UsUriUtils.class);
    private static final String HTTP_HEADER = "http:/";
    private static final String HTTPS_HEADER = "https:/";
    private static final String FTP_HEADER = "ftp:/";
    private static final String CSE_HEADER = "cse:/";
    private static final String URI = "uri";

    public static String getServletPath(HttpServletRequest request) {
        return UsUriUtils.normalizeURI(request.getServletPath());
    }

    public static String getRequestPath(HttpServletRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getPathInfo())) {
            return UsUriUtils.normalizeURI(request.getServletPath() + request.getPathInfo());
        }
        return UsUriUtils.normalizeURI(request.getServletPath());
    }

    public static String getRequestURI(HttpServletRequest request) {
        return UsUriUtils.normalizeURI(request.getRequestURI());
    }

    public static String getRequestURL(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(UsStringUtils.normalizeStringLimitLen(request.getScheme(), Normalizer.Form.NFC)).append("://").append(UsStringUtils.normalizeStringLimitLen(request.getServerName(), Normalizer.Form.NFC));
        if (request.getServerPort() != 80 && request.getServerPort() != 433) {
            builder.append(":").append(request.getServerPort());
        }
        builder.append(UsUriUtils.getRequestURI(request));
        return builder.toString();
    }

    public static String getHost(HttpServletRequest request, List<String> hostWhiteList) {
        return UsUriUtils.getHost(UsUriUtils.getRequestURL(request), hostWhiteList);
    }

    public static String getHost(String requestURL, List<String> hostWhiteList) {
        try {
            URL url = new URL(requestURL);
            String host = url.getHost();
            if (StringUtils.isNotEmpty((CharSequence)host)) {
                for (String hostWhite : hostWhiteList) {
                    if (!host.equals(hostWhite)) continue;
                    return host;
                }
            }
        }
        catch (MalformedURLException e) {
            logger.error("get host from url failed.", (Throwable)e);
        }
        return "";
    }

    public static String normalizeURI(String requestURI) {
        return UsUriUtils.normalize(requestURI, true, URI);
    }

    public static String normalizePath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && path.contains("?")) {
            int index = path.indexOf("?");
            String uri = path.substring(0, index);
            String parameter = path.substring(index);
            return UsUriUtils.normalize(uri) + parameter;
        }
        return UsUriUtils.normalize(path);
    }

    public static String normalize(String path) {
        return UsUriUtils.normalize(path, true, null);
    }

    public static String normalize(String path, boolean isCheckMultipleUrlEncoding) {
        return UsUriUtils.normalize(path, isCheckMultipleUrlEncoding, null);
    }

    private static String normalize(String path, boolean isCheckMultipleUrlEncoding, String type) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        String normalized = UsStringUtils.normalizeStringLimitLen(path, Normalizer.Form.NFC);
        normalized = UsUriUtils.removePathParameters(normalized);
        normalized = UsUriUtils.decode(path, normalized, isCheckMultipleUrlEncoding, type);
        normalized = UsUriUtils.removePathParameters(normalized);
        return UsUriUtils.getNormalString(normalized);
    }

    private static String decode(String path, String normalized, boolean isCheckMultipleUrlEncoding, String type) {
        boolean decodeAgain = false;
        try {
            if (isCheckMultipleUrlEncoding) {
                decodeAgain = !StringUtils.equals((CharSequence)(normalized = UsUriUtils.decode(normalized, type)), (CharSequence)UsUriUtils.decode(normalized, type));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("The url[{}] is failed to url decode, please check.", (Object)path);
            throw new IllegalArgumentException("failed to decode url");
        }
        catch (IllegalArgumentException e) {
            logger.warn("normalized decode error");
        }
        if (decodeAgain) {
            logger.error("The url[{}] is failed to url decode:url encoded too many times, please check.", (Object)path);
            throw new IllegalArgumentException("url encoded too many times");
        }
        return normalized;
    }

    private static String decode(String normalized, String type) throws UnsupportedEncodingException {
        if (URI.equals(type)) {
            return UDecoder.decode(normalized, "utf-8");
        }
        return URLDecoder.decode(normalized, "utf-8");
    }

    private static String getNormalString(String normalized) {
        int index;
        if ((normalized = normalized.replaceAll("[\n\r]", "")).indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!(normalized.startsWith("/") || normalized.startsWith(HTTP_HEADER) || normalized.startsWith(HTTPS_HEADER) || normalized.startsWith(FTP_HEADER) || normalized.startsWith(CSE_HEADER))) {
            normalized = "/" + normalized;
        }
        boolean addedTrailingSlash = false;
        if (normalized.endsWith("/.") || normalized.endsWith("/..")) {
            normalized = normalized + "/";
            addedTrailingSlash = true;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        if (normalized.startsWith(HTTP_HEADER) || normalized.startsWith(HTTPS_HEADER) || normalized.startsWith(FTP_HEADER) || normalized.startsWith(CSE_HEADER)) {
            normalized = normalized.replaceFirst("/", "//");
        }
        return UsUriUtils.removePathCharacter(normalized, addedTrailingSlash);
    }

    private static String removePathCharacter(String normalized, boolean addedTrailingSlash) {
        int index;
        String specialHeader = "";
        String urlHeader = "";
        if (normalized.startsWith(HTTP_HEADER)) {
            urlHeader = HTTP_HEADER;
        } else if (normalized.startsWith(HTTPS_HEADER)) {
            urlHeader = HTTPS_HEADER;
        } else if (normalized.startsWith(FTP_HEADER)) {
            urlHeader = FTP_HEADER;
        } else if (normalized.startsWith(CSE_HEADER)) {
            urlHeader = CSE_HEADER;
        }
        if (StringUtils.isNotEmpty((CharSequence)urlHeader)) {
            specialHeader = normalized.substring(0, urlHeader.length() + 1);
            index = (normalized = normalized.substring(urlHeader.length() + 1)).indexOf("/");
            if (index >= 0) {
                specialHeader = specialHeader + normalized.substring(0, index);
                normalized = normalized.substring(index);
            }
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                logger.error("Trying to go outside our context");
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        if (StringUtils.isNotEmpty((CharSequence)specialHeader)) {
            normalized = specialHeader + normalized;
        }
        if (normalized.length() > 1 && addedTrailingSlash) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    private static String removePathParameters(String input) {
        int nextSlash;
        int nextSemiColon = input.indexOf(59);
        if (nextSemiColon == -1) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        result.append(input, 0, nextSemiColon);
        while ((nextSlash = input.indexOf(47, nextSemiColon)) != -1) {
            nextSemiColon = input.indexOf(59, nextSlash);
            if (nextSemiColon == -1) {
                result.append(input.substring(nextSlash));
                break;
            }
            result.append(input, nextSlash, nextSemiColon);
        }
        return result.toString();
    }
}

