/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.verifycode;

import com.huawei.us.common.random.UsSecureRandom;
import com.huawei.us.common.resource.SystemConfigUtil;
import com.huawei.us.common.verifycode.api.CaptchaCode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyCodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(VerifyCodeUtils.class);
    private static final double PAI = Math.PI;
    private static SecureRandom random;
    private static String bVariableFont;
    private static String[] fontsType;
    private static int iHeight;
    private static int iWidth;
    private static int iMaxFontSize;
    private static int iMinFontSize;
    private static String bVariableFontSize;
    private static String dictionary;
    private static String bIsRotate;
    private static int iDistance;
    private static String bIsSetBackground;
    private static String bIsSetInterferon;
    private static int iDistort;
    private static int iCodeCount;
    private static int iCharsLen;
    private static Long iTimeout;
    private static double[] rotateRange;

    public static void init() {
        bVariableFont = SystemConfigUtil.getStringValueByName("captcha.code.bvariablefont", "false");
        fontsType = StringUtils.isNotBlank((CharSequence)SystemConfigUtil.getStringValueByName("captcha.code.fontsType", "")) ? SystemConfigUtil.getStringValueByName("captcha.code.fontsType", "").split(",") : new String[]{""};
        iHeight = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iHeight", "35"));
        iWidth = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iWidth", "0"));
        iMaxFontSize = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iMaxFontSize", "0"));
        iMinFontSize = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iMinFontSize", "30"));
        bVariableFontSize = SystemConfigUtil.getStringValueByName("captcha.code.bVariableFontSize", "true");
        dictionary = SystemConfigUtil.getStringValueByName("captcha.code.dictionary", "2345689ABCDEFGHLMNPRTYabcdefhmnrt");
        bIsRotate = SystemConfigUtil.getStringValueByName("captcha.code.bIsRotate", "false");
        iDistance = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iDistance", "2"));
        bIsSetBackground = SystemConfigUtil.getStringValueByName("captcha.code.bIsSetBackground", "true");
        bIsSetInterferon = SystemConfigUtil.getStringValueByName("captcha.code.bIsSetInterferon", "true");
        iDistort = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iDistort", "0"));
        iCodeCount = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iCodeCount", "0"));
        iCharsLen = Integer.parseInt(SystemConfigUtil.getStringValueByName("captcha.code.iCharsLen", "4"));
        iTimeout = Long.parseLong(SystemConfigUtil.getStringValueByName("captcha.code.iTimeout", "60"));
    }

    public static CaptchaCode getCode() {
        CaptchaCode captchaCode = new CaptchaCode();
        String randS = VerifyCodeUtils.generateCodeString();
        BufferedImage image = VerifyCodeUtils.distortImage(VerifyCodeUtils.renderWord(randS), iDistort);
        captchaCode.setCode(randS);
        captchaCode.setImage(image);
        if (iTimeout > 0L) {
            captchaCode.setVerifyCodeValidTime(iTimeout * 1000L + System.currentTimeMillis());
        } else {
            captchaCode.setVerifyCodeValidTime(-1L);
        }
        return captchaCode;
    }

    private static Color getColor(int[] colorRange) {
        int rr = VerifyCodeUtils.getRandomInRange(colorRange);
        int gg = VerifyCodeUtils.getRandomInRange(colorRange);
        int bb = VerifyCodeUtils.getRandomInRange(colorRange);
        return new Color(rr, gg, bb);
    }

    private static int getRandomInRange(int[] range) {
        if (range == null || range.length != 2) {
            throw new InvalidParameterException("The range parameter is illegal, must contain two elements.");
        }
        return random.nextInt(range[1]) + range[0];
    }

    private static double getRandomInRange(double[] range) {
        if (range == null || range.length != 2) {
            throw new InvalidParameterException("The range parameter is illegal, must contain two elements.");
        }
        return random.nextDouble() * (range[1] - range[0]) + range[0];
    }

    private static String generateCodeString() {
        if (iCodeCount < 0) {
            iCharsLen = 4 + random.nextInt(4) + 1;
        }
        if (iWidth <= 0) {
            iWidth = (int)((double)iHeight * 3.0 * (double)iCharsLen / 4.0);
        }
        if (iMaxFontSize <= 0) {
            iMaxFontSize = 16 * iHeight / 12;
        }
        char[] dictionaryChars = dictionary.toCharArray();
        char[] codeChars = new char[iCharsLen];
        int dicLen = dictionaryChars.length;
        for (int i = 0; i < iCharsLen; ++i) {
            int index = random.nextInt(dicLen);
            codeChars[i] = dictionaryChars[index];
        }
        return String.valueOf(codeChars, 0, codeChars.length);
    }

    private static BufferedImage renderWord(String word) {
        int charSpace = iDistance - 2;
        BufferedImage image = new BufferedImage(iWidth, iHeight, 2);
        VerifyCodeUtils.setBackground(image);
        Graphics2D g2d = image.createGraphics();
        g2d.getDeviceConfiguration().createCompatibleImage(iWidth, iHeight, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.setRenderingHints(hints);
        FontRenderContext frc = g2d.getFontRenderContext();
        char[] wordChars = word.toCharArray();
        int len = wordChars.length;
        Font[] chosenFonts = new Font[len];
        int[] charWidths = new int[len];
        int widthNeeded = 0;
        String fonts = fontsType[0];
        int fontSize = iHeight + 10;
        for (int i = 0; i < len; ++i) {
            if ("true".equalsIgnoreCase(bVariableFont)) {
                fonts = fontsType[random.nextInt(3) % 4];
            }
            if ("true".equalsIgnoreCase(bVariableFontSize)) {
                fontSize = random.nextInt(iMaxFontSize) % (iMaxFontSize - iMinFontSize + 1) + iMinFontSize;
            }
            chosenFonts[i] = new Font(fonts, 0, fontSize);
            char[] charToDraw = new char[]{wordChars[i]};
            GlyphVector gv = chosenFonts[i].createGlyphVector(frc, charToDraw);
            charWidths[i] = (int)gv.getVisualBounds().getWidth();
            widthNeeded += charWidths[i];
        }
        return VerifyCodeUtils.getBufferedImage(charSpace, image, g2d, frc, wordChars, chosenFonts, charWidths, widthNeeded);
    }

    private static BufferedImage getBufferedImage(int charSpace, BufferedImage image, Graphics2D g2d, FontRenderContext frc, char[] wordChars, Font[] chosenFonts, int[] charWidths, int widthNeeded) {
        int startPosX = (iWidth - widthNeeded) / 5;
        for (int i = 0; i < wordChars.length; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            double rotateX = 0.0;
            if ("true".equals(bIsRotate)) {
                rotateX = VerifyCodeUtils.getRandomInRange(rotateRange);
            }
            affineTransform.rotate(rotateX, 15.0, 15.0);
            g2d.setTransform(affineTransform);
            g2d.setFont(chosenFonts[i]);
            Color color = VerifyCodeUtils.getRandColor(0, 120);
            g2d.setColor(color);
            int startPosY = (int)((float)(iHeight / 2) + chosenFonts[i].getLineMetrics(Character.toString(wordChars[i]), frc).getAscent() / 2.0f);
            g2d.drawString(Character.toString(wordChars[i]), startPosX, startPosY);
            startPosX = startPosX + charWidths[i] + charSpace;
        }
        g2d.dispose();
        return image;
    }

    private static void setBackground(BufferedImage image) {
        Graphics2D g2D = image.createGraphics();
        int width = iWidth + 3 * iDistance;
        int height = iHeight;
        g2D.fillRect(0, 0, width, height);
        g2D.setColor(Color.white);
        g2D.drawRect(0, 0, width, height);
        if ("true".equals(bIsSetBackground)) {
            int[] disturbColor = new int[]{0, 255};
            for (int i = 0; i < 150; ++i) {
                int xs = random.nextInt(width);
                int ys = random.nextInt(height);
                Color fgColor = VerifyCodeUtils.getColor(disturbColor);
                g2D.setColor(fgColor);
                g2D.drawLine(xs, ys, xs, ys);
            }
        }
        int lIWidth = iWidth;
        int lIHeight = iHeight;
        if ("true".equals(bIsSetInterferon)) {
            int index;
            int lITmp0 = lIWidth + 1;
            int lITmp1 = lIHeight + 1;
            int times1 = iHeight / 10;
            int times2 = iWidth / 10;
            for (index = 0; index < times1; ++index) {
                g2D.setStroke(new BasicStroke((float)((double)(VerifyCodeUtils.createRandom(30) + 1) / 16.0)));
                g2D.setColor(VerifyCodeUtils.getRandColor(50, 200));
                g2D.drawLine(0, VerifyCodeUtils.createRandom(lITmp1), lIWidth, VerifyCodeUtils.createRandom(lITmp1));
            }
            for (index = 0; index < times2; ++index) {
                g2D.setStroke(new BasicStroke((float)((double)(VerifyCodeUtils.createRandom(30) + 1) / 16.0)));
                g2D.setColor(VerifyCodeUtils.getRandColor(50, 200));
                g2D.drawLine(VerifyCodeUtils.createRandom(lITmp0), 0, VerifyCodeUtils.createRandom(lITmp0), lIHeight);
            }
        }
        g2D.dispose();
    }

    private static int createRandom(int iSeed) {
        int lIValue = 0;
        byte[] lPbtRand = new byte[4];
        random.nextBytes(lPbtRand);
        for (int index = 0; index < 4; ++index) {
            byte lBtTmp = lPbtRand[index];
            lIValue += (lBtTmp & 0xFF) << 8 * index;
        }
        return Math.abs(lIValue % iSeed);
    }

    private static Color getRandColor(int iFC, int iBC) {
        int lIMax = Math.max(iFC, iBC);
        int lIMin = Math.min(iFC, iBC);
        if (lIMin == lIMax) {
            return new Color(lIMin, lIMin, lIMin);
        }
        return new Color(lIMin + VerifyCodeUtils.createRandom(lIMax -= lIMin - 1), lIMin + VerifyCodeUtils.createRandom(lIMax), lIMin + VerifyCodeUtils.createRandom(lIMax));
    }

    private static BufferedImage distortImage(BufferedImage oldImage, int iMargin) {
        double dPhase = random.nextInt(6);
        BufferedImage newImage = new BufferedImage(oldImage.getWidth(), oldImage.getHeight(), 1);
        int width = newImage.getWidth();
        int height = newImage.getHeight();
        Graphics graphics = newImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        if (iMargin > 4) {
            iMargin = random.nextInt(iMargin) % (iMargin - 4) + 5;
        }
        for (int index = 0; index < width; ++index) {
            for (int jIndex = 0; jIndex < height; ++jIndex) {
                double doubleTemp = Math.PI * (double)jIndex / (double)height;
                double dy = Math.sin(doubleTemp += dPhase);
                int ox = index + (int)(dy * (double)iMargin);
                int oy = jIndex;
                int rgb = oldImage.getRGB(index, jIndex);
                if (ox < 0 || ox >= width) continue;
                newImage.setRGB(ox, oy, rgb);
            }
        }
        return newImage;
    }

    static {
        rotateRange = new double[]{-0.3, 0.3};
        try {
            random = UsSecureRandom.getInstance();
        }
        catch (NoClassDefFoundError | NoSuchAlgorithmException e) {
            logger.error("[US-COMMON] UsSecureRandom create SecureRandom Error", e);
            random = new SecureRandom();
        }
        VerifyCodeUtils.init();
    }
}

