/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.ui;

import com.huawei.ism.tool.exttool.ui.BSInstalledPanel;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IToolStoreService;
import com.huawei.ism.tool.framework.pubservice.entity.RemotePushInfo;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class BSIntegrateDialog
extends JDialog {
    private static final long serialVersionUID = 2074530158159090022L;
    private static final int OPEN_VALUE = 1;
    private String toolId = null;
    private int dialogValue;
    private RemotePushInfo rPInfo = null;
    private BSInstalledPanel bSInstalledPanel = new BSInstalledPanel();

    public BSIntegrateDialog(Window parent, String toolId) {
        super(parent);
        this.toolId = toolId;
        this.setTitle(toolId);
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        SwingUtil.putScreenCenter((Window)this);
        this.initCommponent();
        this.initUI();
        this.setVisible(true);
    }

    private void initCommponent() {
        IToolStoreService toolStoreService = (IToolStoreService)PublicServiceManage.getInstance().getService(IToolStoreService.class);
        List list = toolStoreService.getBSToolList();
        if (null == list || list.isEmpty()) {
            return;
        }
        this.bSInstalledPanel.getTableModel().removeAll();
        for (int i = list.size() - 1; i >= 0; --i) {
            RemotePushInfo info = (RemotePushInfo)list.get(i);
            if (null == this.toolId || !this.toolId.equals(info.getToolId())) continue;
            TableRow<RemotePushInfo, String> row = this.buildRecordRow(info);
            this.bSInstalledPanel.getTableModel().addRow(new TableRow[]{row});
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setSize(768, 500);
        this.setModal(true);
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        this.add((Component)this.bSInstalledPanel, "Center");
    }

    private TableRow<RemotePushInfo, String> buildRecordRow(RemotePushInfo info) {
        DefaultTableRow row = new DefaultTableRow(this.bSInstalledPanel.getTableModel().getColumnCount(), (Object)info, (Object)String.valueOf(info.getInstallTime()));
        this.updateRecordRow((TableRow<RemotePushInfo, String>)row);
        return row;
    }

    public void updateRecordRow(TableRow<RemotePushInfo, String> row) {
        RemotePushInfo info = (RemotePushInfo)row.getUserObject();
        row.setValueAt(0, (Object)info.getDeviceName());
        row.setValueAt(1, (Object)info.getIpAddress());
        row.setValueAt(2, (Object)info.getUsedEnvironment());
        row.setValueAt(3, (Object)info.getToolVersion());
        row.setValueAt(4, this.getInstalledType(info.isInstallLocal()));
        row.setValueAt(5, (Object)info.getInstallTime());
        if (info.isSupportRemote() || info.isInstallLocal()) {
            IsmTableCell.HyperlinkCell cell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString("bs.start.info.open"), (ActionListener)new OpenAction(info));
            row.setValueAt(6, (Object)cell);
        }
    }

    private Object getInstalledType(boolean installLocal) {
        if (installLocal) {
            return ResourceUtil.getString("bs.install.info.local");
        }
        return ResourceUtil.getString("bs.install.info.remote");
    }

    public int getDialogValue() {
        return this.dialogValue;
    }

    public void setDialogValue(int dialogValue) {
        this.dialogValue = dialogValue;
    }

    public RemotePushInfo getrPInfo() {
        return this.rPInfo;
    }

    public void setrPInfo(RemotePushInfo info) {
        this.rPInfo = info;
    }

    private class OpenAction
    implements ActionListener {
        private RemotePushInfo info;

        public OpenAction(RemotePushInfo info) {
            this.info = info;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BSIntegrateDialog.this.dialogValue = 1;
            BSIntegrateDialog.this.rPInfo = this.info;
            BSIntegrateDialog.this.dispose();
        }
    }
}

