/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.exttool.util.ToolEntry;
import com.huawei.ism.tool.exttool.util.ToolMngResource;
import com.huawei.ism.tool.framework.platform.common.toolbox.IStartBsChangeListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;

public class StartBsDialog
extends JDialog
implements IStartBsChangeListener {
    private static final long serialVersionUID = 4208992288822747197L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(StartBsDialog.class);
    private static final Dimension DIALOG_SIZE_ZH = new Dimension(430, 330);
    private static final Dimension DIALOG_SIZE_EN = new Dimension(640, 330);
    private static final Color SOUTHPANEL_BORDER_COLOR = new Color(196, 209, 214);
    private static final Color OPEN_LOG_COLOR = new Color(25, 158, 216);
    private static final int INT595 = 595;
    private static final Color BACKGROUND_COLOR = new Color(243, 243, 243);
    private ToolEntry toolEntry;
    private JProgressBar progressBar;
    private boolean isStart;
    private boolean isStop;
    private volatile boolean isStartSuccess;
    private volatile boolean isStopSuccess;
    private JLabel firstTextLabel;
    private JLabel secondTextLabel;
    private JLabel openLogLabel;
    private JScrollPane showLogScrollPane;
    private JPanel centerPanel;
    private JPanel southPanel;
    private JButton stopButton;
    private JDialog showInfoDialog;
    private volatile boolean isLoadLogOk = false;
    private JTextArea logText;
    private JLabel blankLabel = new JLabel();
    private JLabel openUrlLabel;
    private JComponent progressComp;
    private JButton closeBtn;
    private JComponent secondTextComp;
    private Locale currentLanguage = LanguageManager.getInstance().getCurrentLanguage();
    private boolean startBrowerResult = true;

    public StartBsDialog(Window parent, ToolEntry toolEntry) {
        super(parent);
        this.setTitle(ApplicationContext.getInstance().getCurSceneStepName());
        ApplicationContext context = ApplicationContext.getInstance();
        context.setStartBsChangeListener((IStartBsChangeListener)this);
        this.toolEntry = toolEntry;
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.initUi();
        this.initListener();
        this.isStart = true;
        this.startRefreshProgress();
        this.setModal(true);
        this.setVisible(true);
    }

    private void startRefreshProgress() {
        RefreshProgressThread refreshProgressThread = new RefreshProgressThread();
        refreshProgressThread.start();
    }

    private void initUi() {
        if (this.currentLanguageIsZh()) {
            UiMethod.setComponentSize(DIALOG_SIZE_ZH, this);
        } else {
            UiMethod.setComponentSize(DIALOG_SIZE_EN, this);
        }
        SwingUtil.putScreenCenter((Window)this);
        this.initCenterPanel();
        this.initSouthPanel();
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.southPanel, "South");
    }

    private void initSouthPanel() {
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SOUTHPANEL_BORDER_COLOR));
        UiMethod.setComponentSize(new Dimension(0, 45), this.southPanel);
        this.stopButton = new JButton(ToolMngResource.getString("scene.startbsdialog.stop"));
        this.stopButton.setEnabled(false);
        this.openUrlLabel.setVisible(false);
        this.secondTextComp.setVisible(false);
        this.closeBtn = new JButton(ToolMngResource.getString("scene.startbsdialog.close"));
        this.closeBtn.setVisible(false);
        UiMethod.setComponentSize(new Dimension(90, 25), this.stopButton);
        JComponent tempComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalGlue(), this.stopButton, this.closeBtn, Box.createHorizontalStrut(18)});
        JComponent buttonComp = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalGlue(), tempComp, Box.createVerticalGlue()});
        this.southPanel.add((Component)buttonComp, "Center");
    }

    private void initCenterPanel() {
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.firstTextLabel = new JLabel(ToolMngResource.getString("scene.startbsdialog.starting"));
        this.secondTextLabel = new JLabel(ToolMngResource.getString("scene.startbsdialog.startsuccess.second"));
        this.openLogLabel = new JLabel(ToolMngResource.getString("scene.startbsdialog.openlog"));
        this.openLogLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.openLogLabel.setForeground(OPEN_LOG_COLOR);
        this.openUrlLabel = new JLabel(ToolMngResource.getString("scene.startbsdialog.openurl.btn"));
        this.openUrlLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.openUrlLabel.setForeground(OPEN_LOG_COLOR);
        JComponent statusComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(17), this.firstTextLabel, Box.createHorizontalStrut(8), this.openUrlLabel, Box.createHorizontalGlue()});
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
        this.secondTextComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(17), this.secondTextLabel, Box.createHorizontalGlue()});
        this.progressComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalGlue(), this.progressBar, Box.createHorizontalGlue()});
        UiMethod.setComponentSize(new Dimension(125, 20), this.openLogLabel, this.openUrlLabel);
        JComponent openLogComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(17), this.openLogLabel, Box.createHorizontalGlue()});
        this.logText = new JTextArea();
        this.logText.setLineWrap(true);
        this.logText.setWrapStyleWord(true);
        this.logText.setEditable(false);
        this.logText.setBackground(BACKGROUND_COLOR);
        this.showLogScrollPane = new JScrollPane(this.logText);
        this.showLogScrollPane.setVisible(false);
        this.showLogScrollPane.setHorizontalScrollBarPolicy(31);
        this.showLogScrollPane.setVerticalScrollBarPolicy(20);
        JComponent logScrollComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalGlue(), this.showLogScrollPane, Box.createHorizontalGlue()});
        if (this.currentLanguageIsZh()) {
            UiMethod.setComponentSize(new Dimension(300, 20), this.firstTextLabel, this.secondTextLabel);
            UiMethod.setComponentSize(new Dimension(395, 20), this.progressBar);
            UiMethod.setComponentSize(new Dimension(395, 130), this.showLogScrollPane, this.blankLabel);
        } else {
            UiMethod.setComponentSize(new Dimension(480, 20), this.firstTextLabel, this.secondTextLabel);
            UiMethod.setComponentSize(new Dimension(595, 130), this.showLogScrollPane, this.blankLabel);
            UiMethod.setComponentSize(new Dimension(595, 20), this.progressBar);
        }
        JComponent verticalComp = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{statusComp, this.progressComp, openLogComp, logScrollComp, this.blankLabel, this.secondTextComp, Box.createVerticalGlue()});
        this.centerPanel.add((Component)verticalComp, "Center");
    }

    private void setShowInfoDialog(String tips) {
        String startingInfo = tips;
        this.showInfoDialog = DialogUtils.getInfoDialog((Window)this, (String)startingInfo);
        this.showInfoDialog.setVisible(true);
    }

    private void initListener() {
        this.listenWindowClosing();
        this.openLogLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                boolean isShowLog = StartBsDialog.this.showLogScrollPane.isVisible();
                if (isShowLog) {
                    StartBsDialog.this.showLogScrollPane.setVisible(false);
                    StartBsDialog.this.blankLabel.setVisible(true);
                    StartBsDialog.this.openLogLabel.setText(ToolMngResource.getString("scene.startbsdialog.openlog"));
                } else {
                    StartBsDialog.this.logText.setCaretPosition(StartBsDialog.this.logText.getText().length());
                    StartBsDialog.this.showLogScrollPane.setVisible(true);
                    StartBsDialog.this.blankLabel.setVisible(false);
                    StartBsDialog.this.openLogLabel.setText(ToolMngResource.getString("scene.startbsdialog.closelog"));
                }
            }
        });
        this.stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LOGGER.info("sotpping tool...");
                if (!StartBsDialog.this.isStart && !StartBsDialog.this.isStop) {
                    StartBsDialog.this.stopTool();
                }
            }
        });
        this.openUrlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                List executeResult = AsyncExcutor.execute((Window)StartBsDialog.this, (Callable[])new Callable[]{new OpenUrlCallabel()});
                if (!((Boolean)executeResult.get(0)).booleanValue()) {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.start.browser.btn.error"));
                } else {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.startsuccess"));
                }
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartBsDialog.this.setVisible(false);
                StartBsDialog.this.dispose();
            }
        });
    }

    private void listenWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (!StartBsDialog.this.closeBtn.isVisible()) {
                    LOGGER.info("sotpping tool...");
                    StartBsDialog.this.setDefaultCloseOperation(0);
                    String curSceneStepName = ApplicationContext.getInstance().getCurSceneStepName();
                    if (StartBsDialog.this.isStart) {
                        StartBsDialog.this.setShowInfoDialog(ToolMngResource.getStringWithParams("scene.startbsdialog.isstarttips", curSceneStepName));
                    } else if (StartBsDialog.this.isStop) {
                        StartBsDialog.this.setShowInfoDialog(ToolMngResource.getStringWithParams("scene.startbsdialog.isstoptips", curSceneStepName));
                    } else {
                        StartBsDialog.this.stopTool();
                    }
                } else {
                    StartBsDialog.this.setVisible(false);
                    StartBsDialog.this.dispose();
                }
            }
        });
    }

    private void stopTool() {
        String tips = ToolMngResource.getStringWithParams("scene.startbsdialog.ifstoptips", ApplicationContext.getInstance().getCurSceneStepName());
        WarningDialog showIfStopDialog = DialogUtils.createWarningDialog((JDialog)this, (String)tips);
        if (showIfStopDialog.getValue() == 0) {
            this.stopButton.setEnabled(false);
            this.openUrlLabel.setVisible(false);
            this.secondTextComp.setVisible(false);
            this.progressBar.setValue(0);
            this.progressComp.setVisible(true);
            this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.stopping"));
            this.isStop = true;
            this.isLoadLogOk = false;
            this.startRefreshProgress();
            this.toolEntry.stopBsToolNew();
        }
    }

    public synchronized void startSuccess() {
        if (!this.isLoadLogOk) {
            this.isLoadLogOk = true;
            this.isStartSuccess = true;
        }
    }

    public synchronized void startError() {
        if (!this.isLoadLogOk) {
            LOGGER.error("B/S start failed,tool name:" + this.toolEntry.getId());
            this.isLoadLogOk = true;
            this.isStartSuccess = false;
        }
    }

    public synchronized void stopSuccess() {
        if (!this.isLoadLogOk) {
            this.isLoadLogOk = true;
            this.isStopSuccess = true;
        }
    }

    public synchronized void stopError() {
        if (!this.isLoadLogOk) {
            LOGGER.error("stop failed...");
            this.isLoadLogOk = true;
            this.isStopSuccess = false;
        }
    }

    private void closeShowInfoDialog() {
        if (null != this.showInfoDialog && this.showInfoDialog.isVisible()) {
            this.showInfoDialog.setVisible(false);
        }
    }

    public void refreshCMDOutputStr(String cmdOutPut) {
        this.logText.append(cmdOutPut);
        this.logText.setCaretPosition(this.logText.getText().length());
    }

    private boolean currentLanguageIsZh() {
        return this.currentLanguage.equals(Locale.CHINESE) || this.currentLanguage.equals(Locale.CHINA);
    }

    public void startBsError() {
        this.startBrowerResult = false;
    }

    private class OpenUrlCallabel
    implements Callable<Boolean> {
        private OpenUrlCallabel() {
        }

        @Override
        public Boolean call() throws Exception {
            return StartBsDialog.this.toolEntry.openUrlInBrowser();
        }
    }

    private class RefreshProgressThread
    extends Thread {
        private static final long SLOW = 3000L;
        private static final long MIDDLE = 1500L;
        private static final long HIGH = 100L;

        private RefreshProgressThread() {
        }

        @Override
        public void run() {
            try {
                int value = 0;
                boolean thisTimeIsStart = StartBsDialog.this.isStart;
                while (value < 100 && thisTimeIsStart == StartBsDialog.this.isStart) {
                    long sleepTime = this.getSleepTime(value, StartBsDialog.this.isLoadLogOk);
                    Thread.sleep(sleepTime);
                    StartBsDialog.this.progressBar.setValue(++value);
                    value = StartBsDialog.this.progressBar.getValue();
                }
                if (value == 100) {
                    this.setStatusLabelValue(thisTimeIsStart);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("refresh progress error", (Throwable)e);
            }
        }

        private void setStatusLabelValue(boolean thisTimeIsStart) {
            if (thisTimeIsStart) {
                if (StartBsDialog.this.isStartSuccess) {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.startsuccess"));
                    StartBsDialog.this.openUrlLabel.setVisible(true);
                    StartBsDialog.this.progressComp.setVisible(false);
                    StartBsDialog.this.secondTextComp.setVisible(true);
                    if (!StartBsDialog.this.startBrowerResult) {
                        StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.start.browser.error"));
                    }
                } else {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.starterror"));
                }
                StartBsDialog.this.closeShowInfoDialog();
                StartBsDialog.this.isStart = false;
                StartBsDialog.this.stopButton.setEnabled(true);
            } else {
                StartBsDialog.this.closeShowInfoDialog();
                if (StartBsDialog.this.isStopSuccess) {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("scene.startbsdialog.stopsuccess"));
                    StartBsDialog.this.setVisible(false);
                    StartBsDialog.this.dispose();
                } else {
                    StartBsDialog.this.firstTextLabel.setText(ToolMngResource.getString("bs.tools.info.stop.faild"));
                    StartBsDialog.this.closeBtn.setVisible(true);
                    StartBsDialog.this.stopButton.setVisible(false);
                }
                StartBsDialog.this.isStop = false;
            }
        }

        private synchronized long getSleepTime(int value, boolean isFinish) {
            if (isFinish) {
                return 100L;
            }
            if (value < 80) {
                return 1500L;
            }
            return 3000L;
        }
    }
}

