/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.io.File;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class DatumIniReader {
    private String iniOriginalInfo = "";
    private Map<String, String> iniCache = new HashMap<String, String>();

    public DatumIniReader(File filePath) {
        this.iniOriginalInfo = StreamUtils.readStringFormFile((File)filePath);
        this.analyzeInfo();
    }

    private void analyzeInfo() {
        String[] lines;
        for (String line : lines = this.iniOriginalInfo.split("\n")) {
            if (";".startsWith(line = line.trim()) || !line.contains(Normalizer.normalize("=", Normalizer.Form.NFKC))) continue;
            int indexOf = line.indexOf("=");
            String value = line.substring(indexOf + 1);
            String[] kv = line.split("=");
            String k = StringUtils.safetyGetStr((String[])kv, (int)0);
            String v = value;
            this.iniCache.put(k.trim(), v.trim());
        }
    }

    public String getString(String key) {
        String val = this.iniCache.get(key);
        if (StringUtils.isNULLStr((String)val)) {
            return "";
        }
        return val;
    }
}

