/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.exception.DateFormatException;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ParsingResult;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.support.DefaultParsingResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    public static final String DEFAULT_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";

    private DateUtils() {
    }

    public static String toString(Date value) {
        return DateUtils.toString(value, null);
    }

    public static String toString(Date value, String format) {
        if (value == null) {
            return null;
        }
        return new SimpleDateFormat(ObjectUtils.nullIf(format, DEFAULT_FORMAT_STRING)).format(value);
    }

    public static Date parse(String str) {
        return DateUtils.parse(str, null);
    }

    public static Date parse(String str, String format) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(ObjectUtils.nullIf(format, DEFAULT_FORMAT_STRING));
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException ex) {
            throw new DateFormatException(ex);
        }
    }

    public static ParsingResult<Date> tryParse(String str) {
        return DateUtils.tryParse(str, null);
    }

    public static ParsingResult<Date> tryParse(String str, String format) {
        try {
            Date value = DateUtils.parse(str, format);
            return new DefaultParsingResult<Date>(true, value);
        }
        catch (DateFormatException ex) {
            return ParsingResult.failed();
        }
    }

    public static Date create(int year, int month, int day) {
        return DateUtils.create(year, month, day, 0, 0, 0, 0);
    }

    public static Date create(int year, int month, int day, int hour, int minute, int second) {
        return DateUtils.create(year, month, day, hour, minute, second, 0);
    }

    public static Date create(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, year);
        calendar.set(2, month - 1 + 0);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static Date now() {
        return new Date();
    }
}

