/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class USCryptoConfig {
    public static final String ENCRYPTION_ALGORITHM;
    public static final String DEFAULT_CIPHER_TRANSFORMATION;
    public static final String ALLOWED_MODES;
    public static final String MASTER_KEY;
    private static final String PREFIX = "USCRYPTO.";

    private USCryptoConfig() {
    }

    static {
        DEFAULT_CIPHER_TRANSFORMATION = SystemConfigUtil.getStringValueByName((String)"encryptor.cipher.transformation", (String)"AES/GCM/PKCS5Padding");
        try (InputStream is = USCryptoConfig.class.getResourceAsStream("/USCRYPTO.properties");){
            Properties properties = new Properties();
            properties.load(is);
            ENCRYPTION_ALGORITHM = properties.getProperty("USCRYPTO.ENCRYPTION_ALGORITHM");
            ALLOWED_MODES = properties.getProperty("USCRYPTO.ALLOWED_MODES");
            MASTER_KEY = properties.getProperty("USCRYPTO.MASTER_KEY");
        }
        catch (IOException e) {
            throw new IllegalStateException("load us crypto config properties failed");
        }
    }
}

