/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.common.resource.SystemConfigUtil;
import com.huawei.wsf.core.HWEncoder;
import com.huawei.wsf.core.HWEncryptor;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USHasher {
    private static final Logger logger = LoggerFactory.getLogger(USHasher.class);
    private static int MIN_KEY_LEN = 16;
    private static int MAX_KEY_LEN = 512;
    private static int SALT_LEN = 16;

    private USHasher() {
    }

    public static String getHashedPassword(String password, byte[] salt) throws GeneralSecurityException {
        return USHasher.getHashedPassword(password, salt, 10000, 256);
    }

    public static String getHashedPassword(String password, byte[] salt, int iterCount) throws GeneralSecurityException {
        return USHasher.getHashedPassword(password, salt, iterCount, 256);
    }

    public static String getHashedPassword(String password, byte[] salt, int iterCount, int keyLen) throws GeneralSecurityException {
        if (keyLen < 256) {
            throw new GeneralSecurityException("KeyLen must not less than 256 bits!");
        }
        if (salt.length < 16) {
            throw new GeneralSecurityException("Salt must not less than 16 bytes!");
        }
        if (iterCount < 10000) {
            throw new GeneralSecurityException("Iteration must not less than 10000 times!");
        }
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterCount, keyLen);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(SystemConfigUtil.getStringValueByName((String)"us.hasher.pbkdf", (String)"PBKDF2WithHmacSHA256"));
        byte[] hashed = skf.generateSecret(spec).getEncoded();
        return USCodec.encodeForBase64(hashed);
    }

    public static String getHashedPasswordInHex(String plainText, String salt) throws GeneralSecurityException {
        if (StringUtils.isEmpty((CharSequence)plainText) || StringUtils.isEmpty((CharSequence)salt)) {
            return "";
        }
        PBEKeySpec spec = new PBEKeySpec(plainText.toCharArray(), USCodec.decodeForHex(salt), 10000, 256);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        byte[] hashed = skf.generateSecret(spec).getEncoded();
        return USCodec.encodeForHex(hashed).toUpperCase(Locale.ENGLISH);
    }

    public static byte[] deriveKey(byte[] password, byte[] salt, int iterationCount, int derivekeyLength) throws NoSuchAlgorithmException, InvalidKeyException {
        if (derivekeyLength > MAX_KEY_LEN || derivekeyLength < MIN_KEY_LEN) {
            throw new InvalidKeyException("derived key is illegal parameter and stop");
        }
        if (salt.length < SALT_LEN) {
            throw new InvalidKeyException("salt is illegal parameter and stop");
        }
        SecretKeySpec keyspec = new SecretKeySpec(password, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(keyspec);
        USHasher.clearSecretKeySpec(keyspec);
        USHasher.clearByte(password);
        int hmacLength = mac.getMacLength();
        int ll = Math.max(derivekeyLength, hmacLength);
        int rr = derivekeyLength - (ll - 1) * hmacLength;
        byte[] deriveKey1 = new byte[ll * hmacLength];
        int tiOffset = 0;
        for (int i = 1; i <= ll; ++i) {
            USHasher.doUpdate(deriveKey1, tiOffset, mac, salt, iterationCount, i);
            tiOffset += hmacLength;
        }
        if (rr < hmacLength) {
            byte[] deriveKey2 = new byte[derivekeyLength];
            System.arraycopy(deriveKey1, 0, deriveKey2, 0, derivekeyLength);
            USHasher.clearByte(deriveKey1);
            return deriveKey2;
        }
        return deriveKey1;
    }

    private static void doUpdate(byte[] dest, int offset, Mac mac, byte[] src, int count, int blockIndex) {
        int hmacLength = mac.getMacLength();
        byte[] uResult = new byte[hmacLength];
        byte[] uIndex = new byte[src.length + 4];
        System.arraycopy(src, 0, uIndex, 0, src.length);
        uIndex[src.length] = (byte)(blockIndex / 0x1000000);
        uIndex[src.length + 1] = (byte)(blockIndex / 65536);
        uIndex[src.length + 2] = (byte)(blockIndex / 256);
        uIndex[src.length + 3] = (byte)blockIndex;
        for (int i = 0; i < count; ++i) {
            uIndex = mac.doFinal(uIndex);
            for (int j = 0; j < uResult.length; ++j) {
                int n = j;
                uResult[n] = (byte)(uResult[n] ^ uIndex[j]);
            }
        }
        System.arraycopy(uResult, 0, dest, offset, hmacLength);
        USHasher.clearByte(uResult);
    }

    private static void clearSecretKeySpec(SecretKeySpec keyspec) {
        try {
            Field field = SecretKeySpec.class.getDeclaredField("key");
            field.setAccessible(true);
            byte[] key = (byte[])field.get(keyspec);
            USHasher.clearByte(key);
        }
        catch (NoSuchFieldException e) {
            logger.error("Invalid Field:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Illegal Access:", (Throwable)e);
        }
    }

    private static void clearByte(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
    }

    public static byte[] getRandomSalt(int size) throws GeneralSecurityException {
        if (size < 8) {
            throw new GeneralSecurityException("Salt must greater than 8 bytes!");
        }
        if (size < 16) {
            logger.warn("[US-ENCRYPTOR] Salt value should be greater than or equal to 16.");
        }
        return HWEncryptor.getSalt((int)size);
    }

    public static String genHash(byte[] plaintext, byte[] salt, String algorithm, int iterCount) throws GeneralSecurityException {
        if (plaintext == null) {
            throw new GeneralSecurityException("The plaintext for hash is null!");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.reset();
            if (salt != null) {
                digest.update(salt);
            }
            digest.update(plaintext);
            byte[] bytes = digest.digest();
            for (int i = 0; i < iterCount; ++i) {
                digest.reset();
                bytes = digest.digest(bytes);
            }
            return HWEncoder.encodeForBase64((byte[])bytes, (boolean)false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException("Can't find hash algorithm " + algorithm + "!");
        }
    }

    public static String genHMAC(byte[] plaintext, SecretKey workingKey, String algorithm, int iterCount) throws GeneralSecurityException {
        if (iterCount < 0) {
            throw new GeneralSecurityException("Iteration count must not less than 0");
        }
        if (plaintext == null) {
            throw new GeneralSecurityException("The plaintext for HMAC is null");
        }
        try {
            Mac hmac = Mac.getInstance(algorithm);
            hmac.init(workingKey);
            hmac.update(plaintext, 0, plaintext.length);
            byte[] bytes = hmac.doFinal();
            hmac.reset();
            for (int i = 0; i < iterCount; ++i) {
                hmac.update(bytes, 0, bytes.length);
                bytes = hmac.doFinal();
            }
            return HWEncoder.encodeForBase64((byte[])bytes, (boolean)false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException("Can't find HMAC algorithm " + algorithm + "!");
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Key for HMAC algorithm is invalid!");
        }
    }
}

