/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.common.crypto.USCryptoBase;
import com.huawei.us.common.crypto.USCryptoConfig;
import com.huawei.us.common.crypto.USHasher;
import com.huawei.us.common.crypto.USKeyUtils;
import com.huawei.us.common.crypto.USMasterSalt;
import com.huawei.us.common.crypto.USRandomizer;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USKeyManager {
    private static final Logger logger = LoggerFactory.getLogger(USKeyManager.class);
    private static final String ALGORITHM = USCryptoConfig.ENCRYPTION_ALGORITHM;
    private static final int MASTER_KEY_LEN = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"keymanager.masterkey.length", (String)"32"));
    private static final int WORK_KEY_LEN = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"keymanager.workkey.length", (String)"32"));
    private static final int MASTER_KEY_ITERATION_COUNT = Integer.parseInt(SystemConfigUtil.getStringValueByName((String)"keymanager.masterkey.iteration_count", (String)"10000"));
    private static final String MASTER_FACTOR = USCryptoConfig.MASTER_KEY;
    private static final byte[] MASTER_SALT = USMasterSalt.getMasterSalt();
    private static final ConcurrentHashMap<String, SecretKey> WORK_KEY_CACHE_MAP = new ConcurrentHashMap();
    private static final long WORK_KEY_CACHE_LIFE_TIME_SEC = Long.parseLong(SystemConfigUtil.getStringValueByName((String)"keymanager.workkey.cache.lifetime", (String)"1800"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(2, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setUncaughtExceptionHandler((thd, exc) -> logger.error(thd.getName() + " : " + exc.getMessage()));
        thread.setDaemon(true);
        return thread;
    });

    private USKeyManager() {
    }

    public static SecretKey getWorkKey() throws IOException, EncryptionException, NoSuchAlgorithmException, InvalidKeyException {
        String keyStore = System.getenv("US_KEYMANAGER_STORE");
        if (StringUtils.isEmpty((CharSequence)keyStore)) {
            keyStore = SystemConfigUtil.getStringValueByName((String)"keymanager.store", (String)"");
            logger.info("load work key from config file.");
        } else {
            logger.info("load work key from environment.");
        }
        return USKeyManager.getWorkKey(keyStore);
    }

    public static SecretKey getWorkKey(String rawKeyString) throws IOException, EncryptionException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKey cachedWorkingKey = WORK_KEY_CACHE_MAP.get(rawKeyString);
        if (!Objects.isNull(cachedWorkingKey)) {
            return cachedWorkingKey;
        }
        SecretKey masterKey = USKeyManager.getMasterKey();
        PlainText workingKeyStr = USCryptoBase.decryptForPlainText(masterKey, rawKeyString, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
        SecretKeySpec plainWorkKey = new SecretKeySpec(USCodec.decodeFromBase64(workingKeyStr.toString()), ALGORITHM);
        WORK_KEY_CACHE_MAP.put(rawKeyString, plainWorkKey);
        SCHEDULED_EXECUTOR_SERVICE.schedule(() -> USKeyManager.clearWorkKey(rawKeyString), WORK_KEY_CACHE_LIFE_TIME_SEC, TimeUnit.SECONDS);
        return plainWorkKey;
    }

    public static String getNewWorkKeyCipher(byte[] rawWorkKeys) {
        try {
            PlainText keyStr = new PlainText(USCodec.encodeForBase64(rawWorkKeys));
            String cipher = USCryptoBase.encrypt(USKeyManager.getMasterKey(), keyStr, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION).getEncodedIVCipherText();
            return USCodec.encodeForHex(USCodec.decodeFromBase64(cipher));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | EncryptionException e) {
            return "";
        }
    }

    public static String getNewWorkKeyCipher() {
        byte[] newKey = USRandomizer.getRandomBytes(WORK_KEY_LEN);
        return USKeyManager.getNewWorkKeyCipher(newKey);
    }

    static SecretKey getMasterKey() throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] root = USKeyUtils.xorBase64Strings(MASTER_FACTOR, SystemConfigUtil.getStringValueByName((String)"keymanager.factor", (String)""));
        byte[] dkStr = USHasher.deriveKey(root, MASTER_SALT, MASTER_KEY_ITERATION_COUNT, MASTER_KEY_LEN);
        Arrays.fill(root, (byte)0);
        return new SecretKeySpec(dkStr, ALGORITHM);
    }

    private static void clearWorkKey(String wkKey) {
        if (WORK_KEY_CACHE_MAP.containsKey(wkKey)) {
            try {
                WORK_KEY_CACHE_MAP.get(wkKey).destroy();
            }
            catch (DestroyFailedException e) {
                logger.debug("destroy WorkKey failed!");
            }
        }
        WORK_KEY_CACHE_MAP.remove(wkKey);
    }

    private static void clearAllWorkKeys() {
        ((ConcurrentHashMap.KeySetView)WORK_KEY_CACHE_MAP.keySet()).forEach(USKeyManager::clearWorkKey);
    }

    static {
        Thread thread = new Thread(USKeyManager::clearAllWorkKeys);
        thread.setUncaughtExceptionHandler((thd, exc) -> logger.error(thd.getName() + " : " + exc.getMessage()));
        Runtime.getRuntime().addShutdownHook(thread);
    }
}

