/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.crypto.USRandomException;
import com.huawei.us.common.random.UsSecureRandom;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USRandomizer {
    private static final Logger logger = LoggerFactory.getLogger(USRandomizer.class);

    private USRandomizer() {
    }

    public static byte[] getRandomBytes(int length) {
        SecureRandom secureRandom;
        if (length < 1) {
            throw new IllegalArgumentException("random length must larger than 0");
        }
        byte[] result = new byte[length];
        try {
            secureRandom = UsSecureRandom.getInstance();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("UsSecureRandom create SecureRandom Error", (Throwable)e);
            throw new USRandomException("UsSecureRandom create SecureRandom Error", e);
        }
        secureRandom.nextBytes(result);
        return result;
    }
}

