/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.paas.alarm;

import com.huawei.us.common.crypto.USEncryptor;
import com.huawei.us.common.random.UsSecureRandom;
import com.huawei.us.paas.alarm.alertdata.FstAlertPojo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.owasp.esapi.errors.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertSender {
    private static final Logger logger = LoggerFactory.getLogger(AlertSender.class);
    private static final String KUBECFG_FILE_PATH = "/var/paas/srv/kubernetes/kubecfg.crt";
    private static final String KEYSTORE_FILE_PATH = "/etc/secrets/alm-certs/keystore.jks";
    private static final String KEYSTORE_PASS_PATH = "/etc/secrets/alm-certs/keystore-pass.txt";
    private static final String TRUSTSTORE_FILE_PATH = "/etc/secrets/alm-certs/truststore.jks";
    private static final String TRUSTSTORE_PASS_PATH = "/etc/secrets/alm-certs/truststore-pass.txt";
    private static final String ALM_HOST_DOMAIN = "alm-almreceiver.om.svc.cluster.local";
    private static int alm_host_port = -1;
    private static CloseableHttpClient senderClient = null;
    private static String almServerIp = null;
    private static boolean isInit = false;

    public static void init(String almIp, int almPort) {
        if (!isInit) {
            if (AlertSender.initHttpClient()) {
                AlertSender.setAlarmIpAndPort(almIp, almPort);
                isInit = true;
            }
        } else {
            logger.warn("alert sender has been initialized, please reset first.");
        }
    }

    private static boolean initHttpClient() {
        TrustManagerFactory localTmf;
        KeyManagerFactory localKmf;
        try (FileInputStream keyStoreStream = new FileInputStream(KEYSTORE_FILE_PATH);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(KEYSTORE_PASS_PATH), StandardCharsets.UTF_8));){
            String keystorePassLine = bufferedReader.readLine();
            keystorePassLine = StringUtils.isEmpty((CharSequence)keystorePassLine) ? "" : keystorePassLine;
            String keyStorePass = USEncryptor.decrypt(keystorePassLine.split(":", 2)[1].trim());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, keyStorePass.toCharArray());
            localKmf = KeyManagerFactory.getInstance("SunX509");
            localKmf.init(keyStore, keyStorePass.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | EncryptionException e) {
            logger.error("load certificates and private key from keystore failed");
            return false;
        }
        catch (IOException e) {
            logger.error("load keystore file failed", (Throwable)e);
            return false;
        }
        try (FileInputStream trustStoreStream = new FileInputStream(TRUSTSTORE_FILE_PATH);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(TRUSTSTORE_PASS_PATH), StandardCharsets.UTF_8));){
            String truststorePassLine = bufferedReader.readLine();
            truststorePassLine = StringUtils.isEmpty((CharSequence)truststorePassLine) ? "" : truststorePassLine;
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(trustStoreStream, USEncryptor.decrypt(truststorePassLine.split(":", 2)[1].trim()).toCharArray());
            localTmf = TrustManagerFactory.getInstance("SunX509");
            localTmf.init(trustStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException | EncryptionException e) {
            logger.error("load certificates from truststore failed");
            return false;
        }
        catch (IOException e) {
            logger.error("load truststore file failed", (Throwable)e);
            return false;
        }
        return AlertSender.setSenderClient(localKmf, localTmf);
    }

    private static boolean setSenderClient(KeyManagerFactory localKmf, TrustManagerFactory localTmf) {
        SecureRandom secureRandom = null;
        try {
            secureRandom = UsSecureRandom.getInstance();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("UsSecureRandom create SecureRandom Error", (Throwable)e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(localKmf.getKeyManagers(), localTmf.getTrustManagers(), secureRandom);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            senderClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("init http request client failed");
            return false;
        }
        return true;
    }

    private static String getAlarmIP() {
        if (almServerIp != null) {
            return almServerIp;
        }
        logger.warn("alarm server ip is not set, use default domain name");
        return ALM_HOST_DOMAIN;
    }

    private static String getAlarmUrl() {
        StringBuilder urlStringBuilder = new StringBuilder();
        urlStringBuilder.append("https://");
        urlStringBuilder.append(AlertSender.getAlarmIP());
        urlStringBuilder.append(":");
        urlStringBuilder.append(alm_host_port);
        urlStringBuilder.append("/rest/plat/fmrecv/v1/alarms");
        return urlStringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchUserId() {
        try (FileInputStream cerFileInputStream = new FileInputStream(new File(KUBECFG_FILE_PATH));){
            BufferedInputStream bufferedInputStream = new BufferedInputStream(cerFileInputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            Certificate certificate = certificateFactory.generateCertificate(bufferedInputStream);
            if (!(certificate instanceof X509Certificate)) return null;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String subjectStr = x509Certificate.getSubjectX500Principal().getName("RFC1779");
            String string = subjectStr.split("1.1.1.2=")[1].split(":")[1];
            return string;
        }
        catch (IOException | CertificateException e) {
            logger.error("load config file for userid in alert failed", (Throwable)e);
        }
        return null;
    }

    public static void reset() {
        try {
            if (senderClient != null) {
                senderClient.close();
            }
        }
        catch (IOException e) {
            logger.error("cannot close current sender client, reset failed");
            return;
        }
        senderClient = null;
        almServerIp = null;
        isInit = false;
    }

    public static void setAlarmIpAndPort(String almIp, int almPort) {
        almServerIp = almIp;
        alm_host_port = almPort;
    }

    public static boolean sendMsg(String alertJsonString) {
        String alertPayload = String.format(Locale.ENGLISH, "{\"alarms\":\"%s\"}", alertJsonString.replace("\"", "\\\""));
        return AlertSender.sendFormattedAlert(alertPayload);
    }

    public static boolean sendMsg(FstAlertPojo fstAlert) {
        String userId = AlertSender.fetchUserId();
        fstAlert.setUserId(userId);
        return AlertSender.sendFormattedAlert(fstAlert.getAlertString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendFormattedAlert(String formattedAlert) {
        block31: {
            if (!isInit) {
                logger.error("alert sender is not initialized, please init sender client first.");
                return false;
            }
            if (senderClient == null) {
                logger.error("senderClient is not initialized, please reset and init sender client first.");
                return false;
            }
            try {
                HttpPost alertHttpPost = new HttpPost(AlertSender.getAlarmUrl());
                alertHttpPost.addHeader("Content-Type", (Object)"application/json; charset=UTF-8");
                logger.debug("try to send alert string:{}", (Object)formattedAlert);
                alertHttpPost.setEntity((HttpEntity)new StringEntity(formattedAlert, Charset.forName("UTF-8")));
                CloseableHttpResponse alertResponse = senderClient.execute((ClassicHttpRequest)alertHttpPost);
                if (alertResponse.getCode() == 200) {
                    EntityUtils.consume((HttpEntity)alertResponse.getEntity());
                    boolean bl = true;
                    return bl;
                }
                HttpEntity failedHttpEntity = alertResponse.getEntity();
                if (failedHttpEntity == null) break block31;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(failedHttpEntity.getContent(), Charset.forName("UTF-8")));){
                    String msgStr;
                    StringBuilder failedMsgStrBuilder = new StringBuilder();
                    while ((msgStr = bufferedReader.readLine()) != null) {
                        failedMsgStrBuilder.append(msgStr);
                    }
                    logger.info(failedMsgStrBuilder.toString());
                }
            }
            catch (IOException e) {
                logger.error("send alert request failed", (Throwable)e);
            }
            finally {
                if (senderClient != null) {
                    try {
                        senderClient.close();
                    }
                    catch (IOException e) {
                        logger.error("close sender client error:", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }
}

