/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm;

import com.huawei.us.psm.constant.EnumAlgoType;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PsmCryptoUtil {
    private PsmCryptoUtil() {
    }

    public static Cipher getCipherInstance(byte[] key, byte[] iv, EnumAlgoType algoType, int cipherMode) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        AlgorithmParameterSpec algorithmParameterSpec;
        String algoParamString;
        if (EnumAlgoType.AES_GCM_LONG.equals((Object)algoType)) {
            algoParamString = "AES/GCM/NoPadding";
            algorithmParameterSpec = new GCMParameterSpec(128, iv);
        } else {
            algoParamString = "AES/CBC/PKCS5Padding";
            algorithmParameterSpec = new IvParameterSpec(iv);
        }
        Cipher cipher = Cipher.getInstance(algoParamString);
        cipher.init(cipherMode, (Key)new SecretKeySpec(key, "AES"), algorithmParameterSpec);
        return cipher;
    }
}

