/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.psm.ICipherMetaGetter;
import com.huawei.us.psm.PsmCryptoUtil;
import com.huawei.us.psm.constant.EnumAlgoType;
import com.huawei.us.psm.pojo.CipherStructureV1;
import com.huawei.us.psm.pojo.CipherStructureV2;
import com.huawei.us.psm.pojo.KeyStructure;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsmKeyDecryptor {
    private static final Logger logger = LoggerFactory.getLogger(PsmKeyDecryptor.class);
    private static final char[] HARD_CODED_MATERIAL = new char[]{'\u00c6', '\u00ab', 'P', '7', '\u00e6', '\u00fb', 'n', '\u00c1', 'G', '%', 'h', '\u00f7', '\u00d3', ':', ' ', '!', '\u0006', '\u00ea', '\u0017', 'y', 'O', '\u00c2', '\u00a0', '\u0000', '}', '\u00d3', '\u00bc', '5', 't', '_', 'l', '\f', '\u0014', '\u0097', '\u009a', '\u00f5', '\u00c2', '\u00f8', 'y', '\u00a6', 'P', '7', '#', '\u00e5', '\u00a5', '\u00cd', '\u001d', 'J', '\u00a8', '\u00cd', '\u008d', '^', '\u0003', '\u00ab', '\u00b8', '\u009d', '\u00bf', ']', ',', 'V', ':', '\u00c9', '0', '\u00cc', '\u00df', '\u00c4', '\u00b3', '\u00b6', 'k', '\u00f8', '\u00fe', '\u00fa', 's', '\u00e5', '\u00ac', '\u00f5', '\u00d9', '+', '\u00de', '\u000b', '\u0003', '\u0003', '\u00a1', '\u001c', 'b', '\u00c5', '\u00a0', '\u00a8', '\u00a7', '\u000e', 'h', '\u0098', 'c', '?', '\f', '=', 'D', '\u0087', 'z', '\u001b', '\u00bc', '\u00b9', 'q', '\u0090', '\u00de', '?', '\u00cd', 'w', 'm', '\u00af', '\u0001', '\u0014', '\u0099', '\u00fa', '\u00e4', '\f', '\u0019', '\r', '\u0019', '\u009f', '\u00cd', '\u00b8', '\u00b9', '\u0090', '\u00e3', ')', '\u00f4', '\u00cc', '_', '\u00a0', 'I', ')', '*', 's', 'b', '\u00ae', '\u0090', '\u00a4', '\u0013', '\u00f0', '\u00b8', '\u00f1', '\u00bb', '>', '\u00c4', '\u0015', 't', '\u00ca', '\u00f5', '\u0092', '\u00fe', 'I', '\u00ec', 'F', '8', '^', '#', '\u00cf', '2', '\u00a8', '\u00b4', 'F', '\u0087', '4', '\u00c6', '\u00d5', 'b', '\u00d3', 'q', '\u00a2', '\u009f', '\u00a1', '\u00a0', '\t', '\u00a8', '\u00e7', '\u00e6', 'a', '{', '\u00ad', '\u00d0', '\u00fb', '\u00ea', '\u00b1', 'W', '(', '\u0012', '\u00c7', '\u00aa', '\f', '\u0095', 'e', 'v', '5', '\u009f', '@', '\u00f3', '}', '\u00e5', ':', '\u00ab', '\u00cf', '\u00e9', 'M', '\u009c', '\u00a8', '\u00e4', 'A', '\u00a4', 'd', '\u00f7', '\u00cf', '\u0080', '\u00e4', '\u00c0', '+', '\u00dd', '!', '\u0099', '\u00c2', '\u001f', ';', 's', '?', '\u0002', '\u0015', 'f', 'u', '\u00be', '\u00b9', '\u008d', '\u00a6', '%', '\u00cb', '\u0083', '\u00d0', '\u00a7', '\u00d3', '\u0001', '$', 'f', '[', '\u0083', '\u0085', 'r', '?', '\u00a4', 'Q', 's', 'B', '\u00d6', '\u00b2', 'Q', '\u00a2', '\u00a5', '\u00cd', '6', '\u00d8', '>', '\u0013', '\u00e1', 'k', '\"', '-', 'n', '\u00f8', '\u00b5', 'h', ':', 'a', 'A', 'S', '\u00df', 'u', '\u00b0', '}', '\u0099', '\u00a9', '\u00db', '2', '\u001f', '\u00e0', '\u00f7', '\u00ca', 'L', '\u0094', '&', 't', ')', '\u0012', 's', '\u00f1', '\u0092', '6', 'Z', 'W', '\u001c', 'v', '\u00a6', '\u0081', '\u00c5', '\u0004', '\u00df', '\u001f', 'D', '\u000b', '\u008c', '\u00d0', '@', '\u00e7', '\u00e7', '\u00e1', '\u00e0', '\u0011', '\u00a4', 'g', '\u0011', '\u00fb', '=', '\u0083', '\u0097', '$', '\u000f', '\u0000', 'A', '\u00fd', 'a', '\u00b9', 'r', '\u0099', '\u00af', '\u00e4', '\'', '7', 'w', 'E', 'X', '\u00c5', '\u00a0', '\u009a', '\u00c3', '{', '\u0097', '\u0014', '\u00d8', '\u00d3', 'r', '!', '\u00c7', '\u0003', '\u00c7', 's', '\u00b0', '\u00d9', 'l', '\u00b1', 'r', '-', '\u00fb', 'r', '\u00ce', 'Q', 'i', '\u000f', '3', 'c', '\u00db', '\u0097', '\u001b', '|', '\u00ec', '\u00bc', '\u0007', '\u00ec', 'n', '\u0089', '\u00c1', '3', '\u00bd', '\u00ab', 'm', '\u0018', 'O', '\u0085', '\u0087', '\u00fa', '\u00dd', '\u00bb', '>', 'L', '\u0015', '0', '\u0093', '\u0080', '\u00f7', '\u007f', '\u0096', '\t', '\u00d6', '\u00ab', 'n', 'q', '2', '\u00d2', '\u001d', '\u00fd', '\u00ef', '\u00ac', 'R', '\u0086', '\u00e5', '\u0003', 'C', '\u00ad', '\u00e2', '2', 'd', '\u009d', '\u00a4', '\u00bc', '\u00c5', '\u00b8', '\'', '\u0000', '\u00ca', '\u0095', '\u00ad', '\u001f', 'V', '\u0085', '\t', '\u00bb', '\u00e9', 'y', '\u00bf', 'F', '\u00c0', '\u00f0', '\u001f', '\u0014', '{', '\u00a8', '\u0000', '\u0083', '\u0012', '\u00a9', '@', '`', '\u00bd', '\u0011', '\u0089', '\"', '\u00ed', '\u00dc', '%', '\u00e7', 'i', '\u00bb', '\u00e2', '\u00f4', '\u00b8', '\u0098', '\u00cc', '?', '\u00bb', '\u001d', '\u008b', '\u00ef', 'z', '\u0084', '\u00cc', '\u0017', '\u00b8', '\u0096', 'w', '\u00ae', '\u009a', 's', '\u00b9', '\u00b9', '\u0097', '\u0091', '\u00d6', '\u00b9', '\u00f8', 'Q', '\u0004', '\u00c0', '\u00a6', '%', 'B', '\n', 'L', '\u00f2', '\u00f8', '\u00c1', 'H', 'J', '\u00f2', '\u00fd', '\u008e', '\u00c1', '\f', '\u0096', '\u00ee', '\u0005', '\u00ed', ',', '\u00a3', '\u00be', '\u00df', '\u00a2'};
    private static Map<Integer, KeyStructure> rootKeyMap = new HashMap<Integer, KeyStructure>();
    private static Map<Integer, KeyStructure> sharedKeyMap = new HashMap<Integer, KeyStructure>();
    private static boolean isInit = false;

    public static void clearKeyMap() {
        sharedKeyMap.clear();
        rootKeyMap.clear();
        isInit = false;
    }

    public static void initDecryptor(String rootKeyPath, String sharedKeyPath) throws IOException {
        PsmKeyDecryptor.loadRootKeys(rootKeyPath);
        PsmKeyDecryptor.loadSharedKeys(sharedKeyPath);
        isInit = true;
    }

    public static void initDecryptorByKeyValue(String rootKey, String sharedKey) throws IOException {
        PsmKeyDecryptor.loadRootKeysByKeyValue(rootKey);
        PsmKeyDecryptor.loadSharedKeysByKeyValue(sharedKey);
        isInit = true;
    }

    private static void loadRootKeysByKeyValue(String rootKey) throws IOException {
        byte[] rootKeyBytes = USCodec.decodeFromBase64(rootKey);
        PsmKeyDecryptor.loadKeyBytes(rootKeyMap, rootKeyBytes);
    }

    private static void loadSharedKeysByKeyValue(String sharedKey) throws IOException {
        byte[] sharedKeyBytes = USCodec.decodeFromBase64(sharedKey);
        PsmKeyDecryptor.loadKeyBytes(sharedKeyMap, sharedKeyBytes);
    }

    static byte[] getRawSharedKey(int keyId) {
        KeyStructure sharedKey = sharedKeyMap.get(keyId);
        if (sharedKey == null) {
            throw new IllegalArgumentException("common shared key not matched with cipher text");
        }
        if (sharedKey.isEncrypted()) {
            CipherStructureV1 cipherStructureV1 = new CipherStructureV1(sharedKey.getMaterialBytes());
            KeyStructure rootKey = PsmKeyDecryptor.getRootKey(cipherStructureV1.getKeyId());
            if (cipherStructureV1.getVersion() == 1) {
                return PsmKeyDecryptor.pbkdf2AndDecrypt(PsmKeyDecryptor.getXorHexString(rootKey.getMaterialBytes(), rootKey.getMaterialLen()).toCharArray(), rootKey.getKeyLen(), Arrays.copyOfRange(sharedKey.getMaterialBytes(), 24, sharedKey.getMaterialLen()), cipherStructureV1.getIv(), rootKey, EnumAlgoType.AES_CBC_SHORT);
            }
            if (cipherStructureV1.getVersion() == 2) {
                CipherStructureV2 cipherStructureV2 = new CipherStructureV2(sharedKey.getMaterialBytes());
                if (!Arrays.equals(cipherStructureV2.getMaterialHash(), rootKey.getChecksum())) {
                    throw new IllegalArgumentException("common shared key not matched with root key");
                }
                return PsmKeyDecryptor.pbkdf2AndDecrypt(PsmKeyDecryptor.getXorHexString(rootKey.getMaterialBytes(), rootKey.getMaterialLen()).toCharArray(), cipherStructureV2.getAlgoType().getKeyLen(), Arrays.copyOfRange(sharedKey.getMaterialBytes(), 100, sharedKey.getMaterialLen()), Arrays.copyOfRange(cipherStructureV2.getIv(), 0, 12), cipherStructureV2, cipherStructureV2.getAlgoType());
            }
            throw new IllegalStateException("unknown version of common shared key");
        }
        return sharedKey.getMaterialBytes();
    }

    static byte[] generatePbkdf2HashedBytes(char[] password, byte[] salt, int iteration, int keyLength, String kdfType) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iteration, keyLength);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(kdfType);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("generate pbkdf2 hashed bytes failed");
        }
    }

    private static String getXorHexString(byte[] inBytes, int length) {
        if (ArrayUtils.isEmpty((byte[])inBytes) || inBytes.length < length || HARD_CODED_MATERIAL.length < length) {
            throw new IllegalArgumentException("input byte array is null or length is out of bound when getting xor hex bytes");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char xorMaterialEle = (char)(0xFF & HARD_CODED_MATERIAL[i] ^ inBytes[i]);
            sb.append(String.format(Locale.ENGLISH, "%02X", (byte)xorMaterialEle));
        }
        return sb.toString();
    }

    static String getHexString(byte[] inBytes) {
        if (ArrayUtils.isEmpty((byte[])inBytes)) {
            throw new IllegalArgumentException("input byte array is null when getting hex bytes");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : inBytes) {
            stringBuilder.append(String.format(Locale.ENGLISH, "%02X", b));
        }
        return stringBuilder.toString();
    }

    private static byte[] parseHexString(String hexString) {
        try {
            return DatatypeConverter.parseHexBinary((String)hexString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cipher is not hex string, please check it");
        }
    }

    private static KeyStructure getRootKey(int keyId) {
        KeyStructure rootKey = rootKeyMap.get(keyId);
        if (Objects.isNull(rootKey)) {
            throw new IllegalArgumentException("cannot find root key by keyId");
        }
        return rootKey;
    }

    static KeyStructure getSharedKey(int keyId) {
        KeyStructure sharedKey = sharedKeyMap.get(keyId);
        if (Objects.isNull(sharedKey)) {
            throw new IllegalArgumentException("cannot find shared key by keyId");
        }
        return sharedKey;
    }

    private static void loadSharedKeys(String sharedKeyPath) throws IOException {
        try {
            byte[] sharedKeyBytes = Files.readAllBytes(Paths.get(sharedKeyPath, new String[0]));
            PsmKeyDecryptor.loadKeyBytes(sharedKeyMap, sharedKeyBytes);
        }
        catch (IOException e) {
            logger.error("load shared key file error: ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static void loadRootKeys(String rootKeyPath) throws IOException {
        try {
            byte[] rootKeyBytes = Files.readAllBytes(Paths.get(rootKeyPath, new String[0]));
            PsmKeyDecryptor.loadKeyBytes(rootKeyMap, rootKeyBytes);
        }
        catch (IOException e) {
            logger.error("load root key file error: ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static void loadKeyBytes(Map<Integer, KeyStructure> keyMap, byte[] keyBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(keyBytes).asReadOnlyBuffer();
        while (byteBuffer.hasRemaining()) {
            byte[] sharedKeyBlock = new byte[1024];
            byteBuffer.get(sharedKeyBlock);
            KeyStructure key = new KeyStructure(sharedKeyBlock);
            keyMap.put(key.getId(), key);
        }
    }

    public static String decrypt(String ciphertext) {
        if (isInit) {
            byte[] cipherBytes = PsmKeyDecryptor.parseHexString(ciphertext.trim());
            CipherStructureV1 cipherStructureV1 = new CipherStructureV1(cipherBytes);
            char[] sharedKeyCharArray = PsmKeyDecryptor.getHexString(PsmKeyDecryptor.getRawSharedKey(cipherStructureV1.getKeyId())).toCharArray();
            if (cipherStructureV1.getVersion() == 1) {
                KeyStructure sharedKey = PsmKeyDecryptor.getSharedKey(cipherStructureV1.getKeyId());
                byte[] rawCipherBytes = Arrays.copyOf(cipherStructureV1.getCipherText(), cipherStructureV1.getCipherText().length);
                return new String(PsmKeyDecryptor.pbkdf2AndDecrypt(sharedKeyCharArray, sharedKey.getKeyLen(), rawCipherBytes, cipherStructureV1.getIv(), sharedKey, EnumAlgoType.AES_CBC_SHORT), StandardCharsets.UTF_8);
            }
            if (cipherStructureV1.getVersion() == 2) {
                CipherStructureV2 cipherStructureV2 = new CipherStructureV2(cipherBytes);
                byte[] rawCipherBytes = Arrays.copyOf(cipherStructureV2.getCipherText(), cipherStructureV2.getCipherText().length);
                return new String(PsmKeyDecryptor.pbkdf2AndDecrypt(sharedKeyCharArray, cipherStructureV2.getAlgoType().getKeyLen(), rawCipherBytes, Arrays.copyOfRange(cipherStructureV2.getIv(), 0, 12), cipherStructureV2, cipherStructureV2.getAlgoType()), StandardCharsets.UTF_8);
            }
        } else {
            logger.error("decryptor is not initialized yet");
        }
        return "";
    }

    private static byte[] pbkdf2AndDecrypt(char[] key, int keyLength, byte[] rawCipherBytes, byte[] iv, ICipherMetaGetter iCipherMetaGetter, EnumAlgoType algoType) {
        byte[] hashedKey = PsmKeyDecryptor.generatePbkdf2HashedBytes(key, iCipherMetaGetter.getSalt(), iCipherMetaGetter.getIteration(), keyLength, iCipherMetaGetter.getKdfType());
        return PsmKeyDecryptor.decryptCipher(hashedKey, iv, rawCipherBytes, algoType);
    }

    private static byte[] decryptCipher(byte[] key, byte[] iv, byte[] data, EnumAlgoType algoType) {
        try {
            Cipher cipher = PsmCryptoUtil.getCipherInstance(key, iv, algoType, 2);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    static int getFirstSharedKeyId() {
        return sharedKeyMap.entrySet().iterator().next().getValue().getId();
    }

    static int getLastSharedKeyId() {
        return sharedKeyMap.size();
    }
}

