/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm;

import com.huawei.us.common.crypto.USRandomizer;
import com.huawei.us.psm.PsmCryptoUtil;
import com.huawei.us.psm.PsmKeyDecryptor;
import com.huawei.us.psm.constant.EnumAlgoType;
import com.huawei.us.psm.pojo.CipherStructureV1;
import com.huawei.us.psm.pojo.CipherStructureV2;
import com.huawei.us.psm.pojo.KeyStructure;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsmKeyEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(PsmKeyEncryptor.class);
    private static final int IV_SIZE = 16;

    public static void clearKeyMap() {
        PsmKeyDecryptor.clearKeyMap();
    }

    public static void init(String rootKeyPath, String commonSharedKeyPath) throws IOException {
        PsmKeyDecryptor.initDecryptor(rootKeyPath, commonSharedKeyPath);
    }

    public static String encryptForV1(String plaintext) {
        int keyId = PsmKeyDecryptor.getLastSharedKeyId();
        KeyStructure sharedKey = PsmKeyDecryptor.getSharedKey(keyId);
        String rawSharedKeyBytes = PsmKeyDecryptor.getHexString(PsmKeyDecryptor.getRawSharedKey(keyId));
        byte[] ivBytes = USRandomizer.getRandomBytes(16);
        byte[] toEncKeyBytes = PsmKeyDecryptor.generatePbkdf2HashedBytes(rawSharedKeyBytes.toCharArray(), sharedKey.getSalt(), sharedKey.getIteration(), sharedKey.getKeyLen(), sharedKey.getKdfType());
        byte[] cipherText = PsmKeyEncryptor.baseEncrypt(toEncKeyBytes, ivBytes, plaintext.getBytes(StandardCharsets.UTF_8), EnumAlgoType.AES_CBC_SHORT);
        CipherStructureV1 cipher = CipherStructureV1.builder().keyId(keyId).iv(ivBytes).cipherText(cipherText).build();
        return PsmKeyDecryptor.getHexString(CipherStructureV1.marshal(cipher));
    }

    public static String encryptForV2(String plaintext) {
        int keyId = PsmKeyDecryptor.getLastSharedKeyId();
        KeyStructure sharedKey = PsmKeyDecryptor.getSharedKey(keyId);
        String rawSharedKeyBytes = PsmKeyDecryptor.getHexString(PsmKeyDecryptor.getRawSharedKey(keyId));
        byte[] ivBytes = USRandomizer.getRandomBytes(16);
        EnumAlgoType algoType = EnumAlgoType.AES_GCM_LONG;
        byte[] toEncKeyBytes = PsmKeyDecryptor.generatePbkdf2HashedBytes(rawSharedKeyBytes.toCharArray(), sharedKey.getSalt(), sharedKey.getIteration(), algoType.getKeyLen(), sharedKey.getKdfType());
        byte[] cipherText = PsmKeyEncryptor.baseEncrypt(toEncKeyBytes, Arrays.copyOfRange(ivBytes, 0, 12), plaintext.getBytes(StandardCharsets.UTF_8), algoType);
        CipherStructureV2 cipher = CipherStructureV2.builder().keyId(keyId).iteration(sharedKey.getIteration()).salt(sharedKey.getSalt()).kdfType(sharedKey.getKdfTypeInt()).materialHash(sharedKey.getChecksum()).iv(ivBytes).algoType(algoType).cipherText(cipherText).build();
        return PsmKeyDecryptor.getHexString(CipherStructureV2.marshal(cipher));
    }

    private static byte[] baseEncrypt(byte[] key, byte[] iv, byte[] data, EnumAlgoType algoType) {
        try {
            Cipher cipher = PsmCryptoUtil.getCipherInstance(key, iv, algoType, 1);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }
}

