/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm.pojo;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class CipherStructureV1 {
    public static final int CIPHER_HEADER_LEN = 24;
    public static final int EDITION = 1;
    private int version;
    private int keyId;
    private byte[] iv;
    private byte[] cipherText;

    public CipherStructureV1(byte[] rawBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawBytes).asReadOnlyBuffer();
        this.version = byteBuffer.getInt();
        this.keyId = byteBuffer.getInt();
        this.iv = new byte[16];
        byteBuffer.get(this.iv);
        this.cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(this.cipherText);
    }

    public static byte[] marshal(CipherStructureV1 cipherStructureV1) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(24 + cipherStructureV1.cipherText.length);
        byteBuffer.putInt(1);
        byteBuffer.putInt(cipherStructureV1.keyId);
        byteBuffer.put(cipherStructureV1.iv);
        byteBuffer.put(cipherStructureV1.cipherText);
        return byteBuffer.array();
    }

    public static CipherStructureV1Builder builder() {
        return new CipherStructureV1Builder();
    }

    public CipherStructureV1(int version, int keyId, byte[] iv, byte[] cipherText) {
        this.version = version;
        this.keyId = keyId;
        this.iv = iv;
        this.cipherText = cipherText;
    }

    public int getVersion() {
        return this.version;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    public static class CipherStructureV1Builder {
        private int version;
        private int keyId;
        private byte[] iv;
        private byte[] cipherText;

        CipherStructureV1Builder() {
        }

        public CipherStructureV1Builder version(int version) {
            this.version = version;
            return this;
        }

        public CipherStructureV1Builder keyId(int keyId) {
            this.keyId = keyId;
            return this;
        }

        public CipherStructureV1Builder iv(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public CipherStructureV1Builder cipherText(byte[] cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public CipherStructureV1 build() {
            return new CipherStructureV1(this.version, this.keyId, this.iv, this.cipherText);
        }

        public String toString() {
            return "CipherStructureV1.CipherStructureV1Builder(version=" + this.version + ", keyId=" + this.keyId + ", iv=" + Arrays.toString(this.iv) + ", cipherText=" + Arrays.toString(this.cipherText) + ")";
        }
    }
}

