/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm.pojo;

import com.huawei.us.psm.ICipherMetaGetter;
import com.huawei.us.psm.constant.EnumAlgoType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class CipherStructureV2
implements ICipherMetaGetter {
    public static final int CIPHER_HEADER_LEN = 100;
    public static final int EDITION = 2;
    private int version;
    private int keyId;
    private byte[] materialHash;
    private int kdfType;
    private int iteration;
    private byte[] salt;
    private EnumAlgoType algoType;
    private byte[] iv;
    private byte[] cipherText;

    public CipherStructureV2(byte[] rawBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawBytes).asReadOnlyBuffer();
        this.version = byteBuffer.getInt();
        this.keyId = byteBuffer.getInt();
        this.materialHash = new byte[32];
        byteBuffer.get(this.materialHash);
        this.kdfType = byteBuffer.getInt();
        this.iteration = byteBuffer.getInt();
        this.salt = new byte[32];
        byteBuffer.get(this.salt);
        this.algoType = EnumAlgoType.getFromId(byteBuffer.getInt());
        this.iv = new byte[16];
        byteBuffer.get(this.iv);
        this.cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(this.cipherText);
    }

    @Override
    public String getKdfType() {
        if (this.kdfType == 1) {
            return "PBKDF2WithHmacSHA1";
        }
        if (this.kdfType == 2) {
            return "PBKDF2WithHmacSHA256";
        }
        return null;
    }

    public static byte[] marshal(CipherStructureV2 cipherStructureV2) {
        if (Objects.isNull(cipherStructureV2)) {
            throw new IllegalArgumentException("cipher is null");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(100 + cipherStructureV2.cipherText.length);
        byteBuffer.putInt(2);
        byteBuffer.putInt(cipherStructureV2.keyId);
        byteBuffer.put(cipherStructureV2.materialHash);
        byteBuffer.putInt(cipherStructureV2.kdfType);
        byteBuffer.putInt(cipherStructureV2.iteration);
        byteBuffer.put(cipherStructureV2.salt);
        byteBuffer.putInt(cipherStructureV2.algoType.getId());
        byteBuffer.put(cipherStructureV2.iv);
        byteBuffer.put(cipherStructureV2.cipherText);
        return byteBuffer.array();
    }

    public static CipherStructureV2Builder builder() {
        return new CipherStructureV2Builder();
    }

    public CipherStructureV2(int version, int keyId, byte[] materialHash, int kdfType, int iteration, byte[] salt, EnumAlgoType algoType, byte[] iv, byte[] cipherText) {
        this.version = version;
        this.keyId = keyId;
        this.materialHash = materialHash;
        this.kdfType = kdfType;
        this.iteration = iteration;
        this.salt = salt;
        this.algoType = algoType;
        this.iv = iv;
        this.cipherText = cipherText;
    }

    public int getVersion() {
        return this.version;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public byte[] getMaterialHash() {
        return this.materialHash;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public EnumAlgoType getAlgoType() {
        return this.algoType;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    public static class CipherStructureV2Builder {
        private int version;
        private int keyId;
        private byte[] materialHash;
        private int kdfType;
        private int iteration;
        private byte[] salt;
        private EnumAlgoType algoType;
        private byte[] iv;
        private byte[] cipherText;

        CipherStructureV2Builder() {
        }

        public CipherStructureV2Builder version(int version) {
            this.version = version;
            return this;
        }

        public CipherStructureV2Builder keyId(int keyId) {
            this.keyId = keyId;
            return this;
        }

        public CipherStructureV2Builder materialHash(byte[] materialHash) {
            this.materialHash = materialHash;
            return this;
        }

        public CipherStructureV2Builder kdfType(int kdfType) {
            this.kdfType = kdfType;
            return this;
        }

        public CipherStructureV2Builder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public CipherStructureV2Builder salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public CipherStructureV2Builder algoType(EnumAlgoType algoType) {
            this.algoType = algoType;
            return this;
        }

        public CipherStructureV2Builder iv(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public CipherStructureV2Builder cipherText(byte[] cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public CipherStructureV2 build() {
            return new CipherStructureV2(this.version, this.keyId, this.materialHash, this.kdfType, this.iteration, this.salt, this.algoType, this.iv, this.cipherText);
        }

        public String toString() {
            return "CipherStructureV2.CipherStructureV2Builder(version=" + this.version + ", keyId=" + this.keyId + ", materialHash=" + Arrays.toString(this.materialHash) + ", kdfType=" + this.kdfType + ", iteration=" + this.iteration + ", salt=" + Arrays.toString(this.salt) + ", algoType=" + (Object)((Object)this.algoType) + ", iv=" + Arrays.toString(this.iv) + ", cipherText=" + Arrays.toString(this.cipherText) + ")";
        }
    }
}

