/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.psm.pojo;

import com.huawei.us.psm.ICipherMetaGetter;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStructure
implements ICipherMetaGetter {
    public static final int KEY_BLOCK_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(KeyStructure.class);
    private byte version;
    private byte[] timestamp = new byte[3];
    private int id;
    private int kdfType;
    private int iteration;
    private int keyLen;
    private byte[] salt = new byte[32];
    private int materialLen;
    private boolean isEncrypt;
    private byte[] name = new byte[23];
    private byte[] localRandId = new byte[16];
    private byte[] encRandId = new byte[16];
    private byte[] reserved1 = new byte[16];
    private byte[] material = new byte[864];
    private byte[] checksum = new byte[32];

    public KeyStructure(byte[] rootkeyBlock) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rootkeyBlock).asReadOnlyBuffer();
        this.version = byteBuffer.get();
        byteBuffer.get(this.timestamp);
        this.id = byteBuffer.getInt();
        this.kdfType = byteBuffer.getInt();
        this.iteration = byteBuffer.getInt();
        this.keyLen = byteBuffer.getInt();
        byteBuffer.get(this.salt);
        this.materialLen = byteBuffer.getInt();
        this.isEncrypt = byteBuffer.get() == 1;
        byteBuffer.get(this.name);
        byteBuffer.get(this.localRandId);
        byteBuffer.get(this.encRandId);
        byteBuffer.get(this.reserved1);
        byteBuffer.get(this.material);
        byteBuffer.get(this.checksum);
        this.checkCheckSum(rootkeyBlock);
    }

    private void checkCheckSum(byte[] rootkeyBlock) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashed = digest.digest(Arrays.copyOf(rootkeyBlock, 1024 - this.checksum.length));
            if (!Arrays.equals(hashed, this.checksum)) {
                logger.error("checksum not matched!");
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("calc checksum error: ", (Throwable)e);
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getMaterialBytes() {
        return (byte[])this.material.clone();
    }

    public byte getMaterial(int index) {
        return this.material[index];
    }

    public boolean isEncrypted() {
        return this.isEncrypt;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public byte[] getName() {
        return (byte[])this.name.clone();
    }

    public byte[] getChecksum() {
        return (byte[])this.checksum.clone();
    }

    public int getMaterialLen() {
        return this.materialLen;
    }

    @Override
    public String getKdfType() {
        if (this.kdfType == 1) {
            return "PBKDF2WithHmacSHA1";
        }
        if (this.kdfType == 2) {
            return "PBKDF2WithHmacSHA256";
        }
        return null;
    }

    public int getKdfTypeInt() {
        return this.kdfType;
    }
}

