/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusioncube.action;

import com.huawei.ism.tool.fusioncube.service.MetaVisionLoginbehaviorService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaVisionLoginAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaVisionLoginAction.class);
    private final MetaVisionLoginbehaviorService metaVisionLoginbehaviorService;

    public void handle(List<DevNode> devs) {
        if (this.tryLoginAll(devs)) {
            this.metaVisionLoginbehaviorService.loginSuccessAction();
        }
    }

    boolean tryLoginAll(List<DevNode> devs) {
        List<User> metaVisionUsers = this.getMetaVisionUsersFromDevs(devs);
        if (this.hasInvalidData(metaVisionUsers)) {
            this.metaVisionLoginbehaviorService.validFailAction();
            return false;
        }
        return this.loginAll(devs);
    }

    boolean loginAll(List<DevNode> devs) {
        StringJoiner ips = new StringJoiner(", ");
        for (DevNode dev : devs) {
            try {
                Optional connectionOpt = RestConnectionManager.getMetaVisionConnection((DevNode)dev);
                if (connectionOpt.isPresent()) continue;
                ips.add(dev.getIp());
            }
            catch (ToolException e) {
                log.error("There is an error occurred when login meta vision device, cause:{}", (Throwable)e);
                ips.add(dev.getIp());
            }
        }
        return this.isFailedIpsEmpty(ips.toString());
    }

    private boolean isFailedIpsEmpty(String ips) {
        if (StringUtils.isNotEmpty((CharSequence)ips)) {
            String errorMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.step2.fusioncube.dialog.login.connect.error", (Object[])new Object[]{ips});
            this.metaVisionLoginbehaviorService.loginFailAction(errorMsg);
            return false;
        }
        return true;
    }

    private List<User> getMetaVisionUsersFromDevs(List<DevNode> devs) {
        return devs.stream().map(DevNode::getMetaVisionUser).collect(Collectors.toList());
    }

    private boolean hasInvalidData(List<User> metaVisionUsers) {
        return metaVisionUsers.stream().anyMatch(this::hasEmptyUsernameOrPassword);
    }

    private boolean hasEmptyUsernameOrPassword(User metaVisionUser) {
        return StringUtils.isBlank((CharSequence)metaVisionUser.getUserName()) || StringUtils.isBlank((CharSequence)metaVisionUser.getPassword());
    }

    @Generated
    public MetaVisionLoginAction(MetaVisionLoginbehaviorService metaVisionLoginbehaviorService) {
        this.metaVisionLoginbehaviorService = metaVisionLoginbehaviorService;
    }
}

