/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusioncube.dialog;

import com.huawei.ism.tool.fusioncube.action.MetaVisionLoginAction;
import com.huawei.ism.tool.fusioncube.service.MetaVisionLoginbehaviorService;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.ui.component.TextEditCell;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import lombok.Generated;

public class MetaVisionInputTableDialog
extends IsmDialog
implements MetaVisionLoginbehaviorService {
    public static final int IP_COLUMN_INDEX = 0;
    public static final int USERNAME_COLUMN_INDEX = 1;
    public static final int PASSWORD_COLUMN_INDEX = 2;
    private static final int TABLE_COLUMN_SIZE = 3;
    private static final String OPENAPI_ACCOUNT = "openapi";
    private static final String[] TABLE_COLUMN_TITLES = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.table.ip.title"), ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.table.username.title"), ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.table.password.title")};
    private DefaultTableModel tableModel;
    private JButton confirmButton;
    private JButton cancelButton;
    private SelectDeviceCard selectDeviceCard;
    private boolean isLoginAllSuccess = false;

    public MetaVisionInputTableDialog(Window parent) {
        super(parent);
        this.commonInit(parent);
    }

    private void commonInit(Window parent) {
        this.initTableLayout(TABLE_COLUMN_TITLES);
        this.addButton();
        this.toFront();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.confirmButton.requestFocus();
        super.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.pack();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
    }

    private void initTableLayout(String[] titles) {
        this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.title"));
        this.tableModel = new DefaultTableModel(titles, new int[0]);
        IsmTable table = new IsmTable((TableModel)this.tableModel);
        IsmTableScrollPane scrollPane = new IsmTableScrollPane(table, false);
        scrollPane.setPreferredSize(new Dimension(350, 250));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)scrollPane, "Center");
        jPanel.setBorder(new EmptyBorder(8, 8, 0, 8));
        this.getDialogContentPane().add(jPanel);
    }

    private void addButton() {
        Dimension size = new Dimension(80, 21);
        this.confirmButton = UCD.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.confirm.button.name"));
        this.confirmButton.setPreferredSize(size);
        this.confirmButton.addActionListener(event -> new MetaVisionLoginAction(this).handle(this.getDevsFromTable()));
        this.cancelButton = UCD.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.close.button.name"));
        this.cancelButton.setPreferredSize(size);
        this.cancelButton.addActionListener(event -> this.dispose());
        this.getSouthBox().add(this.confirmButton);
        this.getSouthBox().add(Box.createHorizontalStrut(10));
        this.getSouthBox().add(this.cancelButton);
    }

    public void addDefaultTableRow(DevNode devNode) {
        DefaultTableRow tableRow = new DefaultTableRow(3, (Object)devNode, (Object)devNode.getIp());
        tableRow.setValueAt(0, (Object)new TextEditCell(devNode.getIp()));
        tableRow.setValueAt(1, (Object)new TextEditCell(OPENAPI_ACCOUNT));
        tableRow.setValueAt(2, (Object)new TextEditCell("", (JTextField)UiMethod.getPasswordFiled(), true));
        this.tableModel.addRow(new TableRow[]{tableRow});
    }

    private List<DevNode> getDevsFromTable() {
        return this.tableModel.getAllRows().stream().map(this::getDevFromRow).collect(Collectors.toList());
    }

    private DevNode getDevFromRow(TableRow tableRow) {
        DevNode devNode = (DevNode)tableRow.getUserObject();
        devNode.setMetaVisionUser(this.parseRowToUser((TableRow<DevNode, String>)tableRow));
        return devNode;
    }

    private User parseRowToUser(TableRow<DevNode, String> tableRow) {
        User user = new User();
        TextEditCell usernameCell = (TextEditCell)tableRow.getValueAt(1);
        TextEditCell passwordCell = (TextEditCell)tableRow.getValueAt(2);
        JTextField passwordField = this.getJTextFieldFromTextEditCell(passwordCell);
        user.setUserName(usernameCell.toString());
        user.setPassword(passwordField.getText());
        return user;
    }

    private JTextField getJTextFieldFromTextEditCell(TextEditCell textEditCell) {
        DefaultCellEditor defaultCellEditor;
        Component component;
        TableCellEditor editor = textEditCell.getEditor();
        if (editor instanceof DefaultCellEditor && (component = (defaultCellEditor = (DefaultCellEditor)editor).getComponent()) instanceof JTextField) {
            return (JTextField)component;
        }
        return new JTextField();
    }

    @Override
    public void loginSuccessAction() {
        super.dispose();
        this.setLoginAllSuccess(true);
    }

    @Override
    public void validFailAction() {
        DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.step2.fusioncube.dialog.input.error.empty"));
    }

    @Override
    public void loginFailAction(String errorMsg) {
        DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)errorMsg);
    }

    @Generated
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    @Generated
    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    @Generated
    public JButton getCancelButton() {
        return this.cancelButton;
    }

    @Generated
    public SelectDeviceCard getSelectDeviceCard() {
        return this.selectDeviceCard;
    }

    @Generated
    public void setSelectDeviceCard(SelectDeviceCard selectDeviceCard) {
        this.selectDeviceCard = selectDeviceCard;
    }

    @Generated
    public boolean isLoginAllSuccess() {
        return this.isLoginAllSuccess;
    }

    @Generated
    public void setLoginAllSuccess(boolean isLoginAllSuccess) {
        this.isLoginAllSuccess = isLoginAllSuccess;
    }
}

