/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusioncube.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionCategoryCheckItem;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionCheckItem;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionConfigItem;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectItemProgress;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectItemResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectItemResultState;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectNodeResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectProgress;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectTaskResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionItemProgressResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionReportItem;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionResp;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionStartInspectNode;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionStartInspectParam;
import com.huawei.ism.tool.fusioncube.service.MetaVisionRestApiService;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.MetaVisionRestConnect;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.json.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaVisionInspectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaVisionInspectService.class);
    public static final List<String> CUBE_META_VISION_BLACK_LIST = Arrays.asList("6.0.5", "8.1.2", "8.1.3", "8.1.5", "8.2.0", "8.2.RC1", "8.0.RC1", "8.0.0", "8.0.0.SPC1", "8.0.0.SPC100", "8.1.RC1", "8.1.RC2", "8.1.RC3", "8.1.RC5", "8.1.2.SPC100", "8.1.2.SPC200", "8.1.2.SPC300", "8.1.5.SPC100", "8.1.RC6", "8.1.3.SPC100");
    public static final String META_VISION = "MetaVision";
    private static final List<String> META_VISION_INSPECT_RESULT_STATES = Arrays.asList(MetaVisionInspectItemResultState.NORMAL.getKey(), MetaVisionInspectItemResultState.NOT_INVOLVE.getKey());
    private static final List<String> NEED_HIDE_ITEM_TYPES = Arrays.asList("DistributedManagement", "SNA");

    public static boolean metaVisionAuthUser(DevNode devNode) {
        try {
            Optional metaVisionConnection = RestConnectionManager.getMetaVisionConnection((DevNode)devNode);
            return metaVisionConnection.isPresent();
        }
        catch (ToolException e) {
            log.error("get Meta Vision Connection error", (Throwable)e);
            return false;
        }
    }

    public static String startMetaVisionInspectTask(DevNode devNode, List<CheckItem> checkItems) {
        try {
            List clusterNodes = devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
            List<MetaVisionStartInspectNode> inspectNodes = clusterNodes.stream().map(MetaVisionInspectService::mapToInspectNode).collect(Collectors.toList());
            List<String> items = checkItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
            MetaVisionStartInspectParam metaVisionStartInspectParam = new MetaVisionStartInspectParam(inspectNodes, items);
            Optional metaVisionConnection = RestConnectionManager.getMetaVisionConnection((DevNode)devNode);
            if (!metaVisionConnection.isPresent()) {
                log.error("start meta vision inspect task error , can not get the connect");
                return "";
            }
            MetaVisionResp metaVisionResp = MetaVisionRestApiService.startMetaVisionInspectTask((MetaVisionRestConnect)metaVisionConnection.get(), metaVisionStartInspectParam);
            return metaVisionResp.getData();
        }
        catch (ToolException e) {
            log.error("start meta vision inspect task error", (Throwable)e);
            return "";
        }
    }

    @NotNull
    private static MetaVisionStartInspectNode mapToInspectNode(ClusterNode node) {
        MetaVisionStartInspectNode inspectNode = new MetaVisionStartInspectNode();
        inspectNode.setDeviceIp(node.getManagementIp());
        inspectNode.setDeviceModel(node.getModel());
        inspectNode.setDeviceName(node.getName());
        inspectNode.setDeviceId(node.getDeviceId());
        inspectNode.setDeviceType(node.getDeviceType());
        return inspectNode;
    }

    public static MetaVisionInspectTaskResult getMetaVisionInspectResult(DevNode devNode, String taskId) throws ToolException {
        Optional metaVisionConnection = RestConnectionManager.getMetaVisionConnection((DevNode)devNode);
        if (!metaVisionConnection.isPresent()) {
            throw new ToolException("query inspect progress error , task Id is " + taskId);
        }
        MetaVisionResp metaVisionInspectTaskResult = MetaVisionRestApiService.getMetaVisionInspectTaskResult((MetaVisionRestConnect)metaVisionConnection.get(), taskId);
        return (MetaVisionInspectTaskResult)JSONObject.parseObject((String)metaVisionInspectTaskResult.getData(), MetaVisionInspectTaskResult.class);
    }

    public static Map<String, ItemProgressResult> getMetaVisionProgress(String taskId, DevNode devNode) {
        try {
            Optional metaVisionConnection = RestConnectionManager.getMetaVisionConnection((DevNode)devNode);
            if (!metaVisionConnection.isPresent()) {
                throw new ToolException("query inspect progress error , task Id is " + taskId);
            }
            MetaVisionResp metaVisionInspectTaskProgress = MetaVisionRestApiService.getMetaVisionInspectTaskProgress((MetaVisionRestConnect)metaVisionConnection.get(), taskId);
            MetaVisionInspectProgress metaVisionInspectProgress = (MetaVisionInspectProgress)JSONObject.parseObject((String)metaVisionInspectTaskProgress.getData(), MetaVisionInspectProgress.class);
            return metaVisionInspectProgress.getInspectionSmartkitTaskItemsList().stream().collect(Collectors.toMap(MetaVisionInspectItemProgress::getItemId, MetaVisionInspectService::mapToItemProgress, (preValue, nextValue) -> nextValue));
        }
        catch (ToolException e) {
            log.error("get meta vision all item error", (Throwable)e);
            return new HashMap<String, ItemProgressResult>();
        }
    }

    @NotNull
    private static ItemProgressResult mapToItemProgress(MetaVisionInspectItemProgress progress) {
        MetaVisionItemProgressResult itemProgressResult = new MetaVisionItemProgressResult(progress.getItemId(), 0);
        itemProgressResult.setMetaVisionStatus(progress.getStatus());
        if (MetaVisionInspectItemResultState.RUNNING.getKey().equals(progress.getStatus())) {
            itemProgressResult.setStatus(RecordStatus.RUNNING);
            return itemProgressResult;
        }
        if (MetaVisionInspectItemResultState.ABNORMAL.getKey().equals(progress.getStatus())) {
            itemProgressResult.setStatus(RecordStatus.FINISHED);
            itemProgressResult.setProgress(100);
            return itemProgressResult;
        }
        if (META_VISION_INSPECT_RESULT_STATES.contains(progress.getStatus())) {
            itemProgressResult.setStatus(RecordStatus.FINISHED);
            itemProgressResult.setProgress(100);
            return itemProgressResult;
        }
        itemProgressResult.setStatus(RecordStatus.FAILED);
        itemProgressResult.setProgress(100);
        return itemProgressResult;
    }

    public static Map<String, List<CheckItem>> getMetaVisionAllItem(DevNode devNode) {
        try {
            Optional metaVisionConnection = RestConnectionManager.getMetaVisionConnection((DevNode)devNode);
            if (!metaVisionConnection.isPresent()) {
                return new HashMap<String, List<CheckItem>>();
            }
            MetaVisionResp metaVisionCheckItemResp = MetaVisionRestApiService.getMetaVisionCheckItemResp((MetaVisionRestConnect)metaVisionConnection.get());
            List metaVisionCategoryCheckItems = com.alibaba.fastjson.JSONArray.parseArray((String)metaVisionCheckItemResp.getData(), MetaVisionCategoryCheckItem.class);
            return metaVisionCategoryCheckItems.stream().flatMap(categoryItem -> categoryItem.getInspectionConfigCategoryItems().stream()).filter(categoryItem -> !NEED_HIDE_ITEM_TYPES.contains(categoryItem.getType())).collect(Collectors.toMap(MetaVisionConfigItem::getTypeName, configItem -> configItem.getItems().stream().map(MetaVisionInspectService::convertMetaCheckItemToInspectItem).collect(Collectors.toList()), (preValue, nextValue) -> nextValue));
        }
        catch (ToolException e) {
            log.error("get meta vision all item error", (Throwable)e);
            return new HashMap<String, List<CheckItem>>();
        }
    }

    private static CheckItem convertMetaCheckItemToInspectItem(MetaVisionCheckItem metaVisionCheckItem) {
        MetaVisionReportItem checkItem = new MetaVisionReportItem();
        checkItem.setEnable(true);
        checkItem.setName(MetaVisionInspectService.getNameForLanguage(metaVisionCheckItem));
        checkItem.setItemId(metaVisionCheckItem.getItemId());
        Item item = new Item();
        item.setId(checkItem.getItemId());
        item.setName(checkItem.getName());
        checkItem.setItems(Collections.singletonList(item));
        return checkItem;
    }

    private static String getNameForLanguage(MetaVisionCheckItem metaVisionCheckItem) {
        return LanguageManager.isEnglish() ? metaVisionCheckItem.getNameEn() : metaVisionCheckItem.getNameZh();
    }

    public static boolean isSupportsMetaVisionNodeInspection(DevNode devNode) {
        return devNode.isFusionCube() && MetaVisionInspectService.isMetaVision(devNode.getProductVersion());
    }

    public static boolean isMetaVision(String version) {
        if (StringUtils.isEmpty((CharSequence)version) || CUBE_META_VISION_BLACK_LIST.contains(version) || version.startsWith("8.2.0") || version.startsWith("8.2.RC1")) {
            return false;
        }
        String[] versions = version.split("\\.");
        if (versions.length < 3 || !StringUtils.isNumeric((CharSequence)versions[0]) || !StringUtils.isNumeric((CharSequence)versions[1])) {
            return false;
        }
        return MetaVisionInspectService.isVersionBiggerEightPointTwo(versions);
    }

    private static boolean isVersionBiggerEightPointTwo(String[] versions) {
        int firstVersion = Integer.parseInt(versions[0]);
        int secondVersion = Integer.parseInt(versions[1]);
        if (firstVersion < 8) {
            return false;
        }
        if (firstVersion > 8) {
            return true;
        }
        return secondVersion >= 2;
    }

    public static boolean isFusionCubeMetaVisionNode(CheckDevNode checkDevNode) {
        if (checkDevNode.getDevNode().isA3000() || checkDevNode.getDevNode().is2910V7()) {
            return true;
        }
        return MetaVisionInspectService.isSupportsMetaVisionNodeInspection(checkDevNode.getDevNode()) && META_VISION.equals(checkDevNode.getProduct().getProductName());
    }

    public static Optional<CheckDevNode> createFusionCubeMetaVisionCheckDevNode(CheckDevNode checkDev, Product product, DevNode dev) throws CloneNotSupportedException, ToolException {
        Optional metaVisionRestConnect = RestConnectionManager.getMetaVisionConnection((DevNode)dev);
        if (!metaVisionRestConnect.isPresent()) {
            log.error("get metaVision rest connect error");
            return Optional.empty();
        }
        CheckDevNode checkDevNode = MetaVisionInspectService.createCheckDevNode(checkDev, product, dev);
        checkDevNode.getDevNode().setClusterNodes(MetaVisionInspectService.getFusionCubeMetaVisionClusterNodes((MetaVisionRestConnect)metaVisionRestConnect.get()));
        Map<String, List<CheckItem>> metaVisionAllItem = MetaVisionInspectService.getMetaVisionAllItem(checkDevNode.getDevNode());
        checkDevNode.setDstorageSceneCheckItemsList(MetaVisionInspectService.getFusionCubeMetaVisionCheckItems(metaVisionAllItem));
        return Optional.of(checkDevNode);
    }

    @NotNull
    public static CheckDevNode createCheckDevNode(CheckDevNode checkDev, Product product, DevNode dev) throws CloneNotSupportedException {
        CheckDevNode checkDevNode = new CheckDevNode();
        checkDevNode.setNodeName(checkDev.getNodeName());
        checkDevNode.setResourceBundle(checkDev.getResourceBundle());
        checkDevNode.setProduct(product.clone());
        DevNode devNode = EntityUtils.cloneDevNode((DevNode)dev);
        if (devNode.is2910V7()) {
            devNode.setUuid(devNode.getUuid());
            devNode.setDeviceSerialNumber(devNode.getDeviceSerialNumber());
        } else {
            devNode.setUuid(devNode.getUuid() + META_VISION);
            devNode.setDeviceSerialNumber(devNode.getDeviceSerialNumber() + META_VISION);
        }
        devNode.setProductModel(META_VISION);
        checkDevNode.getProduct().setProductName(META_VISION);
        checkDevNode.setDevNode(devNode);
        checkDevNode.getProduct().setPassedNotShowSuggest(true);
        checkDevNode.getDevNode().setMetaVisionUser(dev.getMetaVisionUser());
        return checkDevNode;
    }

    @NotNull
    public static List<DstorageSceneCheckItems> getFusionCubeMetaVisionCheckItems(Map<String, List<CheckItem>> metaVisionAllItems) {
        DstorageSceneCheckItems dstorageSceneCheckItems = new DstorageSceneCheckItems();
        dstorageSceneCheckItems.setSceneId("realTimed_check");
        dstorageSceneCheckItems.setCheckItems(metaVisionAllItems);
        return Collections.singletonList(dstorageSceneCheckItems);
    }

    @NotNull
    public static List<ClusterNode> getFusionCubeMetaVisionClusterNodes(MetaVisionRestConnect metaVisionRestConnect) throws ToolException {
        MetaVisionResp metaVisionInspectNodeResp = MetaVisionRestApiService.getMetaVisionInspectNodeResp(metaVisionRestConnect);
        JSONArray nodeArray = new JSONArray(metaVisionInspectNodeResp.getData());
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        for (int i = 0; i < nodeArray.length(); ++i) {
            com.huawei.json.JSONObject nodeObject = nodeArray.getJSONObject(i);
            ClusterNode clusterNode = new ClusterNode();
            clusterNode.setId(-1);
            clusterNode.setName(nodeObject.getStringOrDefault("deviceName", ""));
            clusterNode.setManagementIp(nodeObject.getStringOrDefault("deviceIp", ""));
            clusterNode.setSerialNumber(nodeObject.getStringOrDefault("deviceId", ""));
            clusterNode.getRoles().add(nodeObject.getStringOrDefault("deviceModel", ""));
            clusterNode.setModel(nodeObject.getStringOrDefault("deviceModel", ""));
            clusterNode.setDeviceId(nodeObject.getStringOrDefault("deviceId", ""));
            clusterNode.setDeviceType(nodeObject.getStringOrDefault("deviceType", ""));
            clusterNodes.add(clusterNode);
        }
        return clusterNodes;
    }

    public static void fillMetaVisionTaskRespForOneNode(CheckDevNode checkDevNode, MetaVisionInspectTaskResult result) {
        if (result == null) {
            return;
        }
        if (MetaVisionInspectService.isFusionCubeMetaVisionNode(checkDevNode)) {
            checkDevNode.getCheckItems().values().stream().flatMap(Collection::stream).filter(CheckItem::isEnable).forEach(item -> MetaVisionInspectService.buildOneCheckItemResult(item, result));
        }
    }

    private static void buildOneCheckItemResult(CheckItem item, MetaVisionInspectTaskResult result) {
        List<MetaVisionInspectItemResult> itemList = result.getInspectionSmartkitTaskItemsList();
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Optional<MetaVisionInspectItemResult> oneResult = itemList.stream().filter(res -> res.getItemId().equals(item.getItemId())).findFirst();
        if (oneResult.isPresent()) {
            MetaVisionInspectItemResult itemResult = oneResult.get();
            ResultItem checkResult = item.getCheckResult();
            checkResult.setNormal("normal".equals(itemResult.getStatus()));
            checkResult.setNoSupport("not_involve".equals(itemResult.getStatus()));
            item.setSourceInfo(itemResult.getInspectionSmartkitDeviceInfoList().stream().map(MetaVisionInspectNodeResult::getSourceDesc).collect(Collectors.joining(System.lineSeparator())), null);
            if (item instanceof MetaVisionReportItem) {
                MetaVisionInspectService.setReportValue((MetaVisionReportItem)item, itemResult);
            }
        }
    }

    private static void setReportValue(MetaVisionReportItem item, MetaVisionInspectItemResult itemResult) {
        if (LanguageManager.isEnglish()) {
            MetaVisionInspectService.setValueEn(item, itemResult);
        } else {
            MetaVisionInspectService.setValueCn(item, itemResult);
        }
    }

    private static void setValueCn(MetaVisionReportItem item, MetaVisionInspectItemResult itemResult) {
        item.setCheckMethod(Objects.toString(itemResult.getCheckMethodZh(), ""));
        item.setCheckCriterion(Objects.toString(itemResult.getCheckStandardZh(), ""));
        item.setSuggestion(Objects.toString(itemResult.getSuggestionZh(), ""));
        item.setErrorInfo(Objects.toString(itemResult.getReasonZh(), ""));
    }

    private static void setValueEn(MetaVisionReportItem item, MetaVisionInspectItemResult itemResult) {
        item.setCheckMethod(Objects.toString(itemResult.getCheckMethodEn(), ""));
        item.setCheckCriterion(Objects.toString(itemResult.getCheckStandardEn(), ""));
        item.setSuggestion(Objects.toString(itemResult.getSuggestionEn(), ""));
        item.setErrorInfo(Objects.toString(itemResult.getReasonEn(), ""));
    }
}

