/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusioncube.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionResp;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionStartInspectParam;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.MetaVisionRestConnect;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaVisionRestApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaVisionRestApiService.class);
    public static final String META_VISION_RESULT_URL = "%s/operation/v1/inspection/smartkit/query/result?taskId=%s";
    public static final String META_VISION_INSPECT_PROGRESS_URL = "%s/operation/v1/inspection/smartkit/query/progress?taskId=%s";
    public static final String META_VISION_QUERY_INSPECT_ITEM_URL = "%s/operation/v1/inspection/smartkit/category/items";
    public static final String META_VISION_QUERY_INSPECT_NODE_URL = "%s/operation/v1/inspection/smartkit/devices";
    public static final String META_VISION_START_INSPECT_TASK = "%s/operation/v1/inspection/smartkit/start";

    public static MetaVisionResp getMetaVisionInspectTaskResult(MetaVisionRestConnect metaVisionRestConnect, String taskId) throws ToolException {
        String url = String.format(META_VISION_RESULT_URL, metaVisionRestConnect.getBaseUrl(), taskId);
        ResponseInfo inspectResultInfo = metaVisionRestConnect.execPost(url, "");
        MetaVisionResp metaVisionResp = (MetaVisionResp)JSONObject.parseObject((String)inspectResultInfo.getContent(), MetaVisionResp.class);
        if (!metaVisionResp.isSuccess()) {
            log.error("query meta vision result error, error code is {} , error msg is {}", (Object)metaVisionResp.getCode(), (Object)metaVisionResp.getMsg());
            throw new ToolException("query metaVision check item resp error");
        }
        return metaVisionResp;
    }

    public static MetaVisionResp getMetaVisionInspectTaskProgress(MetaVisionRestConnect metaVisionRestConnect, String taskId) throws ToolException {
        String url = String.format(META_VISION_INSPECT_PROGRESS_URL, metaVisionRestConnect.getBaseUrl(), taskId);
        ResponseInfo responseInfoChecks = metaVisionRestConnect.execPost(url, "");
        MetaVisionResp metaVisionResp = (MetaVisionResp)JSONObject.parseObject((String)responseInfoChecks.getContent(), MetaVisionResp.class);
        if (!metaVisionResp.isSuccess()) {
            log.error("query meta vision progress error, error code is {} , error msg is {}", (Object)metaVisionResp.getCode(), (Object)metaVisionResp.getMsg());
            throw new ToolException("query metaVision check item resp error");
        }
        return metaVisionResp;
    }

    public static MetaVisionResp getMetaVisionCheckItemResp(MetaVisionRestConnect metaVisionRestConnect) throws ToolException {
        String url = String.format(META_VISION_QUERY_INSPECT_ITEM_URL, metaVisionRestConnect.getBaseUrl());
        ResponseInfo responseInfoChecks = metaVisionRestConnect.execGet(url);
        MetaVisionResp metaVisionResp = (MetaVisionResp)JSONObject.parseObject((String)responseInfoChecks.getContent(), MetaVisionResp.class);
        if (!metaVisionResp.isSuccess()) {
            log.error("query meta vision check item error, error code is {} , error msg is {}", (Object)metaVisionResp.getCode(), (Object)metaVisionResp.getMsg());
            throw new ToolException("query metaVision check item resp error");
        }
        return metaVisionResp;
    }

    public static MetaVisionResp getMetaVisionInspectNodeResp(MetaVisionRestConnect metaVisionRestConnect) throws ToolException {
        String url = String.format(META_VISION_QUERY_INSPECT_NODE_URL, metaVisionRestConnect.getBaseUrl());
        ResponseInfo responseInfoChecks = metaVisionRestConnect.execGet(url);
        MetaVisionResp metaVisionResp = (MetaVisionResp)JSONObject.parseObject((String)responseInfoChecks.getContent(), MetaVisionResp.class);
        if (!metaVisionResp.isSuccess()) {
            log.error("query meta vision device error, error code is {} , error msg is {}", (Object)metaVisionResp.getCode(), (Object)metaVisionResp.getMsg());
            throw new ToolException("query metaVision check item resp error");
        }
        return metaVisionResp;
    }

    public static MetaVisionResp startMetaVisionInspectTask(MetaVisionRestConnect metaVisionRestConnect, MetaVisionStartInspectParam metaVisionStartInspectParam) throws ToolException {
        String url = String.format(META_VISION_START_INSPECT_TASK, metaVisionRestConnect.getBaseUrl());
        ResponseInfo inspectResultInfo = metaVisionRestConnect.execPost(url, JSONObject.toJSONString((Object)metaVisionStartInspectParam));
        MetaVisionResp metaVisionResp = (MetaVisionResp)JSONObject.parseObject((String)inspectResultInfo.getContent(), MetaVisionResp.class);
        if (!metaVisionResp.isSuccess()) {
            log.error("query meta vision result error, error code is {} , error msg is {}", (Object)metaVisionResp.getCode(), (Object)metaVisionResp.getMsg());
            throw new ToolException("query metaVision check item resp error");
        }
        return metaVisionResp;
    }
}

