/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.tool.fusionstorage.entity.FsaNodeInfo;
import com.huawei.ism.tool.fusionstorage.entity.StoragePoolInfo;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.service.common.util.ExcelPropertyResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigarationInfoBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigarationInfoBuilder.class);
    private static final String NODE_INFO_SHEET = "migrationInfo.sheet.fsaNodeInfo";
    private static final String STORAGE_POOL_INFO_SHEET = "migrationInfo.sheet.storagePool";
    private static final String EXCEL_MESSAGE_RESOURCE = "migarationExcelResource";

    public void build(String source, String target) {
        try {
            ExcelWriter excelWriter = EasyExcelFactory.write((String)target).build();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(EXCEL_MESSAGE_RESOURCE, ApplicationContext.getInstance().getCurrentLanguage());
            MigarationInfoBuilder.initExcelTittleResource(resourceBundle);
            List<FsaNodeInfo> fsaNodeInfos = this.writeFsaNodeInfos(source, excelWriter, resourceBundle);
            this.writeStoragePoolInfos(fsaNodeInfos, source, excelWriter, resourceBundle);
            excelWriter.finish();
        }
        catch (IOException e) {
            log.info("Build cluster info excel failed. src {} ", (Object)source, (Object)e);
        }
    }

    private static void initExcelTittleResource(ResourceBundle resourceBundle) {
        ExcelPropertyResourceUtil.setInternationalizedHeader(FsaNodeInfo.class, (ResourceBundle)resourceBundle);
        ExcelPropertyResourceUtil.setInternationalizedHeader(StoragePoolInfo.class, (ResourceBundle)resourceBundle);
    }

    private List<FsaNodeInfo> writeFsaNodeInfos(String source, ExcelWriter excelWriter, ResourceBundle resourceBundle) throws IOException {
        List<FsaNodeInfo> fsaNodeInfos = this.readFsaFiles(source);
        excelWriter.write(fsaNodeInfos, ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)ExcelPropertyResourceUtil.getString((ResourceBundle)resourceBundle, (String)NODE_INFO_SHEET)).head(FsaNodeInfo.class)).build());
        return fsaNodeInfos;
    }

    private void writeStoragePoolInfos(List<FsaNodeInfo> fsaNodeInfos, String source, ExcelWriter excelWriter, ResourceBundle resourceBundle) throws IOException {
        List<StoragePoolInfo> storagePoolInfos = this.readFsmFiles(source);
        int cloneVolNum = fsaNodeInfos.stream().filter(fsaNodeInfo -> fsaNodeInfo.getCloneVolNum() != 0).findFirst().map(FsaNodeInfo::getCloneVolNum).orElse(0);
        storagePoolInfos.forEach(storagePoolInfo -> storagePoolInfo.setCloneVolNum(cloneVolNum));
        excelWriter.write(storagePoolInfos, ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)1, (String)ExcelPropertyResourceUtil.getString((ResourceBundle)resourceBundle, (String)STORAGE_POOL_INFO_SHEET)).head(StoragePoolInfo.class)).build());
    }

    private List<FsaNodeInfo> readFsaFiles(String directoryPath) throws IOException {
        File directory = new File(directoryPath);
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<FsaNodeInfo> fsaNodeInfos = new ArrayList<FsaNodeInfo>();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (!file.isFile() || !file.getName().startsWith("FSA_") || !file.getName().endsWith(".json")) continue;
            try (FileInputStream inputStream = new FileInputStream(file);){
                List fsaNodeInfo = (List)objectMapper.readValue((InputStream)inputStream, (TypeReference)new TypeReference<List<FsaNodeInfo>>(){});
                fsaNodeInfos.addAll(fsaNodeInfo);
            }
            catch (Exception e) {
                log.error("Parse error for file {} ", (Object)file.getCanonicalPath(), (Object)e);
            }
        }
        return fsaNodeInfos;
    }

    private List<StoragePoolInfo> readFsmFiles(String directoryPath) throws IOException {
        File directory = new File(directoryPath);
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<StoragePoolInfo> storagePoolInfos = new ArrayList<StoragePoolInfo>();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (!file.isFile() || !file.getName().startsWith("FSM_") || !file.getName().endsWith(".json")) continue;
            try (FileInputStream inputStream = new FileInputStream(file);){
                List poolInfoList = (List)objectMapper.readValue((InputStream)inputStream, (TypeReference)new TypeReference<List<StoragePoolInfo>>(){});
                storagePoolInfos.addAll(poolInfoList);
            }
            catch (Exception e) {
                log.error("Parse error for file {} ", (Object)file.getCanonicalPath(), (Object)e);
            }
        }
        return storagePoolInfos;
    }
}

