/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.entity.FsaNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Date;
import java.util.LinkedList;

public class CheckNode {
    String ip = "";
    String uuid = null;
    String type = "";
    String name = "";
    EvalStatus status = EvalStatus.WAITING;
    String htmlCode = "notPass";
    String checkTime = "";
    Date checkFinishTime = null;
    String errorMsg = "";
    LinkedList<String> resultPath = new LinkedList();
    boolean hasCubeItem = false;
    EvalStatus statusByFusionStorage = EvalStatus.NOTPASS;
    String htmlCodeByFusionStorage = "notPass";
    EvalStatus statusByFusionCube = EvalStatus.NOTPASS;
    String htmlCodeByFusionCube = "notPass";
    private DevNode devNode = null;

    public CheckNode(FsaNode fsaNode) {
        this.ip = fsaNode.getIp();
        this.type = "Agent";
        this.name = fsaNode.getName();
    }

    public CheckNode(DevNode node) {
        this.ip = node.getIp();
        this.type = "Manager";
        this.name = node.getDeviceName();
        this.devNode = new DevNode();
        this.devNode.setLoginUser(node.getLoginUser());
        this.devNode.setRootUser(node.getRootUser());
        this.devNode.setDeviceSerialNumber(node.getDeviceSerialNumber());
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public String getCheckTime() {
        return this.checkTime;
    }

    public void initCheckTime() {
        this.checkTime = StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = this.ip + this.type;
        }
        return this.uuid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public EvalStatus getStatus() {
        return this.status;
    }

    public EvalStatus getStatusByFusionCube() {
        return this.statusByFusionCube;
    }

    public EvalStatus getStatusByFusionStorage() {
        return this.statusByFusionStorage;
    }

    public void setStatus(EvalStatus status) {
        this.status = status;
        if (EvalStatus.FAILED.equals((Object)status)) {
            this.htmlCode = "fail";
            this.statusByFusionCube = status;
            this.htmlCodeByFusionCube = "fail";
            this.statusByFusionStorage = status;
            this.htmlCodeByFusionStorage = "fail";
            FusionStorageEvalContext.getInstance().getTaskInfo().getFailedCheckNode().put(this.getUuid(), this);
        } else if (EvalStatus.PASS.equals((Object)status)) {
            this.htmlCode = "pass";
        } else if (EvalStatus.NOTPASS.equals((Object)status)) {
            this.htmlCode = "notPass";
        }
    }

    public void setStatusByFusionCube(EvalStatus statusByFusionCube) {
        this.statusByFusionCube = statusByFusionCube;
        if (EvalStatus.FAILED.equals((Object)statusByFusionCube)) {
            this.htmlCodeByFusionCube = "fail";
        } else if (EvalStatus.PASS.equals((Object)statusByFusionCube)) {
            this.htmlCodeByFusionCube = "pass";
        } else if (EvalStatus.NOTPASS.equals((Object)statusByFusionCube)) {
            this.htmlCodeByFusionCube = "notPass";
        }
    }

    public void setStatusByFusionStorage(EvalStatus statusByFusionStorage) {
        this.statusByFusionStorage = statusByFusionStorage;
        if (EvalStatus.FAILED.equals((Object)statusByFusionStorage)) {
            this.htmlCodeByFusionStorage = "fail";
        } else if (EvalStatus.PASS.equals((Object)statusByFusionStorage)) {
            this.htmlCodeByFusionStorage = "pass";
        } else if (EvalStatus.NOTPASS.equals((Object)statusByFusionStorage)) {
            this.htmlCodeByFusionStorage = "notPass";
        }
    }

    public String getHtmlCodeByFusionCube() {
        return this.htmlCodeByFusionCube;
    }

    public String getHtmlCodeByFusionStorage() {
        return this.htmlCodeByFusionStorage;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public LinkedList<String> getResultPath() {
        return this.resultPath;
    }

    public String getName() {
        return this.name;
    }

    public String getHtmlCode() {
        return this.htmlCode;
    }

    public Date getCheckFinishTime() {
        if (this.checkFinishTime != null) {
            return this.checkFinishTime;
        }
        return new Date();
    }

    public void setCheckFinishTime(Date checkFinishTime) {
        this.checkFinishTime = checkFinishTime;
    }

    public void setExterIp(String exterIp) {
        this.devNode.setIp(exterIp);
    }

    public String getNodeFileName() {
        return (this.ip + this.type).replaceAll(":", "_");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckNode other = (CheckNode)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public boolean getHasCubeItem() {
        return this.hasCubeItem;
    }

    public void setHasCubeItem(boolean hasCubeItem) {
        this.hasCubeItem = hasCubeItem;
    }
}

