/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.entity.FusionStorageUserOpData;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.entity.FsaNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.NodeResult;
import com.huawei.ism.tool.fusionstorage.eval.utils.LRUCache;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterEvalInfo {
    private Long startTime;
    private LinkedList<String> executeFsaNodes = new LinkedList();
    private LinkedList<String> executeFsmNodes = new LinkedList();
    private String originalVersion = "";
    private String cubeVersion = "";
    private String packagePath = "6x/FusionStorage_Block_Precheck";
    private String targetVersion = "";
    private String resultDir = "";
    private ClusterMode haModel = ClusterMode.SINGLE;
    private DevNode floatNode = new DevNode();
    private LRUCache<String, NodeResult> resultCache = new LRUCache(50);
    private Map<String, CheckNode> failedCheckNode = new HashMap<String, CheckNode>();
    private Map<String, CheckNode> checkNodes = new ConcurrentHashMap<String, CheckNode>();
    private Map<String, FsaNode> fsaNodes = new HashMap<String, FsaNode>();
    private DevNode primaryNode;
    private DevNode standbyNode;
    private String fsmUploadPath = "/opt/dsware/update/upload/";
    private String subFix = StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss");
    private String distributeSuccessFsaNodesId = "";
    private String distributeSuccessFsmNodesId = "";
    private FusionStorageUserOpData currentUserOpData = new FusionStorageUserOpData();
    private Properties config = new Properties();
    private String fsmSerialNumber = "";
    private boolean startEval = false;

    public ClusterEvalInfo() {
        this.floatNode.setLoginUser(new User("", ""));
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String getFsmSerialNumber() {
        return this.fsmSerialNumber;
    }

    public void setFsmSerialNumber(String sn) {
        this.fsmSerialNumber = sn;
    }

    public Map<String, FsaNode> getFsaNodes() {
        return this.fsaNodes;
    }

    public String getRestPort() {
        return this.floatNode.getPort() + "";
    }

    public void setRestPort(String restPort) {
        this.floatNode.setPort(Integer.parseInt(restPort));
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public String getShowVersion() {
        if (InspectUtils.isFusionCubeEval()) {
            return this.cubeVersion;
        }
        return this.originalVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.originalVersion = originalVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getResultDir() {
        return this.resultDir;
    }

    public String getDetailResultDir(boolean increase) {
        if (increase) {
            this.subFix = StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss");
        }
        return Constants.REPORT_TEMP_DIR + File.separator + "nodeResults_" + this.subFix + File.separator;
    }

    public void setResultDir(String resultDir) {
        this.resultDir = resultDir;
    }

    public String getFloatIp() {
        return this.floatNode.getIp();
    }

    public void setFloatIp(String floatIp) {
        this.floatNode.setIp(floatIp);
        this.floatNode.setDeviceSerialNumber(floatIp);
    }

    public DevNode getPrimaryNode() {
        return this.primaryNode;
    }

    public void setPrimaryNode(DevNode primaryNode) {
        this.primaryNode = primaryNode;
    }

    public DevNode getStandbyNode() {
        return this.standbyNode;
    }

    public void setStandbyNode(DevNode standbyNode) {
        this.standbyNode = standbyNode;
    }

    public Map<String, NodeResult> getNodesResult() {
        return this.resultCache;
    }

    public ClusterMode getMode() {
        return this.haModel;
    }

    public void setMode(ClusterMode mode) {
        this.haModel = mode;
    }

    public FsaNode getFsaNode(String ip) {
        return this.fsaNodes.get(ip);
    }

    public void putFsaNode(FsaNode fsaNode) {
        this.fsaNodes.put(fsaNode.getIp(), fsaNode);
    }

    public void setGatewayUserName(String userName) {
        this.floatNode.getLoginUser().setUserName(userName);
    }

    public void setGatewayPasswd(String passwd) {
        this.floatNode.getLoginUser().setPassword(passwd);
    }

    public User getFloatGateWayUser() {
        return this.floatNode.getLoginUser();
    }

    public void setFloatGateWayUser(User floatGateWayUser) {
        this.floatNode.setLoginUser(floatGateWayUser);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getFsmUploadPath() {
        return this.fsmUploadPath;
    }

    public void setFsmUploadPath(String fsmUploadPath) {
        this.fsmUploadPath = fsmUploadPath;
    }

    public DevNode getFloatNode() {
        return this.floatNode;
    }

    public Map<String, CheckNode> getCheckNodes() {
        return this.checkNodes;
    }

    public Map<String, Integer> calcEvalResult() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Collection<CheckNode> nodes = this.checkNodes.values();
        int passNum = 0;
        int faildNum = 0;
        int notPassNum = 0;
        for (CheckNode node : nodes) {
            if (EvalStatus.PASS.equals((Object)node.getStatus())) {
                ++passNum;
                continue;
            }
            if (EvalStatus.NOTPASS.equals((Object)node.getStatus())) {
                ++notPassNum;
                continue;
            }
            if (!EvalStatus.FAILED.equals((Object)node.getStatus())) continue;
            ++faildNum;
        }
        result.put("sumNum", nodes.size());
        result.put("passNum", passNum);
        result.put("notPassNum", notPassNum);
        result.put("faildNum", faildNum);
        return result;
    }

    public void initExecuteNodes() {
        this.executeFsaNodes.clear();
        this.executeFsmNodes.clear();
        this.executeFsaNodes.addAll(this.fsaNodes.keySet());
        this.executeFsmNodes.add(this.primaryNode.getIp());
        if (ClusterMode.DOUBLE.equals((Object)this.haModel)) {
            this.executeFsmNodes.add(this.standbyNode.getIp());
        }
    }

    public LinkedList<String> getExecuteNodes(String nodeType) {
        if ("Manager".equals(nodeType)) {
            return this.executeFsmNodes;
        }
        if ("Agent".equals(nodeType)) {
            return this.executeFsaNodes;
        }
        LinkedList<String> allNodes = new LinkedList<String>();
        allNodes.addAll(this.executeFsmNodes);
        allNodes.addAll(this.executeFsaNodes);
        return allNodes;
    }

    public String getExecuteNodeId(String nodeType) {
        if (StringUtils.isNULLStr((String)nodeType)) {
            String fsmId = this.getExecuteNodeId("Manager");
            String fsaId = this.getExecuteNodeId("Agent");
            if (StringUtils.isNULLStr((String)fsmId) && StringUtils.isNULLStr((String)fsaId)) {
                return "";
            }
            if (!StringUtils.isNULLStr((String)fsmId) && StringUtils.isNULLStr((String)fsaId)) {
                return fsmId;
            }
            if (StringUtils.isNULLStr((String)fsmId) && !StringUtils.isNULLStr((String)fsaId)) {
                return fsaId;
            }
            return String.join((CharSequence)",", fsmId, fsaId);
        }
        LinkedList<String> ips = this.getExecuteNodes(nodeType);
        if (!ips.isEmpty()) {
            return String.join((CharSequence)(nodeType + ","), this.getExecuteNodes(nodeType)) + nodeType;
        }
        return "";
    }

    public boolean isStartEval() {
        return this.startEval;
    }

    public void setStartEval(boolean startEval) {
        this.startEval = startEval;
    }

    public boolean isAllPassed() {
        Collection<CheckNode> allCheckNodes = this.checkNodes.values();
        for (CheckNode checkNode : allCheckNodes) {
            if (EvalStatus.PASS.equals((Object)checkNode.getStatus())) continue;
            return false;
        }
        return true;
    }

    public boolean isPartPassed() {
        boolean hasSuccess = false;
        boolean hasNotPass = false;
        Collection<CheckNode> allCheckNodes = this.checkNodes.values();
        for (CheckNode checkNode : allCheckNodes) {
            if (EvalStatus.PASS.equals((Object)checkNode.getStatus())) {
                hasSuccess = true;
            } else {
                hasNotPass = true;
            }
            if (!hasSuccess || !hasNotPass) continue;
            return true;
        }
        return false;
    }

    public Map<String, CheckNode> getFailedCheckNode() {
        return this.failedCheckNode;
    }

    public String getDistributeSuccessFsaNodesId() {
        return this.distributeSuccessFsaNodesId;
    }

    public void setDistributeSuccessFsaNodesId(String fsaNodesId) {
        this.distributeSuccessFsaNodesId = fsaNodesId;
    }

    public String getDistributeSuccessFsmNodesId() {
        return this.distributeSuccessFsmNodesId;
    }

    public void setDistributeSuccessFsmNodesId(String fsmNodesId) {
        this.distributeSuccessFsmNodesId = fsmNodesId;
    }

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public FusionStorageUserOpData getCurrentUserOpData() {
        return this.currentUserOpData;
    }

    public void setCurrentUserOpData(FusionStorageUserOpData currentUserOpData) {
        this.currentUserOpData = currentUserOpData;
    }

    public String getCubeVersion() {
        return this.cubeVersion;
    }

    public void setCubeVersion(String cubeVersion) {
        this.cubeVersion = cubeVersion;
    }

    public void setVerifyCertificate(boolean isVerifyCertificate) {
        this.floatNode.setVerifyCertificate(isVerifyCertificate);
    }
}

