/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.fusionstorage.entity.FusionStorageUserOpData;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.PerformCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.XmlWriter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EvalCloseObserver
implements IWizardClosingObserver {
    private static final long serialVersionUID = -6291523953618060507L;
    public static final String XML = "xml";
    public static final String YES = "yes";
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalCloseObserver.class);
    private ToolWizardDialog wizardDialog;

    public EvalCloseObserver(ToolWizardDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public String getListenerName() {
        return "closeEvalListener";
    }

    public void onClose() {
        LOGGER.info("Click close button.");
        if (!this.confirmClose()) {
            return;
        }
        try {
            this.clearTemp();
            this.recordUserOpDatas();
            this.writeSceneFiles();
        }
        catch (Exception e) {
            LOGGER.error("Close tool error.", (Throwable)e);
        }
        finally {
            Runtime.getRuntime().halt(0);
        }
    }

    private boolean confirmClose() {
        if (InspectUIUtil.getCardIndex(InspectUIUtil.getLastCard()) == this.wizardDialog.getCurrentCard().getStep()) {
            PerformCard card = (PerformCard)this.wizardDialog.getCurrentCard();
            WarningDialog dialog = null;
            dialog = !card.getEvalTask().isFinish() ? DialogUtils.showWarnConfirmDialog((Window)this.wizardDialog, (String)ResourceUtil.getString((String)"perform.close.waring"), (String)ResourceUtil.getString((String)"perform.close.tip")) : DialogUtils.showYesNoDialog((Window)this.wizardDialog, (String)ResourceUtil.getString((String)"perform.close.tip"));
            if (0 != dialog.getValue()) {
                FusionStorageEvalContext.getInstance().getMainDialog().setDefaultCloseOperation(0);
                return false;
            }
        }
        return true;
    }

    private void writeSceneFiles() {
        if (SceneUtils.isScene()) {
            ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
            ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
            if (taskInfo == null || !taskInfo.isStartEval()) {
                this.closeWizard();
                return;
            }
            LOGGER.info("writing to sceneData files.");
            this.setResultList(resultList);
            InspectContext.getInstance().finishedSceneTask(resultList);
            String resultScenePath = SceneUtils.getSceneFilePath((String)"fusion_strg_evl_result.xml");
            this.writeCurEvlResult2SceneDir(resultScenePath);
        }
        this.closeWizard();
    }

    private void recordUserOpDatas() {
        LinkedList<FusionStorageUserOpData> userOpDatas = FusionStorageEvalContext.getInstance().getUserOpDatas();
        if (!userOpDatas.isEmpty()) {
            boolean openHelpFile = FusionStorageEvalContext.getInstance().isOpenHelpFile();
            for (FusionStorageUserOpData userOpData : userOpDatas) {
                userOpData.setOpenHelpFile(openHelpFile);
            }
            UserOpDataSaveUtil.batchSaveUserOpdata(userOpDatas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCurEvlResult2SceneDir(String resultScenePath) {
        FileOutputStream fos = null;
        FileLock fileLock = null;
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        try {
            Document document = XmlWriter.createNewDocument();
            Element root = document.createElement("scene");
            Element fromEle = document.createElement("from");
            fromEle.setTextContent(taskInfo.getOriginalVersion());
            root.appendChild(fromEle);
            Element toEle = document.createElement("to");
            toEle.setTextContent(taskInfo.getTargetVersion());
            root.appendChild(toEle);
            Element resultDirEle = document.createElement("saveDir");
            resultDirEle.setTextContent(taskInfo.getResultDir());
            root.appendChild(resultDirEle);
            document.appendChild(root);
            fos = new FileOutputStream(resultScenePath);
            fileLock = fos.getChannel().lock();
            Transformer trans = XmlUtils.newTransformer();
            trans.setOutputProperty("indent", YES);
            trans.setOutputProperty("method", XML);
            trans.transform(new DOMSource(document), new StreamResult(fos));
        }
        catch (ToolException e) {
            LOGGER.error("create scene result file failed.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("create scene result file {} fail.", (Object)new File(resultScenePath).getName());
        }
        catch (Exception e) {
            LOGGER.error("create scene result file failed.", (Throwable)e);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (Exception e) {
                    LOGGER.error("FileUnlock failed.", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    LOGGER.error("File close failed.", (Throwable)e);
                }
            }
        }
    }

    private void setResultList(List<Map<String, String>> resultList) {
        HashMap<String, String> result = new HashMap<String, String>();
        DevNode devNode = FusionStorageEvalContext.getInstance().getTaskInfo().getPrimaryNode();
        String insepctRes = String.valueOf(this.getResultStatus(FusionStorageEvalContext.getInstance().getTaskInfo()));
        result.put("executeType", "0");
        String ip = devNode.getIp();
        String sn = devNode.getDeviceSerialNumber();
        result.put("status", insepctRes);
        result.put("fileName", "");
        if (String.valueOf(TaskResult.Result.CANCELED).equals(insepctRes)) {
            result.put("SN", "");
            result.put("IP", "");
        } else {
            result.put("SN", sn);
            result.put("IP", ip);
        }
        result.put("toolId", "FusionStorageUpdateEval");
        resultList.add(result);
    }

    private void closeWizard() {
        FusionStorageEvalContext.getInstance().getMainDialog().dispose();
    }

    private TaskResult.Result getResultStatus(ClusterEvalInfo taskInfo) {
        if (taskInfo.isAllPassed()) {
            return TaskResult.Result.SUCCESS;
        }
        return TaskResult.Result.FAILED;
    }

    public void clearTemp() {
        FileUtils.deleteAllInFolder((String)Constants.TEMP_DIR);
    }

    public void onComplete() {
        LOGGER.info("Click complete button");
        try {
            this.clearTemp();
            this.recordUserOpDatas();
            this.writeSceneFiles();
        }
        catch (Exception e) {
            LOGGER.error("Close tool error.", (Throwable)e);
        }
        finally {
            Runtime.getRuntime().halt(0);
        }
    }
}

