/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckResult;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.entity.NodeResult;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStorageReportService;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.PerformCard;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.inspect.ui.componet.jlist.ProgressBar;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.IsmListModel;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformCardUiUpdateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformCardUiUpdateService.class);
    private PerformCard performCard = null;
    private Map<String, IsmListModel<DetailRecord>> detailModels = new ConcurrentHashMap<String, IsmListModel<DetailRecord>>();
    private Map<String, Boolean> checkResultInit = new ConcurrentHashMap<String, Boolean>();
    private TimerAction timerAction = new TimerAction();
    private Timer timerDesRefresh = new Timer(1000, this.timerAction);
    private ProgressUpdateUtil util = new ProgressUpdateUtil();

    public PerformCardUiUpdateService(PerformCard card) {
        this.performCard = card;
        Constants.RUNNING_IAMGE.setImageObserver(FusionStorageEvalContext.getInstance().getMainDialog());
        Constants.EVAL_RUNNING_IMGE.setImageObserver(FusionStorageEvalContext.getInstance().getMainDialog());
    }

    public void init(Object[] nodeIds) {
        this.initDetailModels(nodeIds);
        this.initCheckResult(nodeIds, null);
    }

    private void initDetailModels(Object[] nodeIds) {
        List rows = null;
        rows = nodeIds == null ? this.performCard.getCardLayout().getTableModel().getAllRows() : this.performCard.getCardLayout().getTableModel().getTableRows(nodeIds);
        for (TableRow row : rows) {
            this.detailModels.put(row.getIdentifier().toString(), (IsmListModel<DetailRecord>)new IsmListModel());
        }
        String selectNodeId = this.performCard.getCardLayout().getTable().getMarkedRow().getIdentifier().toString();
        this.performCard.getCardLayout().getDetailList().setModel((ListModel)this.detailModels.get(selectNodeId));
    }

    public void updateButtomDes(String des) {
        this.performCard.getCardLayout().getButtomDes().setText(des);
    }

    public void updateNodeTable(String nodeIds, EvalStatus status) {
        if (StringUtils.isNULLStr((String)nodeIds)) {
            LOGGER.warn("node ids is empty.");
            return;
        }
        Object[] ids = nodeIds.split(",");
        List rows = this.performCard.getCardLayout().getTableModel().getTableRows(ids);
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        for (TableRow row : rows) {
            IsmTableCell.IconCell cell = (IsmTableCell.IconCell)row.getValueAt(3);
            cell.setDescription(status.toString());
            this.updateCellImge(cell, status);
            taskInfo.getCheckNodes().get(row.getIdentifier().toString()).setStatus(status);
        }
    }

    public void updateDetailList(String nodeIds, String des, int progress) {
        this.updateDetailList(nodeIds, des, progress, EvalStatus.EXECUTING);
    }

    public void updateDetailList(String nodeIds, String des, EvalStatus stat) {
        this.updateDetailList(nodeIds, des, 0, stat);
    }

    private void updateDetailList(String nodeIds, String des, int progress, EvalStatus stat) {
        if (nodeIds != null) {
            String[] ids;
            for (String id : ids = nodeIds.split(",")) {
                IsmListModel<DetailRecord> model = this.detailModels.get(id);
                if (model == null) continue;
                this.updateDetailModel(id, model, des, progress, stat);
            }
        }
    }

    public void updateDetailRecordList(String nodeId, String itemId, EvalStatus stat) {
        IsmListModel<DetailRecord> model = this.detailModels.get(nodeId);
        this.updateDetailRecordModel(nodeId, model, itemId, 0, stat);
    }

    public void updateDetailRecordLists(String nodeId, List<DetailRecord> recs) {
        IsmListModel<DetailRecord> model = this.detailModels.get(nodeId);
        model.addElements(recs);
        this.performCard.getCardLayout().getDetailList().updateUI();
        this.scrollDetailListBottoms();
    }

    public void scrollDetailListBottoms() {
        try {
            JList detailList = this.performCard.getCardLayout().getDetailList();
            int lastIndex = detailList.getModel().getSize();
            Rectangle rect = detailList.getCellBounds(lastIndex - 1, lastIndex - 1);
            JViewport view = this.performCard.getCardLayout().getDetailScrollPane().getViewport();
            if (rect != null && view != null) {
                view.scrollRectToVisible(rect);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Scroll detail list to bottom failed.", (Throwable)e);
        }
    }

    public void updateDetailRecordList(DetailRecord rec) {
        String nodeId = rec.getNodeId();
        Map<String, CheckNode> checkNodes = FusionStorageEvalContext.getInstance().getTaskInfo().getCheckNodes();
        if (StringUtils.isNULLStr((String)nodeId)) {
            String[] nodeIds;
            for (String id : nodeIds = FusionStorageEvalContext.getInstance().getTaskInfo().getExecuteNodeId(null).split(",")) {
                this.updateRecord(this.detailModels.get(id), rec);
                if (!EvalStatus.FAILED.equals((Object)rec.getEvalStatus())) continue;
                checkNodes.get(id).setErrorMsg(rec.getErrorInfo());
            }
            return;
        }
        IsmListModel<DetailRecord> model = this.detailModels.get(rec.getNodeId());
        if (model != null) {
            if (EvalStatus.FAILED.equals((Object)rec.getEvalStatus())) {
                checkNodes.get(rec.getNodeId()).setErrorMsg(rec.getErrorInfo());
            }
            this.updateRecord(model, rec);
        }
    }

    private void updateRecord(IsmListModel<DetailRecord> model, DetailRecord rec) {
        DetailRecord lastRecord = (DetailRecord)model.lastElement();
        if (!rec.getMessage().equals(lastRecord.getMessage())) {
            model.addElementAt((Object)rec);
        } else {
            lastRecord.setError(rec.isError());
            lastRecord.setErrorInfo(rec.getErrorInfo());
            lastRecord.setEvalStatus(rec.getEvalStatus());
        }
    }

    private void updateDetailRecordModel(String nodeId, IsmListModel<DetailRecord> model, String itemId, int progress, EvalStatus stat) {
        DetailRecord rec = new DetailRecord();
        rec.setItemId(itemId);
        rec.setNodeId(nodeId);
        rec.setDate(new Date());
        rec.setMessage(EvalResourceUtil.getItemDes(itemId + ".name"));
        rec.setProgress(progress);
        rec.setEvalStatus(stat);
        model.addElementAt((Object)rec);
    }

    private void updateDetailModel(String nodeId, IsmListModel<DetailRecord> model, String des, int progerss, EvalStatus stat) {
        if (model.isEmpty()) {
            DetailRecord rec = new DetailRecord();
            rec.setNodeId(nodeId);
            rec.setDate(new Date());
            rec.setMessage(des);
            rec.setEvalStatus(stat);
            rec.setProgress(progerss);
            model.addElementAt((Object)rec);
            return;
        }
        DetailRecord rec = (DetailRecord)model.lastElement();
        rec.setProgress(progerss);
        if (des.equals(rec.getMessage())) {
            rec.setEvalStatus(stat);
        } else {
            if (EvalStatus.EXECUTING.equals((Object)rec.getEvalStatus())) {
                rec.setEvalStatus(EvalStatus.COMPLETE);
                LOGGER.warn("Add new record to detail list but the last one status isn't 'COMPLETE'.");
            }
            DetailRecord newRec = new DetailRecord();
            newRec.setNodeId(nodeId);
            newRec.setDate(new Date());
            newRec.setMessage(des);
            newRec.setEvalStatus(stat);
            model.addElementAt((Object)newRec);
        }
    }

    public IsmListModel<DetailRecord> getDetailModel(String nodeId) {
        return this.detailModels.get(nodeId);
    }

    private void updateCellImge(IsmTableCell.IconCell cell, EvalStatus status) {
        if (EvalStatus.EXECUTING.equals((Object)status)) {
            cell.setIcon((Icon)Constants.EVAL_RUNNING_IMGE);
        } else if (EvalStatus.WAITING.equals((Object)status)) {
            cell.setIcon((Icon)Constants.WAITING_IMGE);
        } else if (EvalStatus.NOTPASS.equals((Object)status)) {
            cell.setIcon((Icon)Constants.NOT_PASS_IAMGE);
        } else if (EvalStatus.FAILED.equals((Object)status)) {
            cell.setIcon((Icon)Constants.NOT_PASS_IAMGE);
        } else {
            cell.setIcon((Icon)Constants.PASS_IAMGE);
        }
    }

    public void updateStepUI(PerformCardLayout.Step step) {
        int stepStat = step.getStat();
        ImageIcon icon = PerformCardLayout.getStatusIconMap().get(step.getStat());
        step.getImg().setIcon(icon);
        JComponent line = step.getSubLine();
        switch (stepStat) {
            case 0: {
                line.setForeground(Constants.COLOR_TODO);
                line.setBackground(Constants.COLOR_TODO);
                break;
            }
            case 1: {
                line.setForeground(Constants.COLOR_TODO);
                line.setBackground(Constants.COLOR_TODO);
                break;
            }
            case 3: {
                line.setForeground(Constants.COLOR_TODO);
                line.setBackground(Constants.COLOR_TODO);
                break;
            }
            default: {
                line.setForeground(Constants.COLOR_DONE);
                line.setBackground(Constants.COLOR_DONE);
            }
        }
    }

    public void updateCheckResultDetail() {
        TableRow row = this.performCard.getCardLayout().getTable().getMarkedRow();
        if (row == null) {
            return;
        }
        String nodeId = row.getIdentifier().toString();
        if (!this.checkResultInit.containsKey(nodeId)) {
            return;
        }
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        NodeResult nodeResult = taskInfo.getNodesResult().get(nodeId);
        if (nodeResult == null) {
            try {
                nodeResult = FusionStorageReportService.parseNodeResult(nodeId);
                taskInfo.getNodesResult().put(nodeId, nodeResult);
            }
            catch (ToolException e) {
                DetailRecord rec = this.getErrorDetailRecord(ResourceUtil.getString((String)"perform.eval.result.parse"), e.getErrorLocaleDescription());
                rec.setNodeId(nodeId);
                this.updateDetailRecordList(rec);
                return;
            }
        }
        if (this.checkResultInit.get(nodeId).booleanValue()) {
            return;
        }
        Collection<CheckResult> results = nodeResult.getDetail().values();
        ArrayList<DetailRecord> itemRecords = new ArrayList<DetailRecord>();
        Map<String, CheckNode> checkNodes = taskInfo.getCheckNodes();
        for (CheckResult result : results) {
            DetailRecord rec = new DetailRecord();
            itemRecords.add(rec);
            rec.setDate(checkNodes.get(nodeId).getCheckFinishTime());
            rec.setMessage(EvalResourceUtil.getItemDes(result.getCheckItemId() + ".name"));
            rec.setEvalStatus(result.getResultStat());
            rec.setNodeId(nodeId);
            rec.setItemId(result.getCheckItemId());
        }
        this.checkResultInit.put(nodeId, true);
        this.updateDetailRecordLists(nodeId, itemRecords);
    }

    public DetailRecord getErrorDetailRecord(String nameDes, String errorInfo) {
        DetailRecord rec = new DetailRecord();
        rec.setDate(new Date());
        rec.setMessage(nameDes);
        rec.setErrorInfo(errorInfo);
        rec.setEvalStatus(EvalStatus.FAILED);
        rec.setError(true);
        return rec;
    }

    public void updateProgress(int progress) {
        this.performCard.getCardLayout().getProgressBar().setProgress(progress);
    }

    public void finishRefresh() {
        this.performCard.getCardLayout().getReEvalLink().setEnabled(true);
        this.performCard.getCardLayout().getViewReport().setEnabled(true);
        this.performCard.updateNavigationBar();
        ((JButton)this.performCard.getNavigationButtons().get(ToolWizardDialog.Navigation.Cancel)).setEnabled(false);
        this.util.setFinish(true);
        this.util.close();
        this.updateProgress(100);
        this.timerDesRefresh.stop();
    }

    public void beginRefresh(String[] nodeIds) {
        this.init(nodeIds);
        this.performCard.initNodeStatus(nodeIds);
        this.performCard.getCardLayout().initStep();
        this.performCard.getCardLayout().getReEvalLink().setEnabled(false);
        this.updateButtomDes("");
        this.performCard.getCardLayout().getViewReport().setEnabled(false);
        this.performCard.updateNavigationBar();
        this.updateProgress(1);
        this.util.init();
        this.timerAction.init();
        this.timerDesRefresh.start();
    }

    public void initCheckResult(Object[] nodeIds, Boolean stat) {
        Map<String, NodeResult> cacheResult = FusionStorageEvalContext.getInstance().getTaskInfo().getNodesResult();
        if (nodeIds == null) {
            this.checkResultInit.clear();
            cacheResult.clear();
            return;
        }
        for (Object nodeId : nodeIds) {
            cacheResult.remove(nodeId);
            if (stat == null) {
                this.checkResultInit.remove(nodeId);
                continue;
            }
            this.checkResultInit.put(nodeId.toString(), stat);
        }
    }

    public Timer getTimerDesRefresh() {
        return this.timerDesRefresh;
    }

    public ProgressUpdateUtil getProgressUpdateUtil() {
        return this.util;
    }

    public class ProgressUpdateUtil {
        private AutoProgressUpdater updater = null;
        ExecutorService running = null;

        public void init() {
            this.running = Executors.newSingleThreadExecutor();
        }

        public void close() {
            if (this.running != null) {
                this.running.shutdown();
            }
        }

        public void updateProgressWithExceptTime(int exceptTime, double maxLen) {
            if (this.updater != null) {
                this.updater.setFinish(true);
            }
            this.updater = new AutoProgressUpdater(PerformCardUiUpdateService.this.performCard.getCardLayout().getProgressBar(), exceptTime, maxLen);
            this.running.execute(this.updater);
        }

        public void setFinish(boolean finish) {
            if (null != this.updater) {
                this.updater.setFinish(finish);
            }
            this.updater = null;
        }

        public class AutoProgressUpdater
        implements Runnable {
            private static final int MAX_PROGRESS = 100;
            private static final int FREQUENCY = 1;
            private static final double FACTOR = 0.75;
            private volatile boolean finish = false;
            private int exceptTime = 0;
            private double maxLen = 0.0;
            private ProgressBar bar = null;

            public AutoProgressUpdater(ProgressBar bar2, int exceptTime2, double maxLen2) {
                this.exceptTime = exceptTime2;
                this.maxLen = maxLen2;
                this.bar = bar2;
            }

            public void setFinish(boolean end) {
                this.finish = end;
            }

            @Override
            public void run() {
                int exceptUpTimes = (int)Math.ceil(this.exceptTime / 1);
                double progress = this.bar.getProgress();
                double step = this.maxLen / (double)exceptUpTimes;
                int maxPro = (int)Math.min(100.0, progress + this.maxLen);
                double half = ((double)maxPro - progress) * 0.75 + progress;
                while (!this.finish) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Polling refresh progress interruped.");
                        break;
                    }
                    progress += step;
                    if (progress > this.bar.getProgress()) {
                        this.bar.setProgress(progress);
                    }
                    if (!(progress >= half)) continue;
                    step /= 2.0;
                    half = ((double)maxPro - progress) * 0.75 + progress;
                }
                if ((double)maxPro > this.bar.getProgress()) {
                    this.bar.setProgress(maxPro);
                }
            }
        }
    }

    class TimerAction
    implements ActionListener {
        int minute = 0;
        int hour = 0;
        int second = 0;
        private static final int UNIT = 60;

        TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLabel des = PerformCardUiUpdateService.this.performCard.getCardLayout().getTimeDes();
            ++this.second;
            this.minute += this.second / 60;
            this.hour += this.minute / 60;
            if (this.second == 60) {
                this.second = 0;
            }
            if (this.minute == 60) {
                this.minute = 0;
            }
            des.setText(ResourceUtil.getStringWithParams((String)"perform.enval.progress.usetime", (Object[])new Object[]{this.hour, this.minute, this.second}));
        }

        public void init() {
            this.minute = 0;
            this.hour = 0;
            this.second = 0;
        }
    }
}

