/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.deviceadd;

import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.AuthStep;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.RestAuth;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.SshAuth;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.VersionAuth;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class DeviceAddService
implements Callable<TaskResult> {
    private CustMsgProgressDialog progress;
    private ClusterEvalInfo evalInfo = null;
    private TaskResult taskResult = new TaskResult();
    private List<AuthStep> steps = new ArrayList<AuthStep>();

    public DeviceAddService(ClusterEvalInfo info) {
        this.steps.add(new RestAuth());
        this.steps.add(new SshAuth());
        if (InspectUtils.isFusionCubeEval() || InspectUtils.isFusionEval()) {
            this.steps.add(new VersionAuth());
        }
        this.evalInfo = info;
        this.progress = new CustMsgProgressDialog((Window)FusionStorageEvalContext.getInstance().getMainDialog());
        if (ApplicationContext.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            this.progress.setCustWidth(200);
        }
        FileUtils.deleteAllInFolder((String)Constants.TEMP_DIR);
    }

    @Override
    public TaskResult call() throws Exception {
        this.taskResult.setResult(TaskResult.Result.SUCCESS);
        for (AuthStep authStep : this.steps) {
            if (TaskResult.Result.FAILED.equals((Object)this.taskResult.getResult())) {
                return this.taskResult;
            }
            authStep.auth(this.evalInfo, (ProgressDialog)this.progress, this.taskResult);
        }
        return this.taskResult;
    }

    public ProgressDialog getProgressDialog() {
        return this.progress;
    }
}

