/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.deviceadd;

import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.AuthStep;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStorageRestfulService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONObject;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuth
extends AuthStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAuth.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void auth(ClusterEvalInfo evalInfo, ProgressDialog progress, TaskResult taskResult) {
        LOGGER.info("Start rest auth.");
        progress.setCustMizeMsg(ResourceUtil.getString((String)"rest.auth.processing"));
        FusionStorageRestfulService service = null;
        try {
            service = this.getFusionStorageRestfulService(evalInfo, taskResult);
            if (service == null) {
                return;
            }
            try {
                this.handleFSMInfo(evalInfo, service.fetchFSMNodeInfo());
            }
            catch (ToolException e) {
                LOGGER.error("Handle fsm info error.", (Throwable)e);
                taskResult.setResult(TaskResult.Result.FAILED);
                taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
                if (service != null) {
                    service.closeConnection();
                }
                return;
            }
            catch (Exception e) {
                LOGGER.error("Handle fsm info error.", (Throwable)e);
                taskResult.setResult(TaskResult.Result.FAILED);
                taskResult.setErrorLocaleDescription(ResourceUtil.getString((String)"fsm.node.info.fetch.failed"));
                if (service != null) {
                    service.closeConnection();
                }
                return;
            }
            try {
                LOGGER.info("Start fetch cluster topo.");
                progress.setCustMizeMsg(ResourceUtil.getString((String)"fetch.fsa.node.topo"));
                service.fetchFSANodeTopography();
                progress.setCustMizeMsg(ResourceUtil.getString((String)"fetch.fsa.node.detail"));
                service.fetchFSANodeDetails();
            }
            catch (ToolException e) {
                LOGGER.error("Fetch cluster topo faild.", (Throwable)e);
                taskResult.setResult(TaskResult.Result.FAILED);
                taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
                if (service != null) {
                    service.closeConnection();
                }
                return;
            }
            catch (Exception e) {
                LOGGER.error("Fetch cluster topo faild.", (Throwable)e);
                taskResult.setResult(TaskResult.Result.FAILED);
                taskResult.setErrorLocaleDescription(ResourceUtil.getString((String)"fsa.node.topo.fetch.failed"));
                if (service != null) {
                    service.closeConnection();
                }
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (service != null) {
                service.closeConnection();
            }
        }
    }

    private FusionStorageRestfulService getFusionStorageRestfulService(ClusterEvalInfo evalInfo, TaskResult taskResult) {
        try {
            return new FusionStorageRestfulService(evalInfo);
        }
        catch (Exception e) {
            LOGGER.error("Build rest connection faild.", (Throwable)e);
            taskResult.setResult(TaskResult.Result.FAILED);
            if (e instanceof ToolException && "No trusted certificate found".equals(((ToolException)((Object)e)).getErrorId())) {
                taskResult.setErrorId("No trusted certificate found");
            }
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"rest.connect.fail", (Object[])new Object[]{evalInfo.getRestPort()}));
            return null;
        }
    }

    public void handleFSMInfo(ClusterEvalInfo evalInfo, String content) throws ToolException {
        JSONObject obj = new JSONObject(content);
        String clusterMode = obj.getString("haModel");
        if (StringUtils.isNULLStr((String)clusterMode)) {
            throw new ToolException("fsm.node.info.fetch.failed");
        }
        ClusterMode mode = ClusterMode.valueOf(clusterMode.toUpperCase(Locale.ENGLISH));
        if (!mode.equals((Object)evalInfo.getMode())) {
            Object[] args = new Object[]{evalInfo.getMode(), mode};
            throw new ToolException("fsm.node.info.mode.mismatch", args);
        }
        this.handlePrimaryNodeInfo(evalInfo, obj);
        if (ClusterMode.DOUBLE.equals((Object)mode)) {
            this.handleStandbyNodeInfo(evalInfo, obj);
            if (!evalInfo.getPrimaryNode().getProductVersion().equals(evalInfo.getStandbyNode().getProductVersion())) {
                throw new ToolException("fsm.node.info.version.error");
            }
        }
    }

    private void handlePrimaryNodeInfo(ClusterEvalInfo evalInfo, JSONObject obj) {
        DevNode node = evalInfo.getPrimaryNode();
        node.setIp(obj.getString("nodeIpPrimaryInner"));
        node.setDeviceName(obj.getString("nodeNamePrimary"));
        node.setProductVersion(obj.getString("nodeVersionPrimary"));
        String sn = node.getIp() + "Manager";
        node.setDeviceSerialNumber(sn);
        evalInfo.setOriginalVersion(node.getProductVersion());
        String exterIp = obj.getString("nodeIpPrimaryExter");
        if (!evalInfo.getCheckNodes().containsKey(sn)) {
            CheckNode checkNode = new CheckNode(node);
            checkNode.setExterIp(exterIp);
            evalInfo.getCheckNodes().put(checkNode.getUuid(), checkNode);
        }
    }

    private void handleStandbyNodeInfo(ClusterEvalInfo evalInfo, JSONObject obj) {
        DevNode node = evalInfo.getStandbyNode();
        if (!StringUtils.isNULLStr((String)node.getIp()) && !node.getIp().equals(obj.getString("nodeIpStandbyInner"))) {
            User standbyLoginUser = evalInfo.getPrimaryNode().getLoginUser();
            User standbyRootUser = evalInfo.getPrimaryNode().getRootUser();
            evalInfo.getPrimaryNode().setLoginUser(evalInfo.getStandbyNode().getLoginUser());
            evalInfo.getPrimaryNode().setRootUser(evalInfo.getStandbyNode().getRootUser());
            evalInfo.getStandbyNode().setLoginUser(standbyLoginUser);
            evalInfo.getStandbyNode().setRootUser(standbyRootUser);
        }
        node.setIp(obj.getString("nodeIpStandbyInner"));
        node.setDeviceName(obj.getString("nodeNameStandby"));
        node.setProductVersion(obj.getString("nodeVersionStandby"));
        String sn = node.getIp() + "Manager";
        node.setDeviceSerialNumber(sn);
        String exterIp = obj.getString("nodeIpStandbyExter");
        if (!evalInfo.getCheckNodes().containsKey(sn)) {
            CheckNode checkNode = new CheckNode(node);
            checkNode.setExterIp(exterIp);
            evalInfo.getCheckNodes().put(checkNode.getUuid(), checkNode);
        }
    }
}

