/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.deviceadd;

import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.AuthStep;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAuth
extends AuthStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshAuth.class);
    private static final String ENTER = System.lineSeparator();
    private final String cmd = "cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml |grep \"system wwn\"|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'";

    @Override
    protected void auth(ClusterEvalInfo evalInfo, ProgressDialog progress, TaskResult taskResult) {
        progress.setCustMizeMsg(ResourceUtil.getString((String)"ssh.auth.processing"));
        Map<String, CheckNode> checkNodes = evalInfo.getCheckNodes();
        this.authSSH(checkNodes.get(evalInfo.getPrimaryNode().getDeviceSerialNumber()), ".pri", taskResult);
        if (ClusterMode.DOUBLE.equals((Object)evalInfo.getMode()) && !TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) {
            this.authSSH(checkNodes.get(evalInfo.getStandbyNode().getDeviceSerialNumber()), ".standy", taskResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authSSH(CheckNode checkNode, String errFix, TaskResult taskResult) {
        DevNode node = null;
        try {
            node = checkNode.getDevNode();
            ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)node);
            if (StringUtils.isNULLStr((String)FusionStorageEvalContext.getInstance().getTaskInfo().getFsmSerialNumber())) {
                LOGGER.info("Get sn from fsmNode...");
                String resultStr = sshConnection.execCmd("cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml |grep \"system wwn\"|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'");
                String[] results = resultStr.split(ENTER);
                if (results.length > 1) {
                    FusionStorageEvalContext.getInstance().getTaskInfo().setFsmSerialNumber(results[1]);
                } else {
                    FusionStorageEvalContext.getInstance().getTaskInfo().setFsmSerialNumber("");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Ssh auth faild. node ip : %s port %s", node.getIp(), node.getPort()));
            taskResult.setCurrNode(node);
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)("ssh.connect.fail" + errFix), (Object[])new Object[]{node.getIp(), node.getPort()}));
            LOGGER.info("Get sn from fsmNode failed!");
            return;
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)node);
        }
    }
}

