/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.deviceadd;

import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.UpgradePathConfigDto;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.AuthStep;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionAuth
extends AuthStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionAuth.class);

    @Override
    protected void auth(ClusterEvalInfo evalInfo, ProgressDialog progress, TaskResult taskResult) {
        UpgradePathConfigDto pathConfig;
        String currentVersion = FusionStorageEvalContext.getInstance().getTaskInfo().getOriginalVersion();
        if (InspectUtils.isFusionCubeEval()) {
            currentVersion = this.queryCubeVersion(evalInfo.getPrimaryNode());
            evalInfo.setCubeVersion(currentVersion);
        }
        if ((pathConfig = FusionStorageEvalContext.getInstance().getSupportedEvalPathMap().get(currentVersion)) == null || StringUtils.isNULLStr((String)pathConfig.getToVersions())) {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"added.fusionstorage.is.not.supported", (Object[])new Object[]{currentVersion}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryCubeVersion(DevNode primaryNode) {
        try {
            ICliConnection ssh = SshConnectionManager.getSshConnection((DevNode)primaryNode);
            String cmd = "cat /opt/goku/services/csm/utils/version/VERSION.inner | awk '{print $1}'";
            String record = ssh.execCmd(cmd);
            String version = record.split("\r\n")[1];
            String string = version.trim();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Query cube version error");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)primaryNode);
        }
        return "";
    }
}

