/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.evaltask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.Task;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalTask.class);
    private static final String DISTRIBUTESTATUS_KEY = "DistributeStatus";
    private static final String FAIL_NODE_IP = "FailNodeIP";
    private static final String FAIL_NODE_INFO = "FailNodeInfo";
    private static final int QUERY_UNIT = 8000;
    private static final PerformCardLayout.Step STEP = PerformCardLayout.Step.EXECUTE;
    private static int blockSize = 500;
    private static final double DISTRIBTE_MAX_PRO = 10.0;
    private static final double EVAL_MAX_PRO = 30.0;
    private static int maxRetryTime = 5;
    private static int maxQueryTime = 0x200B20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke() {
        try {
            long startTime = System.currentTimeMillis();
            this.uiService.updateStepUI(STEP.setStat(1));
            this.uiService.updateDetailList(this.getNodeId(null), ResourceUtil.getString((String)"perform.eval.distribte"), EvalStatus.WAITING);
            this.distribtePkg("Manager", ResourceUtil.getString((String)"perform.eval.distribte"));
            this.distribtePkg("Agent", ResourceUtil.getString((String)"perform.eval.distribte"));
            this.evalInfo.setDistributeSuccessFsaNodesId(this.evalInfo.getExecuteNodeId("Agent"));
            this.evalInfo.setDistributeSuccessFsmNodesId(this.evalInfo.getExecuteNodeId("Manager"));
            this.recordStepUseTime(startTime, System.currentTimeMillis(), "distribute");
            if (this.evalInfo.getExecuteNodes(null).isEmpty()) {
                LOGGER.error("all node are failed, task finish.");
                this.commitProject();
                boolean bl = false;
                return bl;
            }
            startTime = System.currentTimeMillis();
            this.eval(ResourceUtil.getString((String)"perform.eval.executing"));
            this.recordStepUseTime(startTime, System.currentTimeMillis(), "execute");
            boolean bl = !this.evalInfo.getExecuteNodes(null).isEmpty();
            return bl;
        }
        finally {
            this.uiService.getProgressUpdateUtil().setFinish(true);
        }
    }

    private void distribtePkg(String nodeType, Set<String> task, String detailDes) {
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "Start distribte pkg to %s %s", nodeType, task.toString()));
            if (task.isEmpty()) {
                LOGGER.warn(String.format(Locale.ENGLISH, "distribte node lis is empty. node type is %s ", nodeType));
                return;
            }
            this.uiService.updateDetailList(this.getNodeId(task, nodeType), detailDes, EvalStatus.EXECUTING);
            String taskId = EvalTask.generateUid();
            this.restService.distribtePkg(taskId, task, nodeType);
            this.pollingDistribteStat(taskId, nodeType, task, detailDes);
            this.uiService.updateDetailList(this.getNodeId(task, nodeType), detailDes, EvalStatus.COMPLETE);
            this.uiService.updateDetailList(this.getNodeId(task, nodeType), ResourceUtil.getString((String)"perform.eval.executing"), EvalStatus.WAITING);
        }
        catch (ToolException e) {
            LOGGER.error("distribte script to node failed.", (Throwable)e);
            this.uiService.updateNodeTable(this.getNodeId(task, nodeType), EvalStatus.FAILED);
            this.updateNodesErrorDetail(this.getNodeId(task, nodeType), detailDes, e.getErrorLocaleDescription());
            this.clearFailedNodes(task, nodeType);
        }
        catch (Exception e) {
            LOGGER.error("distribte script to node failed.", (Throwable)e);
            this.uiService.updateNodeTable(this.getNodeId(task, nodeType), EvalStatus.FAILED);
            this.updateNodesErrorDetail(this.getNodeId(task, nodeType), detailDes, ResourceUtil.getString((String)"perform.distribte.error"));
            this.clearFailedNodes(task, nodeType);
        }
    }

    public Set<Set<String>> splitTask(List<String> nodeIps) {
        HashSet<Set<String>> tasks = new HashSet<Set<String>>();
        HashSet<String> task = new HashSet<String>();
        if (nodeIps.size() > blockSize) {
            int index = 0;
            for (String fsaIp : nodeIps) {
                if (index < blockSize) {
                    task.add(fsaIp);
                    ++index;
                }
                if (index != blockSize) continue;
                index = 0;
                tasks.add(task);
                task = new HashSet();
            }
            if (!task.isEmpty()) {
                tasks.add(task);
            }
        } else {
            task.addAll(nodeIps);
            tasks.add(task);
        }
        return tasks;
    }

    private void eval(String des) {
        String taskId = EXECUTE_TASK_ID;
        try {
            this.restService.clearTask(taskId);
        }
        catch (Exception e) {
            LOGGER.error("clear task failed.");
        }
        if (this.evalInfo.getExecuteNodes(null).size() <= blockSize) {
            this.evalAll(des);
            return;
        }
        Set<Set<String>> tasks = this.splitTask(this.evalInfo.getExecuteNodes("Manager"));
        Set<Set<String>> fsaTasks = this.splitTask(this.evalInfo.getExecuteNodes("Agent"));
        double maxLen = 30.0 / (double)(tasks.size() + fsaTasks.size());
        for (Set<String> task : tasks) {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(25, maxLen);
            this.eval(task, "Manager", des);
            this.uiService.getProgressUpdateUtil().setFinish(true);
        }
        for (Set<String> fsaTask : fsaTasks) {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(25, maxLen);
            this.eval(fsaTask, "Agent", des);
            this.uiService.getProgressUpdateUtil().setFinish(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalAll(String des) {
        String taskId = EXECUTE_TASK_ID;
        LinkedList<String> finishNodes = new LinkedList<String>();
        try {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(25, 30.0);
            this.uiService.updateNodeTable(this.getNodeId(null), EvalStatus.EXECUTING);
            this.uiService.updateDetailList(this.getNodeId(null), des, EvalStatus.EXECUTING);
            String result = this.restService.executeEvalTask(taskId);
            JSONObject obj = JSON.parseObject((String)result);
            if (0 != obj.getInteger("Result")) {
                String errorCode = obj.getString("ErrCode");
                ToolException e = new ToolException(errorCode, false);
                e.setDes(EvalResourceUtil.getErrorDes(errorCode));
                throw e;
            }
            this.pollingExecuteStat(taskId, des, finishNodes);
        }
        catch (ToolException e) {
            LOGGER.error("invoke eval faild.", (Throwable)e);
            String nodeIds = this.getNodeId(this.getNodeId(null), finishNodes);
            this.uiService.updateNodeTable(nodeIds, EvalStatus.FAILED);
            this.updateNodesErrorDetail(nodeIds, des, e.getErrorLocaleDescription());
            this.clearFailedNodes(finishNodes);
        }
        catch (Exception e) {
            LOGGER.error("invoke eval faild.", (Throwable)e);
            String nodeIds = this.getNodeId(this.getNodeId(null), finishNodes);
            this.uiService.updateNodeTable(nodeIds, EvalStatus.FAILED);
            this.updateNodesErrorDetail(nodeIds, des, ResourceUtil.getString((String)"perform.eval.error"));
            this.clearFailedNodes(finishNodes);
        }
        finally {
            this.uiService.getProgressUpdateUtil().setFinish(true);
            try {
                this.restService.clearTask(taskId);
            }
            catch (Exception e) {
                LOGGER.error("clear task failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eval(Set<String> task, String nodeType, String des) {
        String taskId = EXECUTE_TASK_ID;
        LinkedList<String> finishNodes = new LinkedList<String>();
        try {
            this.uiService.updateNodeTable(this.getNodeId(task, nodeType), EvalStatus.EXECUTING);
            this.uiService.updateDetailList(this.getNodeId(task, nodeType), des, EvalStatus.EXECUTING);
            String result = this.restService.executeEvalTask(taskId, task, nodeType);
            JSONObject obj = JSON.parseObject((String)result);
            if (0 != obj.getInteger("Result")) {
                String errorCode = obj.getString("ErrCode");
                ToolException e = new ToolException(errorCode, false);
                e.setDes(EvalResourceUtil.getErrorDes(errorCode));
                throw e;
            }
            this.pollingExecuteStat(taskId, des, finishNodes);
            boolean bl = true;
            return bl;
        }
        catch (ToolException e) {
            LOGGER.error("invoke eval faild.", (Throwable)e);
            String ids = this.getNodeId(task, nodeType, finishNodes);
            this.uiService.updateNodeTable(ids, EvalStatus.FAILED);
            this.updateNodesErrorDetail(ids, des, e.getErrorLocaleDescription());
            this.clearFailedNodes(task, nodeType, finishNodes);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("invoke eval faild.", (Throwable)e);
            String ids = this.getNodeId(task, nodeType, finishNodes);
            this.uiService.updateNodeTable(ids, EvalStatus.FAILED);
            this.updateNodesErrorDetail(ids, des, ResourceUtil.getString((String)"perform.eval.error"));
            this.clearFailedNodes(task, nodeType, finishNodes);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.restService.clearTask(taskId);
            }
            catch (Exception e) {
                LOGGER.error("clear task failed.", (Throwable)e);
            }
        }
    }

    private void distribtePkg(String nodeType, String detailDes) {
        LinkedList<String> nodes = this.evalInfo.getExecuteNodes(nodeType);
        if (nodes.isEmpty()) {
            LOGGER.warn(String.format(Locale.ENGLISH, "Distribte pkg to %s,but node list is empty", nodeType));
            return;
        }
        Set<Set<String>> tasks = this.splitTask(nodes);
        double maxLen = 10.0 / (double)tasks.size();
        for (Set<String> task : tasks) {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(10, maxLen);
            this.distribtePkg(nodeType, task, ResourceUtil.getString((String)"perform.eval.distribte"));
        }
    }

    private void pollingDistribteStat(String taskId, String nodeType, Set<String> task, String detailDes) throws ToolException {
        DistribteStat stat = DistribteStat.WATING;
        DistribteStat newStat = DistribteStat.WATING;
        LinkedList<String> failedNodes = new LinkedList<String>();
        int errorCount = 0;
        do {
            this.waitSomeTime();
            try {
                newStat = this.queryDistribteStat(taskId, nodeType, detailDes, failedNodes);
                errorCount = 0;
            }
            catch (ToolException e) {
                if (errorCount < maxRetryTime) {
                    ++errorCount;
                    continue;
                }
                throw e;
            }
            if (stat.equals((Object)newStat)) continue;
            stat = newStat;
            this.uiService.updateDetailList(this.getNodeId(task, nodeType), detailDes, stat.getStat());
        } while (DistribteStat.WATING.equals((Object)stat) || DistribteStat.EXECUTING.equals((Object)stat));
    }

    private void pollingExecuteStat(String taskId, String des, LinkedList<String> finishNodes) throws ToolException {
        block9: {
            int stat = 0;
            int oldStat = 0;
            int changed = 0;
            int errorCount = 0;
            int maxQueryTimes = maxQueryTime / 8000;
            int queryTime = 0;
            while (true) {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("polling eval stat sleep error.");
                }
                if (++queryTime > maxQueryTimes) {
                    throw new ToolException("execute.evaltask.timeout");
                }
                try {
                    String result = this.restService.queryTaskInfoChangedFlag(taskId);
                    JSONObject resultObj = JSON.parseObject((String)result);
                    changed = resultObj.getInteger("ChangeFlag");
                    stat = resultObj.getIntValue("TaskStatus");
                    if (1 == changed) {
                        this.queryChangedTaskInfo(taskId, des, finishNodes);
                    }
                    errorCount = 0;
                }
                catch (ToolException e) {
                    if (errorCount < maxRetryTime) {
                        ++errorCount;
                        continue;
                    }
                    throw e;
                }
                if (oldStat != stat) {
                    oldStat = stat;
                    queryTime = 0;
                }
                if (stat == 7) break block9;
                if (stat == 8) break;
            }
            throw new ToolException("perform.eval.error");
        }
        this.queryChangedTaskInfo(taskId, des, finishNodes);
    }

    private void queryChangedTaskInfo(String taskId, String des, LinkedList<String> finishNodes) throws ToolException {
        String result = this.restService.queryChangeTaskInfo(taskId);
        JSONObject obj = JSON.parseObject((String)result);
        JSONArray details = obj.getJSONArray("TaskDetail");
        LOGGER.info(String.format(Locale.ENGLISH, "finishNodes : %s", finishNodes.toString()));
        for (Object detail : details) {
            JSONObject nodeResult = (JSONObject)detail;
            int resultCode = nodeResult.getIntValue("RC");
            String errorCode = nodeResult.getString("EC");
            String ip = nodeResult.getString("IP");
            String nodeType = nodeResult.getString("NT");
            String nodeId = ip;
            nodeId = ip + nodeType;
            CheckNode checkNode = this.evalInfo.getCheckNodes().get(nodeId);
            if (finishNodes.contains(nodeId)) continue;
            if (0 == resultCode) {
                checkNode.setStatus(EvalStatus.PASS);
                this.uiService.updateDetailList(nodeId, des, EvalStatus.COMPLETE);
                this.uiService.updateDetailList(nodeId, ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.WAITING);
                finishNodes.add(nodeId);
                continue;
            }
            if (1 != resultCode && 7 != resultCode) continue;
            if (!StringUtils.isNULLStr((String)errorCode) && !"5001".equals(errorCode)) {
                checkNode.setStatus(EvalStatus.FAILED);
                DetailRecord rec = this.getErrorDetailRecord(des, EvalResourceUtil.getErrorDes(errorCode));
                rec.setNodeId(nodeId);
                this.uiService.updateDetailRecordList(rec);
                this.evalInfo.getExecuteNodes(nodeType).remove(ip);
                finishNodes.add(nodeId);
                continue;
            }
            checkNode.setStatus(EvalStatus.NOTPASS);
            this.uiService.updateDetailList(nodeId, des, EvalStatus.COMPLETE);
            this.uiService.updateDetailList(nodeId, ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.WAITING);
            finishNodes.add(nodeId);
        }
    }

    public DistribteStat queryDistribteStat(String taskId, String nodeType, String des, LinkedList<String> failedNodes) throws ToolException {
        String content = this.restService.queryDistributeStatus(taskId);
        JSONObject recordData = JSON.parseObject((String)content);
        String failNodeInfo = recordData.getString(FAIL_NODE_INFO);
        if (!StringUtils.isNULLStr((String)failNodeInfo)) {
            JSONArray failNodeInfos = JSON.parseArray((String)failNodeInfo);
            if (failNodeInfos == null) {
                return DistribteStat.valueOf(recordData.getIntValue(DISTRIBUTESTATUS_KEY));
            }
            for (Object object : failNodeInfos) {
                JSONObject failNode;
                String ip;
                String nodeId;
                if (!(object instanceof JSONObject) || failedNodes.contains(nodeId = (ip = (failNode = (JSONObject)object).getString(FAIL_NODE_IP)) + nodeType)) continue;
                failedNodes.add(nodeId);
                String errorCode = failNode.getString("ErrCode");
                String errorRes = EvalResourceUtil.getErrorDes(errorCode);
                this.uiService.updateNodeTable(nodeId, EvalStatus.FAILED);
                DetailRecord rec = this.getErrorDetailRecord(des, errorRes);
                rec.setNodeId(nodeId);
                this.uiService.updateDetailRecordList(rec);
                this.evalInfo.getExecuteNodes(nodeType).remove(ip);
            }
        }
        return DistribteStat.valueOf(recordData.getIntValue(DISTRIBUTESTATUS_KEY));
    }

    private void waitSomeTime() {
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread sleep error.");
        }
    }

    public EvalTask(PerformCardUiUpdateService uiUpdateService, FusionStoragePackingService service) {
        super(uiUpdateService, service);
    }

    @Override
    protected PerformCardLayout.Step getStep() {
        return STEP;
    }

    @Override
    public void postHandle() {
        this.uiService.updateStepUI(STEP.setStat(2));
    }

    public String getNodeId(Set<String> nodes, String nodeType) {
        return this.getNodeId(nodes, nodeType, null);
    }

    public String getNodeId(String nodeIds, List<String> exculdeList) {
        ArrayList<String> nodeIdsList = new ArrayList<String>(Arrays.asList(nodeIds.split(",")));
        nodeIdsList.removeAll(exculdeList);
        if (nodeIdsList.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", nodeIdsList);
    }

    public String getNodeId(Set<String> nodes, String nodeType, List<String> excludeList) {
        LinkedList<String> nodesList = this.evalInfo.getExecuteNodes(nodeType);
        LinkedList<String> list = new LinkedList<String>();
        for (String ip : nodes) {
            if (!nodesList.contains(ip)) continue;
            list.add(ip);
        }
        if (excludeList != null) {
            for (String excludeNodeId : excludeList) {
                list.remove(excludeNodeId.replace(nodeType, ""));
            }
        }
        if (list.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)(nodeType + ","), list) + nodeType;
    }

    public void clearFailedNodes(List<String> excludeNodeIds) {
        ArrayList<String> fsmNodes = new ArrayList<String>(this.evalInfo.getExecuteNodes("Manager"));
        ArrayList<String> fsaNodes = new ArrayList<String>(this.evalInfo.getExecuteNodes("Agent"));
        for (String excludeNodeId : excludeNodeIds) {
            if (excludeNodeId.contains("Manager")) {
                fsmNodes.remove(excludeNodeId.replace("Manager", ""));
                continue;
            }
            fsaNodes.remove(excludeNodeId.replace("Agent", ""));
        }
        this.evalInfo.getExecuteNodes("Manager").removeAll(fsmNodes);
        this.evalInfo.getExecuteNodes("Agent").removeAll(fsaNodes);
    }

    public void clearFailedNodes(Set<String> task, String nodeType) {
        for (String node : task) {
            this.evalInfo.getExecuteNodes(nodeType).remove(node);
        }
    }

    public void clearFailedNodes(Set<String> task, String nodeType, List<String> excludeList) {
        LinkedList<String> executedNodes = this.evalInfo.getExecuteNodes(nodeType);
        for (String nodeIp : task) {
            if (excludeList.contains(nodeIp + nodeType)) continue;
            executedNodes.remove(nodeIp);
        }
    }

    static {
        try {
            ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
            String limit = sysBundle.getString("fusionBlockLimit");
            blockSize = Integer.parseInt(limit);
            maxRetryTime = Integer.parseInt(sysBundle.getString("fusionBlockMaxRetryTime"));
            maxQueryTime = Integer.parseInt(sysBundle.getString("fusionBlockMaxQueryTime")) * 60 * 1000;
        }
        catch (Exception e) {
            LOGGER.warn("Init block error.", (Throwable)e);
        }
    }

    public static enum DistribteStat {
        WATING(EvalStatus.WAITING),
        EXECUTING(EvalStatus.EXECUTING),
        SUCCESS(EvalStatus.COMPLETE),
        FAILED(EvalStatus.NOTPASS);

        private EvalStatus stat = EvalStatus.WAITING;

        private DistribteStat(EvalStatus nodeStat) {
            this.stat = nodeStat;
        }

        public EvalStatus getStat() {
            return this.stat;
        }

        public static DistribteStat valueOf(int status) {
            switch (status) {
                case 0: {
                    return WATING;
                }
                case 1: {
                    return EXECUTING;
                }
                case 2: {
                    return SUCCESS;
                }
            }
            return FAILED;
        }
    }
}

