/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.evaltask;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.fusionstorage.entity.FusionStorageUserOpData;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.EvalTask;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.PostTask;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.Task;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.UploadTask;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStorageReportService;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStorageRestfulService;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteTask.class);
    private List<Task> tasks = new ArrayList<Task>();
    private PerformCardUiUpdateService uiService;
    private FusionStorageRestfulService restService = null;
    private volatile boolean finish = false;
    private ClusterEvalInfo evalInfo = null;
    private FusionStoragePackingService packingService = null;
    private String reExecuteType = "";

    public ExecuteTask(PerformCardUiUpdateService uiServicez, ClusterEvalInfo taskInfo) {
        this.evalInfo = taskInfo;
        this.uiService = uiServicez;
        this.packingService = new FusionStoragePackingService(this.evalInfo);
        this.tasks.add(new UploadTask(this.uiService, this.packingService));
        this.tasks.add(new EvalTask(this.uiService, this.packingService));
        this.tasks.add(new PostTask(this.uiService, this.packingService));
    }

    private boolean prepare() {
        this.evalInfo.setStartEval(true);
        this.finish = false;
        this.initUserOpData();
        String[] nodeIds = this.evalInfo.getExecuteNodeId(null).split(",");
        String detailDir = this.evalInfo.getDetailResultDir(true);
        for (String nodeId : nodeIds) {
            CheckNode node = this.evalInfo.getCheckNodes().get(nodeId);
            node.getResultPath().add(detailDir);
            node.initCheckTime();
            node.setErrorMsg("");
            node.setStatus(EvalStatus.WAITING);
        }
        this.evalInfo.getFailedCheckNode().clear();
        this.uiService.beginRefresh(nodeIds);
        this.evalInfo.setDistributeSuccessFsaNodesId("");
        this.evalInfo.setDistributeSuccessFsmNodesId("");
        try {
            this.uiService.updateDetailList(this.evalInfo.getExecuteNodeId(null), ResourceUtil.getString((String)"perform.eval.init.rest"), EvalStatus.EXECUTING);
            this.restService = new FusionStorageRestfulService(this.evalInfo);
            this.uiService.updateDetailList(this.evalInfo.getExecuteNodeId(null), ResourceUtil.getString((String)"perform.eval.init.rest"), EvalStatus.COMPLETE);
        }
        catch (Exception e) {
            LOGGER.error("Init rest service fail.", (Throwable)e);
            this.uiService.updateNodeTable(this.evalInfo.getExecuteNodeId(null), EvalStatus.FAILED);
            this.tasks.get(0).updateNodesErrorDetail(this.evalInfo.getExecuteNodeId(null), ResourceUtil.getString((String)"perform.eval.init.rest"), ResourceUtil.getStringWithParams((String)"rest.connect.fail", (Object[])new Object[]{this.evalInfo.getRestPort()}));
            return false;
        }
        for (Task task : this.tasks) {
            task.setRestService(this.restService);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FusionStorageUserOpData userOpData;
        LOGGER.info("Start execute eval task.");
        long startTime = System.currentTimeMillis();
        FusionStorageEvalContext.getInstance().getTaskInfo().setStartTime(startTime);
        String[] nodeIds = this.evalInfo.getExecuteNodeId(null).split(",");
        try {
            if (this.prepare()) {
                this.invoke();
            }
            this.buildReport();
            this.postHandle(nodeIds);
            userOpData = this.evalInfo.getCurrentUserOpData();
            userOpData.setExecuteUseTime(System.currentTimeMillis() - startTime);
        }
        catch (Throwable e) {
            FusionStorageUserOpData userOpData2;
            try {
                LOGGER.error("Execute task faild.", e);
                this.postHandle(nodeIds);
                userOpData2 = this.evalInfo.getCurrentUserOpData();
                userOpData2.setExecuteUseTime(System.currentTimeMillis() - startTime);
            }
            catch (Throwable throwable) {
                this.postHandle(nodeIds);
                FusionStorageUserOpData userOpData3 = this.evalInfo.getCurrentUserOpData();
                userOpData3.setExecuteUseTime(System.currentTimeMillis() - startTime);
                userOpData3.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
                userOpData3.setTaskResult(this.evalInfo.isAllPassed() ? UserOpTaskResult.SUCCESS : UserOpTaskResult.FAILED);
                userOpData3.recordNotpassItemIds();
                FusionStorageEvalContext.getInstance().getUserOpDatas().add(userOpData3);
                throw throwable;
            }
            userOpData2.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
            userOpData2.setTaskResult(this.evalInfo.isAllPassed() ? UserOpTaskResult.SUCCESS : UserOpTaskResult.FAILED);
            userOpData2.recordNotpassItemIds();
            FusionStorageEvalContext.getInstance().getUserOpDatas().add(userOpData2);
        }
        userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        userOpData.setTaskResult(this.evalInfo.isAllPassed() ? UserOpTaskResult.SUCCESS : UserOpTaskResult.FAILED);
        userOpData.recordNotpassItemIds();
        FusionStorageEvalContext.getInstance().getUserOpDatas().add(userOpData);
    }

    private void invoke() {
        for (Task task : this.tasks) {
            if (!task.preCheck() || !task.invoke()) {
                LOGGER.info("task invoke faild.");
                this.uiService.updateButtomDes(ResourceUtil.getString((String)"perform.eval.finish.error"));
                this.uiService.updateStepUI(task.getStep().setStat(3));
                this.uiService.updateProgress(90);
                break;
            }
            task.postHandle();
        }
        this.uiService.updateProgress(90);
    }

    private void postHandle(String[] nodeIds) {
        this.packingService.clearProjectWorkSpace();
        if (this.restService != null) {
            this.restService.closeConnection();
        }
        Map<String, Integer> sum = this.evalInfo.calcEvalResult();
        this.uiService.updateButtomDes(ResourceUtil.getStringWithParams((String)"perform.eval.result", (Object[])new Object[]{sum.get("sumNum"), sum.get("passNum"), sum.get("notPassNum"), sum.get("faildNum")}));
        FusionStorageUserOpData userOpData = this.evalInfo.getCurrentUserOpData();
        userOpData.setPassNodeNum(sum.get("passNum"));
        userOpData.setNotPassNodeNum(sum.get("notPassNum"));
        userOpData.setNotCompleteNodeNum(sum.get("faildNum"));
        if (PerformCardLayout.Step.POST.getStat() == 1) {
            this.uiService.updateStepUI(PerformCardLayout.Step.POST.setStat(2));
            this.uiService.updateStepUI(PerformCardLayout.Step.FINISH.setStat(2));
        }
        for (String nodeId : nodeIds) {
            this.uiService.updateNodeTable(nodeId, this.evalInfo.getCheckNodes().get(nodeId).getStatus());
        }
        this.finish = true;
        this.uiService.finishRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReport() {
        LOGGER.info("Start build eval report.");
        this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(10, 10.0);
        this.uiService.updateButtomDes(ResourceUtil.getString((String)"perform.eval.report.building"));
        FusionStorageReportService report = new FusionStorageReportService();
        Future<Boolean> futureFailedAll = report.startFailedNodesDetailListener();
        List<String> failNodeIds = report.buildNodesDetailPage();
        report.setAllNodeStatus(true);
        if (failNodeIds == null) {
            this.uiService.updateNodeTable(this.evalInfo.getExecuteNodeId(null), EvalStatus.FAILED);
            this.uiService.updateButtomDes(ResourceUtil.getString((String)"perform.eval.report.build.fail"));
        } else if (!failNodeIds.isEmpty()) {
            this.uiService.updateNodeTable(String.join((CharSequence)",", failNodeIds), EvalStatus.FAILED);
            for (String failNodeId : failNodeIds) {
                DetailRecord rec = this.uiService.getErrorDetailRecord(ResourceUtil.getString((String)"perform.eval.report.build"), ResourceUtil.getString((String)"perform.eval.report.build.fail"));
                rec.setNodeId(failNodeId);
                this.uiService.updateDetailRecordList(rec);
            }
        }
        report.buildResultExcel();
        if (!report.buildReport()) {
            this.uiService.updateButtomDes(ResourceUtil.getString((String)"perform.eval.report.build.fail"));
            return;
        }
        try {
            futureFailedAll.get();
        }
        catch (InterruptedException e) {
            LOGGER.error("building error summary but interrupted");
        }
        catch (ExecutionException e) {
            LOGGER.error("building error summary but failed");
        }
        finally {
            report.terminateThreadPool();
        }
        String reportName = this.getReportName();
        File resultDir = new File(this.evalInfo.getResultDir());
        if (!resultDir.exists()) {
            resultDir.mkdirs();
        }
        ZipUtils.compressFile((String)(this.evalInfo.getResultDir() + File.separator + reportName), (String)Constants.REPORT_TEMP_DIR);
        FileUtils.setFilePermissions((String)(this.evalInfo.getResultDir() + File.separator + reportName));
        this.uiService.getProgressUpdateUtil().setFinish(true);
    }

    private String getReportName() {
        if (InspectUtils.isFusionEval()) {
            return "FusionStorage_eval_report_" + StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
        }
        if (InspectUtils.isFusionCubeEval()) {
            return "FusionCube_eval_report_" + StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
        }
        return "FusionStorage_inspect_report_" + StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
    }

    public boolean isFinish() {
        return this.finish;
    }

    private void initUserOpData() {
        FusionStorageUserOpData currentUserOpData = new FusionStorageUserOpData();
        this.evalInfo.setCurrentUserOpData(currentUserOpData);
        Map<String, Set<String>> itemMap = FusionStorageEvalContext.getInstance().getCheckItemsNodeMapper();
        currentUserOpData.setExecuteNodeNum(this.evalInfo.getExecuteNodes(null).size());
        currentUserOpData.setFSMCheckItemNum(itemMap.get("Manager").size());
        currentUserOpData.setFSACheckItemNum(itemMap.get("Agent").size());
        if (InspectUtils.isFusionCubeEval()) {
            currentUserOpData.setFusionCubeFsmItemNum(itemMap.get("Cube_FSM").size());
            currentUserOpData.setFusionCubeFsaItemNum(itemMap.get("Cube_FSA").size());
        }
        currentUserOpData.setClusterMode(this.evalInfo.getMode().name());
        currentUserOpData.setToolType(this.getToolType());
        currentUserOpData.setDevNode(EntityUtils.toNewDev((DevNode)this.evalInfo.getPrimaryNode()));
        currentUserOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        currentUserOpData.setReExecute(this.reExecuteType);
    }

    private String getToolType() {
        if (InspectUtils.isFusionEval()) {
            return "FusionStorage Update Eval";
        }
        if (InspectUtils.isFusionCubeEval()) {
            return "FusionCube Update Eval";
        }
        return "FusionStorage Inspect";
    }

    public void setReExecuteType(String reExecuteType) {
        this.reExecuteType = reExecuteType;
    }
}

