/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.evaltask;

import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.RestAuth;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.Task;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostTask.class);
    private static final PerformCardLayout.Step STEP = PerformCardLayout.Step.POST;

    public PostTask(PerformCardUiUpdateService uiUpdateService, FusionStoragePackingService packingServicz) {
        super(uiUpdateService, packingServicz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke() {
        STEP.setStat(1);
        this.uiService.updateStepUI(STEP);
        long startTime = System.currentTimeMillis();
        try {
            this.uiService.updateDetailList(this.getNodeId(null), ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.EXECUTING);
            this.uiService.initCheckResult(this.getNodeId(null).split(","), null);
            this.setCheckFinishTime(this.evalInfo.getExecuteNodeId(null).split(","));
            this.collectPriFsmAndFsaResult();
            if (ClusterMode.DOUBLE.equals((Object)this.evalInfo.getMode())) {
                this.collectStandyResult();
            }
            if (this.evalInfo.getExecuteNodes(null).isEmpty()) {
                LOGGER.warn("All nodes result collect fail.");
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("collect result error.", (Throwable)e);
            this.uiService.updateDetailList(this.getNodeId(null), ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.FAILED);
        }
        finally {
            this.recordStepUseTime(startTime, System.currentTimeMillis(), "collect");
            this.uiService.initCheckResult(this.getNodeId(null).split(","), Boolean.FALSE);
            this.uiService.updateCheckResultDetail();
            this.commitProject();
        }
        return true;
    }

    private void collectStandyResult() {
        String standyNodeId = this.evalInfo.getStandbyNode().getDeviceSerialNumber();
        String standyNodeIp = this.evalInfo.getStandbyNode().getIp();
        try {
            if (!this.evalInfo.getExecuteNodes("Manager").contains(standyNodeIp)) {
                LOGGER.warn("Executed isn't contains standyNodes.");
                return;
            }
            this.packingService.collectSecondaryFsmEvalResults();
            this.uiService.updateDetailList(standyNodeId, ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.COMPLETE);
        }
        catch (ToolException e) {
            LOGGER.error("exception occurred on post task:", (Throwable)e);
            String des = ResourceUtil.getString((String)"perform.eval.collect");
            String errorMsg = e.getDes();
            this.uiService.updateNodeTable(standyNodeId, EvalStatus.FAILED);
            this.updateNodesErrorDetail(standyNodeId, des, errorMsg);
            this.evalInfo.getExecuteNodes("Manager").remove(this.evalInfo.getStandbyNode().getIp());
        }
        catch (Exception e) {
            LOGGER.error("exception occurred on post task:", (Throwable)e);
            String des = ResourceUtil.getString((String)"perform.eval.collect");
            String errorMsg = ResourceUtil.getString((String)"download.file.failed");
            this.uiService.updateNodeTable(standyNodeId, EvalStatus.FAILED);
            this.updateNodesErrorDetail(standyNodeId, des, errorMsg);
            this.evalInfo.getExecuteNodes("Manager").remove(this.evalInfo.getStandbyNode().getIp());
        }
    }

    private void collectPriFsmAndFsaResult() {
        block6: {
            try {
                if (this.evalInfo.getMode().equals((Object)ClusterMode.DOUBLE)) {
                    String nodeInfo = this.restService.fetchFSMNodeInfo();
                    RestAuth auth = new RestAuth();
                    auth.handleFSMInfo(this.evalInfo, nodeInfo);
                }
                this.packingService.collectPrimaryFsmAndFsasEvalResults();
                this.uiService.updateDetailList(this.evalInfo.getExecuteNodeId("Agent"), ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.COMPLETE);
                String priNodeId = this.evalInfo.getPrimaryNode().getDeviceSerialNumber();
                if (this.evalInfo.getExecuteNodeId("Manager").contains(priNodeId)) {
                    this.uiService.updateDetailList(priNodeId, ResourceUtil.getString((String)"perform.eval.collect"), EvalStatus.COMPLETE);
                }
            }
            catch (ToolException e) {
                LOGGER.error("exception occurred on post task:", (Throwable)e);
                String fsaNodeIds = this.evalInfo.getExecuteNodeId("Agent");
                String des = ResourceUtil.getString((String)"perform.eval.collect");
                String errorMsg = e.getDes();
                this.uiService.updateNodeTable(fsaNodeIds, EvalStatus.FAILED);
                this.updateNodesErrorDetail(fsaNodeIds, des, errorMsg);
                this.evalInfo.getExecuteNodes("Agent").clear();
                if (this.evalInfo.getExecuteNodes("Manager").contains(this.evalInfo.getPrimaryNode().getIp())) {
                    String priNodeId = this.evalInfo.getPrimaryNode().getDeviceSerialNumber();
                    this.uiService.updateNodeTable(priNodeId, EvalStatus.FAILED);
                    this.updateNodesErrorDetail(priNodeId, des, errorMsg);
                    this.evalInfo.getExecuteNodes("Manager").remove(this.evalInfo.getPrimaryNode().getIp());
                }
            }
            catch (Exception e) {
                LOGGER.error("exception occurred on post task:", (Throwable)e);
                String fsaNodeIds = this.evalInfo.getExecuteNodeId("Agent");
                String des = ResourceUtil.getString((String)"perform.eval.collect");
                String errorMsg = ResourceUtil.getString((String)"download.file.failed");
                this.uiService.updateNodeTable(fsaNodeIds, EvalStatus.FAILED);
                this.updateNodesErrorDetail(fsaNodeIds, des, errorMsg);
                this.evalInfo.getExecuteNodes("Agent").clear();
                if (!this.evalInfo.getExecuteNodes("Manager").contains(this.evalInfo.getPrimaryNode().getIp())) break block6;
                String priNodeId = this.evalInfo.getPrimaryNode().getDeviceSerialNumber();
                this.uiService.updateNodeTable(priNodeId, EvalStatus.FAILED);
                this.updateNodesErrorDetail(priNodeId, des, errorMsg);
                this.evalInfo.getExecuteNodes("Manager").remove(this.evalInfo.getPrimaryNode().getIp());
            }
        }
    }

    private void setCheckFinishTime(String[] nodeIds) {
        Date date = new Date();
        Map<String, CheckNode> checkNodes = this.evalInfo.getCheckNodes();
        for (String nodeId : nodeIds) {
            CheckNode checkNode = checkNodes.get(nodeId);
            if (checkNode == null) continue;
            checkNode.setCheckFinishTime(date);
        }
    }

    @Override
    protected PerformCardLayout.Step getStep() {
        return STEP;
    }

    @Override
    public void postHandle() {
        this.uiService.getProgressUpdateUtil().setFinish(true);
    }

    @Override
    public boolean preCheck() {
        boolean pass = super.preCheck();
        if (pass) {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(30, 30.0);
        }
        return pass;
    }
}

