/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.evaltask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.entity.FusionStorageUserOpData;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStorageRestfulService;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task {
    protected static final String EXECUTE_TASK_ID = Task.initTaskId();
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    protected FusionStorageRestfulService restService = null;
    protected PerformCardUiUpdateService uiService = null;
    protected FusionStoragePackingService packingService = null;
    protected ClusterEvalInfo evalInfo = FusionStorageEvalContext.getInstance().getTaskInfo();

    private static String initTaskId() {
        if (InspectUtils.isFusionEval()) {
            return "1562743558144";
        }
        if (InspectUtils.isFusionCubeEval()) {
            return "1610090114789";
        }
        return "1562743558145";
    }

    public Task(FusionStorageRestfulService restFulService, PerformCardUiUpdateService uiUpdateService, FusionStoragePackingService packingServicz) {
        this.restService = restFulService;
        this.uiService = uiUpdateService;
        this.packingService = packingServicz;
    }

    public Task(PerformCardUiUpdateService uiUpdateService, FusionStoragePackingService packingServicz) {
        this.uiService = uiUpdateService;
        this.packingService = packingServicz;
    }

    public void setRestService(FusionStorageRestfulService restService) {
        this.restService = restService;
    }

    public abstract boolean invoke();

    public boolean preCheck() {
        return !this.evalInfo.getExecuteNodes(null).isEmpty();
    }

    public abstract void postHandle();

    protected String getNodeId(String nodeType) {
        return this.evalInfo.getExecuteNodeId(nodeType);
    }

    protected DetailRecord getErrorDetailRecord(String nameDes, String errorInfo) {
        return this.uiService.getErrorDetailRecord(nameDes, errorInfo);
    }

    protected void updateNodesErrorDetail(String nodeIds, String nameDes, String errorInfo) {
        if (StringUtils.isNULLStr((String)nodeIds)) {
            LOGGER.warn("Update nodes error detail,but nodes is empty.");
            return;
        }
        String[] nodeIdArray = nodeIds.split(",");
        List<String> allNodes = Arrays.asList(this.evalInfo.getExecuteNodeId(null).split(","));
        for (String nodeId : nodeIdArray) {
            if (!allNodes.contains(nodeId)) continue;
            DetailRecord errorDetail = this.uiService.getErrorDetailRecord(nameDes, errorInfo);
            errorDetail.setNodeId(nodeId);
            this.uiService.updateDetailRecordList(errorDetail);
        }
    }

    protected static String generateUid() {
        return System.currentTimeMillis() + "";
    }

    protected abstract PerformCardLayout.Step getStep();

    public void commitProject() {
        String taskId = EXECUTE_TASK_ID;
        if (StringUtils.isNULLStr((String)this.evalInfo.getDistributeSuccessFsaNodesId()) & StringUtils.isNULLStr((String)this.evalInfo.getDistributeSuccessFsmNodesId())) {
            LOGGER.info("No nodes distribute success.");
            return;
        }
        try {
            this.uiService.updateButtomDes(ResourceUtil.getString((String)"perform.eval.clear"));
            this.clearTask(taskId);
            this.restService.commitTask(taskId);
            this.waitTillTaskFinished(taskId);
        }
        catch (Exception e) {
            LOGGER.error("Commit task faild.", (Throwable)e);
        }
        finally {
            this.clearTask(taskId);
        }
    }

    public void waitTillTaskFinished(String taskId) throws ToolException {
        boolean isFinished = false;
        while (!isFinished) {
            try {
                Thread.sleep(8000L);
                String result = this.restService.queryTaskInfoChangedFlag(taskId);
                JSONObject resultObj = JSON.parseObject((String)result);
                int stat = resultObj.getIntValue("TaskStatus");
                if (stat == 7) {
                    isFinished = true;
                    break;
                }
                if (stat != 8) continue;
                LOGGER.error("the task does not exists anymore, quit. ");
                break;
            }
            catch (InterruptedException e) {
                LOGGER.error("try to wait for next sheduled task query but interrupted");
            }
        }
    }

    private void clearTask(String taskId) {
        try {
            this.restService.clearTask(taskId);
        }
        catch (Exception e) {
            LOGGER.warn(String.format(Locale.ENGLISH, "clear task failed. task id is %s", taskId));
        }
    }

    protected void recordStepUseTime(long startTime, long endTime, String stepName) {
        FusionStorageUserOpData userOpData = this.evalInfo.getCurrentUserOpData();
        userOpData.addStepExecuteTime(stepName, endTime - startTime);
    }
}

