/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.evaltask;

import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.Task;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadTask.class);
    private static final PerformCardLayout.Step STEP = PerformCardLayout.Step.UPLOAD;

    public UploadTask(PerformCardUiUpdateService uiUpdateService, FusionStoragePackingService packingServicz) {
        super(uiUpdateService, packingServicz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke() {
        long startTime = System.currentTimeMillis();
        this.uiService.updateStepUI(STEP.setStat(1));
        String uploadDetailDes = ResourceUtil.getString((String)"uploading.step.start.to.upload");
        this.uiService.updateDetailList(this.getNodeId(null), uploadDetailDes, EvalStatus.EXECUTING);
        LOGGER.info("Start upload file task.");
        try {
            String localFilePath = this.packingService.packingCurFiles();
            this.packingService.upload2RemoteFsmNode(localFilePath);
            this.uiService.updateDetailList(this.getNodeId(null), uploadDetailDes, EvalStatus.COMPLETE);
        }
        catch (ToolException e) {
            this.uiService.updateNodeTable(this.getNodeId(null), EvalStatus.FAILED);
            this.updateNodesErrorDetail(this.getNodeId(null), uploadDetailDes, e.getDes());
            this.evalInfo.getExecuteNodes("Manager").clear();
            this.evalInfo.getExecuteNodes("Agent").clear();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.uiService.updateNodeTable(this.getNodeId(null), EvalStatus.FAILED);
            this.updateNodesErrorDetail(this.getNodeId(null), uploadDetailDes, ResourceUtil.getString((String)"upload.file.2.remote.error"));
            this.evalInfo.getExecuteNodes("Manager").clear();
            this.evalInfo.getExecuteNodes("Agent").clear();
            boolean bl = false;
            return bl;
        }
        finally {
            this.recordStepUseTime(startTime, System.currentTimeMillis(), "upload");
        }
        return true;
    }

    @Override
    protected PerformCardLayout.Step getStep() {
        return STEP;
    }

    @Override
    public void postHandle() {
        this.uiService.updateStepUI(STEP.setStat(2));
        this.uiService.getProgressUpdateUtil().setFinish(true);
    }

    @Override
    public boolean preCheck() {
        boolean pass = super.preCheck();
        if (pass) {
            this.uiService.getProgressUpdateUtil().updateProgressWithExceptTime(15, 10.0);
        }
        return pass;
    }
}

