/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.impl;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.service.BaseService;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStoragePackingService
implements BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStoragePackingService.class);
    public static final String DEST_PACKAGE_CFG_FILE_NAME = "package.cfg";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final String TARGZ_FILE_SUFFIX = ".tar.gz";
    public static String packageDir = "";
    public static String zipBallRootDir = "";
    private static final String FSM_RESULT_PLACEHOLDER_REGEX = "\\[ip\\]";
    private static final String SECONDARY_FSM_RESULT_LOCATION = "/var/log/dsware/";
    private static final String COLLECT_INFO = "collectInfo";
    private static String secondyFsmInfollectPatten = "";
    private static String primaryNodeResultName = "";
    private static String secondaryFsmResultPatten = "";
    private static int collectLimit = 20;
    private static int collectTimeLimit = 1200;
    private static int interval = 30;
    private ClusterEvalInfo clusterInfo;

    public FusionStoragePackingService(ClusterEvalInfo clusterInfo1) {
        this.clusterInfo = clusterInfo1;
    }

    public String packingCurFiles() throws ToolException {
        File tempDir = new File(Constants.TEMP_DIR);
        if (!tempDir.exists()) {
            boolean success = tempDir.mkdirs();
            LOGGER.info(String.format(Locale.ENGLISH, "create temp dir %b", success));
        }
        this.clearProjectWorkSpace();
        String packagePath = this.clusterInfo.getPackagePath();
        String[] dirs = packagePath.split("\\\\|/");
        String srcRootDir = FusionStoragePackingService.getCurPackageRootDir();
        LOGGER.info(String.format(Locale.ENGLISH, "source root dir: %s", srcRootDir));
        String srcTarDir = "";
        for (int poi = 0; poi < dirs.length; ++poi) {
            if (!StringUtils.isNULLStr((String)dirs[poi])) {
                srcRootDir = srcRootDir + dirs[poi] + File.separator;
            }
            if (poi != dirs.length - 1) continue;
            srcTarDir = srcRootDir + zipBallRootDir;
            break;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "business tar package dir: %s", srcTarDir));
        if (!this.writeConfig(srcTarDir)) {
            throw new ToolException("target.version.is.not.set");
        }
        LOGGER.info("copy file to temp dir...");
        FileUtils.copyDir((String)srcRootDir, (String)(Constants.PACKING_TEMP + File.separator + zipBallRootDir), (File[])((File[])Arrays.asList(new File(srcTarDir)).toArray()));
        LOGGER.info("now start to compress tar.gz file...");
        if (!this.compressTarGzFile(srcTarDir, Constants.PACKING_TEMP)) {
            throw new ToolException("compress.tar.gz.file.failed");
        }
        String destiFilePath = Constants.PACKING_TEMP + zipBallRootDir + ZIP_FILE_SUFFIX;
        if (!FileAssistant.compressFileZipSaveMode((String)destiFilePath, (String[])new String[]{Constants.PACKING_TEMP + zipBallRootDir})) {
            throw new ToolException("compress.zip.file.failed");
        }
        File file = new File(destiFilePath);
        if (!file.exists()) {
            LOGGER.error(String.format(Locale.ENGLISH, "Destination zip file not exists: %s", destiFilePath));
            throw new ToolException("zip.file.not.exist");
        }
        return destiFilePath;
    }

    public void upload2RemoteFsmNode(String localFilePath) throws ToolException {
        if (localFilePath == null || !new File(localFilePath).exists()) {
            throw new ToolException("target.file.invalid");
        }
        DevNode devNode = this.clusterInfo.getCheckNodes().get(this.clusterInfo.getPrimaryNode().getDeviceSerialNumber()).getDevNode();
        this.uploadAndSign(localFilePath, devNode);
        if (this.clusterInfo.getMode().equals((Object)ClusterMode.DOUBLE)) {
            devNode = this.clusterInfo.getCheckNodes().get(this.clusterInfo.getStandbyNode().getDeviceSerialNumber()).getDevNode();
            this.uploadAndSign(localFilePath, devNode);
        }
    }

    public void collectPrimaryFsmAndFsasEvalResults() throws ToolException {
        SshConnection connection = null;
        try {
            DevNode devNode = this.clusterInfo.getCheckNodes().get(this.clusterInfo.getPrimaryNode().getDeviceSerialNumber()).getDevNode();
            String distResultTarFile = this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/" + primaryNodeResultName;
            connection = (SshConnection)SshConnectionManager.getSshConnection((DevNode)devNode);
            this.clearRemoteResultPathDir(connection, distResultTarFile);
            String authCmd = "chmod 750 " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/" + "getCheckResultInfo.sh";
            String echos = connection.execCmd(authCmd);
            String cmd = this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/" + "getCheckResultInfo.sh" + " " + this.getCollectArgs();
            echos = connection.execCmdWithKeepAlive(cmd, interval, collectTimeLimit);
            echos = connection.execCmd("find " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/ -name \"" + primaryNodeResultName + "\"");
            String localJsonFilesDir = this.clusterInfo.getDetailResultDir(false);
            if (!echos.contains(distResultTarFile)) {
                throw new ToolException("result.file.not.generated");
            }
            SftpConnector connector = new SftpConnector(devNode);
            connector.getFile(localJsonFilesDir, distResultTarFile, null);
            FileAssistant.deCompressTarGzFile2TargetDir((String)localJsonFilesDir, (String)(localJsonFilesDir + primaryNodeResultName));
            File targzFile = new File(localJsonFilesDir + primaryNodeResultName);
            if (!targzFile.delete()) {
                LOGGER.error("failed to delete result targz file.");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "exception occurred sftp get file from %s", this.clusterInfo.getPrimaryNode().getIp()), (Throwable)e);
            throw new ToolException("download.file.failed");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)this.clusterInfo.getPrimaryNode());
        }
    }

    private String getCollectArgs() {
        String args = "";
        LinkedList<String> fsaNodes = this.clusterInfo.getExecuteNodes("Agent");
        args = fsaNodes.size() >= collectLimit ? "" : (fsaNodes.isEmpty() ? "NO_FSA" : String.join((CharSequence)",", fsaNodes));
        return args;
    }

    private void clearRemoteResultPathDir(SshConnection connection, String distResultTarFile) {
        try {
            String commandLine = "rm -rf " + distResultTarFile;
            LOGGER.info(String.format(Locale.ENGLISH, "executing command: %s.", commandLine));
            connection.execCmd(commandLine);
        }
        catch (Exception e) {
            LOGGER.error("error occurred clearing result file on remote host.", (Throwable)e);
        }
    }

    public void collectSecondaryFsmEvalResults() throws ToolException {
        SshConnection connection = null;
        try {
            DevNode devNode = this.clusterInfo.getCheckNodes().get(this.clusterInfo.getStandbyNode().getDeviceSerialNumber()).getDevNode();
            String scndryEvalResultName = secondaryFsmResultPatten.replaceFirst(FSM_RESULT_PLACEHOLDER_REGEX, this.clusterInfo.getStandbyNode().getIp());
            connection = (SshConnection)SshConnectionManager.getSshConnection((DevNode)devNode);
            String echos = connection.execCmd("find /var/log/dsware/ -name \"" + scndryEvalResultName + "\"");
            String targetPath = SECONDARY_FSM_RESULT_LOCATION + scndryEvalResultName;
            if (!echos.contains(targetPath)) {
                throw new ToolException("second.fsm.result.not.found");
            }
            String localJsonFilesDir = this.clusterInfo.getDetailResultDir(false);
            SftpConnector connector = new SftpConnector(devNode);
            connector.getFileByNameHasIPV6(localJsonFilesDir, scndryEvalResultName, targetPath);
            String secondInfoCollectName = secondyFsmInfollectPatten.replaceFirst(FSM_RESULT_PLACEHOLDER_REGEX, this.clusterInfo.getStandbyNode().getIp());
            try {
                connector.getFileByNameHasIPV6(localJsonFilesDir + File.separator + COLLECT_INFO, secondInfoCollectName, SECONDARY_FSM_RESULT_LOCATION + secondInfoCollectName);
            }
            catch (Exception e) {
                LOGGER.error("secondary node collect infoCollect file failed.");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "exception occurred sftp get file from ", this.clusterInfo.getStandbyNode().getIp()), (Throwable)e);
            throw new ToolException("download.second.fsm.file.failed");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)this.clusterInfo.getStandbyNode());
        }
    }

    public void clearProjectWorkSpace() {
        FileUtils.deleteAllInFolder((String)Constants.PACKING_TEMP);
    }

    private boolean uploadAndSign(String localFilePath, DevNode devNode) throws ToolException {
        SshConnection connection = null;
        String echos = "";
        try {
            String unzipCmd;
            connection = (SshConnection)SshConnectionManager.getSshConnection((DevNode)devNode);
            echos = connection.execCmd("mkdir -vp " + this.clusterInfo.getFsmUploadPath());
            String changeOwnerCmd = "chown -Rh dsware:omm /opt/dsware/update/";
            connection.execCmd(changeOwnerCmd);
            SftpConnector connector = new SftpConnector(devNode);
            connector.putFile(localFilePath, this.clusterInfo.getFsmUploadPath(), null);
            String targetFilePath = this.clusterInfo.getFsmUploadPath() + zipBallRootDir + ZIP_FILE_SUFFIX;
            String findCmd = "find " + this.clusterInfo.getFsmUploadPath() + " -name \"" + zipBallRootDir + ZIP_FILE_SUFFIX + "\"";
            echos = connection.execCmd(findCmd);
            if (!echos.contains(targetFilePath)) {
                LOGGER.error(String.format(Locale.ENGLISH, "the target file path %s is not found.", targetFilePath));
            }
            if ((echos = connection.execCmd(unzipCmd = "unzip -o " + targetFilePath + " -d " + this.clusterInfo.getFsmUploadPath())).contains("[y]es, [n]o, [A]ll, [N]one, [r]ename:")) {
                connection.execCmd(unzipCmd, Arrays.asList("[y]es, [n]o, [A]ll, [N]one, [r]ename:"));
                connection.execCmd("y");
            }
            if (FusionStorageConfig.isDos2UnixSwitchOpened()) {
                this.dos2UnixFiles(connection);
            }
            String shaCmd = "sha256sum " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/" + zipBallRootDir + TARGZ_FILE_SUFFIX + " > " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + "/" + zipBallRootDir + TARGZ_FILE_SUFFIX + ".sha256";
            LOGGER.info(String.format(Locale.ENGLISH, "running sha signature cmd: ", shaCmd));
            connection.execCmd(shaCmd);
            String authorizeCmd = "chmod 750 " + this.clusterInfo.getFsmUploadPath();
            connection.execCmd(authorizeCmd);
            changeOwnerCmd = "chown -Rh dsware:omm " + this.clusterInfo.getFsmUploadPath();
            connection.execCmd(changeOwnerCmd);
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "exception occurred put file to %s", devNode.getIp()), (Throwable)e);
            throw new ToolException("upload.file.2.remote.error");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)devNode);
        }
        return true;
    }

    private void dos2UnixFiles(SshConnection connection) {
        String depressedFileName = this.clusterInfo.getFsmUploadPath() + zipBallRootDir;
        String innnerCompressedFileName = depressedFileName + "/" + zipBallRootDir;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("mkdir -p " + innnerCompressedFileName);
        cmds.add("tar zxvf " + innnerCompressedFileName + ".tar.gz -C " + innnerCompressedFileName);
        cmds.add("find " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + " -name \"*.sh\" | xargs dos2unix");
        cmds.add("find " + this.clusterInfo.getFsmUploadPath() + zipBallRootDir + " -name \"*.lua\" | xargs dos2unix");
        cmds.add("rm -rf " + innnerCompressedFileName + TARGZ_FILE_SUFFIX);
        cmds.add("cd " + depressedFileName + "/" + zipBallRootDir + "/&&tar zcvf " + innnerCompressedFileName + ".tar.gz *");
        cmds.add("rm -rf " + innnerCompressedFileName + "&&cd ~");
        cmds.forEach(cmd -> {
            try {
                String echo = connection.execCmd(cmd);
                LOGGER.info(echo);
            }
            catch (ToolException e) {
                LOGGER.error("dos2unix error!{}", (Throwable)e);
            }
        });
    }

    private boolean compressTarGzFile(String sourceFile, String targetDir) {
        String tarFile = targetDir + File.separator + zipBallRootDir + ".tar";
        boolean isOk = FileAssistant.compressFile2AnyFileType((String)(sourceFile + File.separator + "*"), (String)tarFile);
        if (!isOk) {
            LOGGER.error("compress file to tar ball failed.");
            return false;
        }
        String targzFile = targetDir + File.separator + zipBallRootDir + File.separator + zipBallRootDir + TARGZ_FILE_SUFFIX;
        return FileAssistant.compressFile2AnyFileType((String)tarFile, (String)targzFile);
    }

    public static final String getCurPackageRootDir() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        return workPath + File.separator + packageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeConfig(String tarGzFileLoc) {
        Properties config = FusionStorageEvalContext.getInstance().getTaskInfo().getConfig();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(tarGzFileLoc + File.separator + DEST_PACKAGE_CFG_FILE_NAME));
            config.store(writer, "");
            StreamUtils.closeResource((Flushable)writer, (Closeable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Write config info error.");
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.closeResource(writer, writer);
        }
        return true;
    }

    static {
        if (InspectUtils.isFusionInspect()) {
            packageDir = "packages" + File.separator + "inspector" + File.separator + "products" + File.separator + "FusionStorInspectV1R3R6" + File.separator;
            primaryNodeResultName = "inspect_result.tar.gz";
            secondaryFsmResultPatten = "FSM_[ip]_inspect_result.json";
            zipBallRootDir = "FusionStorage_Block_Inspect";
            secondyFsmInfollectPatten = "FSM_[ip]_inspect_result_collect.txt";
        } else if (InspectUtils.isFusionEval() || InspectUtils.isFusionStorage2Update() || InspectUtils.isFusionCubeEval()) {
            packageDir = "packages" + File.separator + "inspector" + File.separator + "products" + File.separator + "FusionStorUpgEvalV1R3R6" + File.separator;
            primaryNodeResultName = "upgrade_precheck_result.tar.gz";
            secondaryFsmResultPatten = "FSM_[ip]_upgrade_precheck.json";
            zipBallRootDir = "FusionStorage_Block_Precheck";
            secondyFsmInfollectPatten = "FSM_[ip]_upgrade_precheck_collect.txt";
        }
        try {
            ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
            collectLimit = Integer.parseInt(sysBundle.getString("fusionCollectLimit"));
            collectTimeLimit = Integer.parseInt(sysBundle.getString("fusionCollectTimeLimit"));
        }
        catch (Exception e) {
            LOGGER.warn("Init collect limit faild.");
        }
    }
}

