/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.fusionstorage.MigarationInfoBuilder;
import com.huawei.ism.tool.fusionstorage.common.FusionConstants;
import com.huawei.ism.tool.fusionstorage.entity.FusionCheckItem;
import com.huawei.ism.tool.fusionstorage.entity.FusionStorageUserOpData;
import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckResult;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.entity.FusionExcelSummaryEntry;
import com.huawei.ism.tool.fusionstorage.eval.entity.NodeResult;
import com.huawei.ism.tool.fusionstorage.eval.entity.UpgradePathConfigDto;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FailedNodeRecordEntry;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.inspect.logic.result.DetailEntry;
import com.huawei.ism.tool.inspect.logic.result.ExcelResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.TemplateFactory;
import com.huawei.ism.tool.inspect.logic.result.ZTreeNode;
import com.huawei.ism.tool.inspect.utils.ChannelWriteFile;
import com.huawei.ism.tool.inspect.utils.HtmlResUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.json.JSONArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class FusionStorageReportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorageReportService.class);
    private static final String TEMPLATE_DIR = "/fusioneval/";
    private static final int BUILDER_PAGES_LIMIT = 2;
    private static final String NEWLINE = System.lineSeparator();
    private ThreadPoolExecutor failedNodeExecutor;
    private ExecutorService reportBuilder = null;
    private ArrayBlockingQueue<Map.Entry<String, List<DetailEntry>>> nodesFailedItemsQueue = new ArrayBlockingQueue(100);
    private volatile boolean isAllNodesDoneIterating = false;

    public void setAllNodeStatus(boolean status) {
        this.isAllNodesDoneIterating = status;
    }

    public boolean buildReport() {
        try {
            this.buildLeftTree();
            this.buildCoverPage();
            this.buildIndexPage();
            this.copyExtendedFile();
            this.buildSummaryPage();
            this.addSha256Txt();
        }
        catch (Exception e) {
            LOGGER.error("Build report error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void addSha256Txt() {
        InspectUtils.addSHA256SignFile(new File(Constants.REPORT_TEMP_DIR));
    }

    private void copyExtendedFile() {
        FileUtils.copyDir((String)(InspectContext.INSPECT_CONFPATH + File.separator + "template"), (String)Constants.REPORT_TEMP_DIR);
        FileUtils.copyDir((String)(InspectContext.INSPECT_CONFPATH + File.separator + "eval_css"), (String)(FusionStorageReportService.getHtmlRootPath() + File.separator + "css"));
    }

    private void buildSummaryPage() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        String recommendedPaths = FusionStorageEvalContext.getInstance().getSupportedEvalPathMap().getOrDefault(taskInfo.getShowVersion(), new UpgradePathConfigDto()).getToVersions();
        boolean recommended = Arrays.asList(recommendedPaths.split(",")).contains(taskInfo.getTargetVersion());
        this.builedCube(taskInfo.getCheckNodes());
        data.put("isFusionCubeEval", InspectUtils.isFusionCubeEval());
        data.put("isRecommendedPath", recommended);
        data.put("mode", taskInfo.getMode().toString());
        data.put("floatIp", taskInfo.getFloatIp());
        data.put("originalVersion", taskInfo.getShowVersion());
        data.put("targetVersion", taskInfo.getTargetVersion());
        data.put("nodes", taskInfo.getCheckNodes().values());
        data.put("isEval", InspectUtils.isFusionEval() || InspectUtils.isFusionCubeEval());
        data.putAll(taskInfo.calcEvalResult());
        this.buildErroNodeInfo(data);
        TemplateFactory.processorFtl("/fusioneval/eval_summary.html", data, FusionStorageReportService.getHtmlRootPath() + File.separator + "head" + File.separator + "summary.html");
    }

    private void buildErroNodeInfo(Map<String, Object> data) {
        Set<String> detailNotExistNodes;
        String splitStr = ResourceUtil.getString((String)"splitStr");
        Set<String> topoNotExis = FusionStorageEvalContext.getInstance().getTopoNotExistNodes();
        if (!topoNotExis.isEmpty()) {
            data.put("topoNotExis", String.join((CharSequence)splitStr, topoNotExis));
        }
        if (!(detailNotExistNodes = FusionStorageEvalContext.getInstance().getDetailsNotExistNodes()).isEmpty()) {
            data.put("detailNotExistNodes", String.join((CharSequence)splitStr, detailNotExistNodes));
        }
    }

    private void builedCube(Map<String, CheckNode> checkNodes) {
        checkNodes.values().forEach(node -> {
            if (this.hasCubeItem(node.getNodeFileName())) {
                node.setHasCubeItem(true);
            }
        });
    }

    public Future<Boolean> startFailedNodesDetailListener() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("nodeTitle", HtmlResUtils.getString("all.failed.items.details.title"));
        TemplateFactory.processorFtl("/fusioneval/failedItemsAll.html", data, FusionStorageReportService.getHtmlRootPath() + File.separator + "allFailures.html");
        this.failedNodeExecutor = new ScheduledThreadPoolExecutor(1);
        Future<Boolean> future = this.failedNodeExecutor.submit(new FailedNodesWritterCallable());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> buildNodesDetailPage() {
        this.isAllNodesDoneIterating = false;
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        String[] nodeIds = taskInfo.getExecuteNodeId(null).split(",");
        Map<String, CheckNode> faildCheckNode = taskInfo.getFailedCheckNode();
        try {
            this.reportBuilder = Executors.newFixedThreadPool(10);
            ArrayList faildNodeIds = new ArrayList();
            ArrayList<Future<List<String>>> tasks = new ArrayList<Future<List<String>>>();
            this.submitTask(tasks, nodeIds);
            if (!faildCheckNode.isEmpty()) {
                String[] faildNodes = faildCheckNode.keySet().toArray(new String[0]);
                this.submitTask(tasks, faildNodes);
            }
            for (Future future : tasks) {
                faildNodeIds.addAll((Collection)future.get());
            }
            ArrayList arrayList = faildNodeIds;
            return arrayList;
        }
        catch (Exception e) {
            LOGGER.error("Build node detail report error.", (Throwable)e);
        }
        finally {
            if (this.reportBuilder != null) {
                this.reportBuilder.shutdown();
            }
        }
        this.isAllNodesDoneIterating = true;
        return null;
    }

    private void submitTask(List<Future<List<String>>> tasks, String[] nodeIds) {
        List<List<String>> taskNodeIds = this.splitWorker(nodeIds);
        for (List<String> taskNodeId : taskNodeIds) {
            NodeDetailBuilder builder = new NodeDetailBuilder(taskNodeId);
            tasks.add(this.reportBuilder.submit(builder));
        }
    }

    private List<List<String>> splitWorker(String[] nodeIds) {
        ArrayList<List<String>> taskNodeIds = new ArrayList<List<String>>();
        ArrayList<String> oneTaskNodeIds = new ArrayList<String>(2);
        taskNodeIds.add(oneTaskNodeIds);
        int index = 0;
        for (String nodeId : nodeIds) {
            if (index == 2) {
                index = 0;
                oneTaskNodeIds = new ArrayList(2);
                taskNodeIds.add(oneTaskNodeIds);
            }
            oneTaskNodeIds.add(nodeId);
            ++index;
        }
        return taskNodeIds;
    }

    public void buildIndexPage() {
        TemplateFactory.processorFtl("/fusioneval/eval_index.html", new HashMap(0), Constants.REPORT_TEMP_DIR + File.separator + "index.html");
    }

    public void buildCoverPage() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logo", "huaweilogo.jpg");
        data.put("copyright", HtmlResUtils.getOEMString("cover.system.copyright"));
        data.put("company", HtmlResUtils.getOEMString("cover.company"));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("haveToolkitVersion", true);
        if (UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version") == null) {
            data.put("haveToolkitVersion", false);
            LOGGER.warn("toolkitversion is null !");
        }
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("releasedate", ApplicationContext.getInstance().getReleaseDate());
        data.put("title", HtmlResUtils.getString("cover.highlighttitle"));
        data.put("genneratedate", this.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
        TemplateFactory.processorFtl("/fusioneval/eval_cover.html", data, FusionStorageReportService.getHtmlRootPath() + File.separator + "head" + File.separator + "cover.html");
    }

    private String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2, dateStr.length());
        StringBuffer str = new StringBuffer(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    public void buildLeftTree() {
        HashMap nodes = new HashMap();
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        HashMap<String, String> data = new HashMap<String, String>();
        JSONArray zTreeNodes = new JSONArray();
        ZTreeNode coverNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodeone")).setUrl("head/cover.html").setOpen(true);
        ZTreeNode summaryNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodetwo")).setUrl("head/summary.html");
        ZTreeNode detailNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodef")).setParent(true);
        zTreeNodes.put((Object)coverNode).put((Object)summaryNode);
        this.buildDetailNodes(taskInfo, detailNode);
        zTreeNodes.put((Object)detailNode);
        data.put("treeNodes", zTreeNodes.toString());
        TemplateFactory.processorFtl("/fusioneval/eval_devsTree.html", data, FusionStorageReportService.getHtmlRootPath() + File.separator + "device_tree.html");
    }

    private void buildDetailNodes(ClusterEvalInfo taskInfo, ZTreeNode detailNode) {
        ZTreeNode fsmType = this.buildTypeNode("Manager");
        ZTreeNode fsaType = this.buildTypeNode("Agent");
        Map<String, CheckNode> nodes = taskInfo.getCheckNodes();
        taskInfo.getCheckNodes().keySet().forEach(id -> {
            if (id.contains("Manager")) {
                fsmType.addChildren(this.buildNode((CheckNode)nodes.get(id)));
            } else {
                fsaType.addChildren(this.buildNode((CheckNode)nodes.get(id)));
            }
        });
        if (fsmType.hasChildren()) {
            detailNode.addChildren(fsmType);
        }
        if (fsaType.hasChildren()) {
            detailNode.addChildren(fsaType);
        }
    }

    private ZTreeNode buildTypeNode(String typeKey) {
        return new ZTreeNode(String.join((CharSequence)" ", typeKey, HtmlResUtils.getString("lefttree.nodetwo"))).setParent(true);
    }

    private ZTreeNode buildNode(CheckNode node) {
        if (this.hasCubeItem(node.getNodeFileName())) {
            ZTreeNode devTreeNode = new ZTreeNode(String.join((CharSequence)" ", node.getIp(), HtmlResUtils.getString("lefttree.nodethree"))).setParent(true);
            devTreeNode.addChildren(new ZTreeNode("FusionCube").setUrl(String.format(Locale.ROOT, "nodes/%s/indexByCube.html", node.getNodeFileName())));
            devTreeNode.addChildren(new ZTreeNode("FusionStorage").setUrl(String.format(Locale.ROOT, "nodes/%s/index.html", node.getNodeFileName())));
            return devTreeNode;
        }
        return new ZTreeNode(String.join((CharSequence)" ", node.getIp(), HtmlResUtils.getString("lefttree.nodethree"))).setUrl(String.format(Locale.ROOT, "nodes/%s/index.html", node.getNodeFileName()));
    }

    private boolean hasCubeItem(String ip) {
        File cubeHtml = new File(FusionStorageReportService.getNodeDeatailRootPath() + File.separator + FusionStorageReportService.getLegalString(ip) + File.separator + "indexByCube.html");
        return cubeHtml.exists();
    }

    public static NodeResult parseNodeResult(String nodeId) throws ToolException {
        LOGGER.info(String.format(Locale.ENGLISH, "Start prase node result, node id : %s", nodeId));
        String nodeType = nodeId.contains("Manager") ? "Manager" : "Agent";
        String prefix = "Manager".equals(nodeType) ? "FSM_" : "FSA_";
        String ip = nodeId.replaceAll(nodeType, "");
        File resultFile = new File(FusionStorageEvalContext.getInstance().getTaskInfo().getCheckNodes().get(nodeId).getResultPath().getLast() + File.separator + prefix + FusionStorageReportService.getLegalString(ip) + Constants.resultSuffix);
        if (!resultFile.exists()) {
            throw new ToolException("perform.eval.result.parse.notfund", new Object[]{ip});
        }
        String resultStr = FusionStorageReportService.readFile(resultFile);
        if (StringUtils.isNULLStr((String)resultStr)) {
            throw new ToolException("perform.eval.result.parse.empty", new Object[]{ip});
        }
        HashSet<String> checkitmIds = new HashSet<String>();
        for (String checkitmId : FusionStorageEvalContext.getInstance().getCheckItemsNodeMapper().get(nodeType)) {
            checkitmIds.add(checkitmId);
        }
        NodeResult nodeResult = FusionStorageReportService.getNodeResult(resultStr, checkitmIds);
        return nodeResult;
    }

    private static NodeResult getNodeResult(String resultStr, Set<String> checkitmIds) throws ToolException {
        try {
            com.alibaba.fastjson.JSONArray result = JSON.parseArray((String)resultStr);
            NodeResult nodeResult = new NodeResult();
            if (result != null) {
                for (String object : result) {
                    JSONObject obj = (JSONObject)object;
                    String checkItemId = obj.getString("checkItemId");
                    checkitmIds.remove(checkItemId);
                    CheckResult itemResult = new CheckResult();
                    itemResult.setOriginalInfo(obj.getString("originalInfo"));
                    itemResult.setErrorKey(obj.getString("errorKey"));
                    itemResult.setParams(obj.getString("params"));
                    itemResult.setResultCode(obj.getString("resultCode"));
                    itemResult.setCheckItemId(checkItemId);
                    nodeResult.getDetail().put(checkItemId, itemResult);
                }
            } else {
                LOGGER.error("node result is null.");
            }
            for (String checkItemId : checkitmIds) {
                CheckResult itemResult = new CheckResult();
                itemResult.setOriginalInfo("--");
                itemResult.setErrorInfo(ResourceUtil.getString((String)"error.checkitem.not.exist"));
                itemResult.setResultCode("1");
                itemResult.setCheckItemId(checkItemId);
                nodeResult.getDetail().put(checkItemId, itemResult);
            }
            return nodeResult;
        }
        catch (Exception e) {
            LOGGER.error("Parse node result error.", (Throwable)e);
            throw new ToolException("perform.eval.result.parse.error");
        }
    }

    private static String readFile(File resultFile) {
        StringBuilder result = new StringBuilder("");
        try (FileReader reader = new FileReader(resultFile);
             BufferedReader br = new BufferedReader(reader);){
            String temp = "";
            while ((temp = br.readLine()) != null) {
                result.append(temp).append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            LOGGER.error("error occurred on parsing json file", (Throwable)e);
        }
        return result.toString();
    }

    public void buildResultExcel() {
        LOGGER.info("Start build ExcelReport.");
        ExcelResultBuilder exBuild = new ExcelResultBuilder();
        exBuild.buildSummary(this.createSummaries());
        this.deleteOldExcel();
        exBuild.writeExcel(FusionConstants.REPORT_TEMP_DIR);
        if (!new File(FusionConstants.REPORT_TEMP_DIR, "ClusterInfo.xlsx").exists()) {
            this.findSmartFile().ifPresent(sourcePath -> new MigarationInfoBuilder().build(sourcePath.toString(), FilesUtil.getCanonicalPath((File)new File(FusionConstants.REPORT_TEMP_DIR, "ClusterInfo.xlsx"))));
        }
        LOGGER.info("Build excelReport finished.");
    }

    private Optional<Path> findSmartFile() {
        Optional<Path> resultDir = FusionStorageReportService.findTargetPath(FusionConstants.REPORT_TEMP_DIR, "nodeResults_");
        if (!resultDir.isPresent()) {
            return Optional.empty();
        }
        return FusionStorageReportService.findTargetPath(resultDir.get().toString(), "smartMigtationCollectInfo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Path> findTargetPath(String source, String prefix) {
        try (Stream<Path> paths = Files.walk(Paths.get(source, new String[0]), new FileVisitOption[0]);){
            Optional<Path> optional = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(prefix)).min(Comparator.comparing(Path::toString));
            return optional;
        }
        catch (IOException exception) {
            LOGGER.error("find target path error, file path:{}, file prefix:{}.", new Object[]{source, prefix, exception});
            return Optional.empty();
        }
    }

    private void deleteOldExcel() {
        File file = new File(FusionConstants.REPORT_TEMP_DIR);
        String ending = ".xls";
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File childFile : files) {
            if (!childFile.getName().endsWith(ending)) continue;
            FileUtils.deleteFile((File)childFile);
        }
    }

    private List<FusionExcelSummaryEntry> createSummaries() {
        ArrayList<FusionExcelSummaryEntry> summaryEntries = new ArrayList<FusionExcelSummaryEntry>();
        FusionStorageEvalContext context = FusionStorageEvalContext.getInstance();
        Set<FusionCheckItem> fsmItems = new HashSet<FusionCheckItem>();
        Set<FusionCheckItem> fsaItems = new HashSet<FusionCheckItem>();
        HashSet<FusionCheckItem> cubeFsmItems = new HashSet<FusionCheckItem>();
        HashSet<FusionCheckItem> cubeFsaItems = new HashSet<FusionCheckItem>();
        if (InspectUtils.isFusionCubeEval()) {
            this.generateFusionCheckItemsSet(fsmItems, "Manager");
            this.generateFusionCheckItemsSet(fsaItems, "Agent");
            this.generateFusionCheckItemsSet(cubeFsmItems, "Cube_FSM");
            this.generateFusionCheckItemsSet(cubeFsaItems, "Cube_FSA");
        } else if (InspectUtils.isFusionInspect()) {
            Product product = context.getSupportPorduct().get(context.getTaskInfo().getShowVersion());
            fsmItems = product.getCheckItems().get("Manager");
            fsaItems = product.getCheckItems().get("Agent");
        }
        ConcurrentHashMap<String, Map<String, Map<String, Object>>> nodeResultMap = context.getNodeResultMap();
        HashMap<String, Map<String, Map<String, Object>>> fsmMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, Map<String, Map<String, Object>>> fsaMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, Map<String, Map<String, Object>>> cubeFsmMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, Map<String, Map<String, Object>>> cubeFsaMap = new HashMap<String, Map<String, Map<String, Object>>>();
        for (String nodeId : nodeResultMap.keySet()) {
            Map nodeResult = (Map)nodeResultMap.get(nodeId);
            if (nodeId.contains("Manager")) {
                this.generateNodeResultMap(fsmItems, cubeFsmItems, fsmMap, cubeFsmMap, nodeId, nodeResult);
            }
            if (!nodeId.contains("Agent")) continue;
            this.generateNodeResultMap(fsaItems, cubeFsaItems, fsaMap, cubeFsaMap, nodeId, nodeResult);
        }
        long inspectTime = System.currentTimeMillis() - context.getTaskInfo().getStartTime();
        if (!this.createSummariesWhenNodeResultFileMissing(summaryEntries, fsmItems, fsmMap, "Manager", inspectTime)) {
            this.createSummaries(summaryEntries, fsmItems, fsmMap, "Manager", inspectTime);
        }
        if (!this.createSummariesWhenNodeResultFileMissing(summaryEntries, fsaItems, fsaMap, "Agent", inspectTime)) {
            this.createSummaries(summaryEntries, fsaItems, fsaMap, "Agent", inspectTime);
        }
        if (!this.createSummariesWhenNodeResultFileMissing(summaryEntries, cubeFsaItems, cubeFsaMap, "Agent", inspectTime)) {
            this.createSummaries(summaryEntries, cubeFsaItems, cubeFsaMap, "Cube_FSA", inspectTime);
        }
        if (!this.createSummariesWhenNodeResultFileMissing(summaryEntries, cubeFsmItems, cubeFsmMap, "Manager", inspectTime)) {
            this.createSummaries(summaryEntries, cubeFsmItems, cubeFsmMap, "Cube_FSM", inspectTime);
        }
        return summaryEntries;
    }

    private void generateNodeResultMap(Set<FusionCheckItem> items, Set<FusionCheckItem> cubeItems, Map<String, Map<String, Map<String, Object>>> nodeResultMap, Map<String, Map<String, Map<String, Object>>> cubeResultMap, String nodeId, Map<String, Map<String, Object>> checkItemResult) {
        HashMap<String, Map<String, Object>> fusionItemResult = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> cubeItemResult = new HashMap<String, Map<String, Object>>();
        this.generateNodeResult(items, cubeItems, checkItemResult, fusionItemResult, cubeItemResult);
        nodeResultMap.put(nodeId, fusionItemResult);
        cubeResultMap.put(nodeId, cubeItemResult);
    }

    private void generateNodeResult(Set<FusionCheckItem> items, Set<FusionCheckItem> cubeItems, Map<String, Map<String, Object>> checkItemResult, Map<String, Map<String, Object>> fusionItemResult, Map<String, Map<String, Object>> cubeItemResult) {
        Set<String> cubeItemsStrs = this.getItemsStrs(cubeItems);
        Set<String> itemsStrs = this.getItemsStrs(items);
        checkItemResult.keySet().forEach(item -> {
            if (cubeItemsStrs.contains(item)) {
                cubeItemResult.put((String)item, (Map<String, Object>)checkItemResult.get(item));
            }
            if (itemsStrs.contains(item)) {
                fusionItemResult.put((String)item, (Map<String, Object>)checkItemResult.get(item));
            }
        });
    }

    private Set<String> getItemsStrs(Set<FusionCheckItem> items) {
        HashSet<String> itemsStrs = new HashSet<String>();
        items.forEach(item -> itemsStrs.add(item.getId()));
        return itemsStrs;
    }

    private void generateFusionCheckItemsSet(Set<FusionCheckItem> items, String nodeType) {
        Map<String, Set<String>> checkItemsNodeMapper = FusionStorageEvalContext.getInstance().getCheckItemsNodeMapper();
        checkItemsNodeMapper.get(nodeType).forEach(item -> {
            FusionCheckItem fusionCheckItem = new FusionCheckItem();
            fusionCheckItem.setSelect(true);
            fusionCheckItem.setId((String)item);
            items.add(fusionCheckItem);
        });
    }

    private boolean createSummariesWhenNodeResultFileMissing(List<FusionExcelSummaryEntry> summaryEntries, Set<FusionCheckItem> fusionCheckItems, Map<String, Map<String, Map<String, Object>>> nodeResultMap, String nodeType, long inspectTime) {
        if (nodeResultMap.size() < FusionStorageEvalContext.getInstance().getTaskInfo().getExecuteNodes(nodeType).size() || FusionStorageEvalContext.getInstance().getTaskInfo().getExecuteNodes(nodeType).size() == 0) {
            fusionCheckItems.forEach(fusionCheckItem -> {
                FusionExcelSummaryEntry fusionExcelSummaryEntry = new FusionExcelSummaryEntry();
                fusionExcelSummaryEntry.setCheckItemID(fusionCheckItem.getId());
                fusionExcelSummaryEntry.setParentName(nodeType);
                fusionExcelSummaryEntry.setCheckName(EvalResourceUtil.getItemDes(fusionCheckItem.getId() + ".name"));
                fusionExcelSummaryEntry.setRowSpan(fusionCheckItems.size());
                if (fusionCheckItem.isSelect()) {
                    fusionExcelSummaryEntry.setStatus(EvalStatus.FAILED);
                    fusionExcelSummaryEntry.setErrorInfo(ResourceUtil.getStringWithParams((String)"perform.eval.result.parse.notfund", (Object[])new Object[]{this.findFailedNodeId(nodeResultMap, nodeType)}));
                } else {
                    fusionExcelSummaryEntry.setStatus(EvalStatus.NOT_INVOLVED);
                }
                fusionExcelSummaryEntry.setInspectTime(inspectTime);
                summaryEntries.add(fusionExcelSummaryEntry);
            });
            return true;
        }
        return false;
    }

    private String findFailedNodeId(Map<String, Map<String, Map<String, Object>>> nodeResultMap, String nodeType) {
        ArrayList<String> errInfos = new ArrayList<String>();
        for (String nodeId : FusionStorageEvalContext.getInstance().getTaskInfo().getExecuteNodes(nodeType)) {
            if (nodeResultMap.keySet().stream().anyMatch(key -> key.equals(nodeId))) continue;
            errInfos.add(nodeId);
        }
        return String.join((CharSequence)",", errInfos);
    }

    private void createSummaries(List<FusionExcelSummaryEntry> summaryEntries, Set<FusionCheckItem> fusionCheckItems, Map<String, Map<String, Map<String, Object>>> nodeResultMap, String type, long inspectTime) {
        for (FusionCheckItem fusionCheckItem : fusionCheckItems) {
            FusionExcelSummaryEntry fusionExcelSummaryEntry = new FusionExcelSummaryEntry();
            fusionExcelSummaryEntry.setCheckItemID(fusionCheckItem.getId());
            fusionExcelSummaryEntry.setParentName(type);
            fusionExcelSummaryEntry.setCheckName(EvalResourceUtil.getItemDes(fusionCheckItem.getId() + ".name"));
            fusionExcelSummaryEntry.setRowSpan(fusionCheckItems.size());
            if ("Cube_FSA".equals(type)) {
                this.generateErrInfoAndStatus(nodeResultMap, "Agent", inspectTime, fusionCheckItem, fusionExcelSummaryEntry);
            } else if ("Cube_FSM".equals(type)) {
                this.generateErrInfoAndStatus(nodeResultMap, "Manager", inspectTime, fusionCheckItem, fusionExcelSummaryEntry);
            } else {
                this.generateErrInfoAndStatus(nodeResultMap, type, inspectTime, fusionCheckItem, fusionExcelSummaryEntry);
            }
            summaryEntries.add(fusionExcelSummaryEntry);
        }
    }

    private void generateErrInfoAndStatus(Map<String, Map<String, Map<String, Object>>> nodeResultMap, String type, long inspectTime, FusionCheckItem fusionCheckItem, FusionExcelSummaryEntry fusionExcelSummaryEntry) {
        if (!fusionCheckItem.isSelect()) {
            fusionExcelSummaryEntry.setErrorInfo("");
            fusionExcelSummaryEntry.setStatus(EvalStatus.NOT_INVOLVED);
            return;
        }
        StringBuilder errInfo = new StringBuilder();
        boolean isPass = true;
        errInfo.append(ResourceUtil.getString((String)"dsnode.nopass.title"));
        ArrayList<EvalStatus> statusList = new ArrayList<EvalStatus>();
        for (String nodeId : nodeResultMap.keySet()) {
            Map<String, Object> checkItemResultMap = nodeResultMap.get(nodeId).get(fusionCheckItem.getId());
            Object resultStatObj = checkItemResultMap.get("resultStat");
            EvalStatus resultStat = EvalStatus.NOT_INVOLVED;
            if (resultStatObj instanceof EvalStatus) {
                resultStat = (EvalStatus)((Object)resultStatObj);
            }
            statusList.add(resultStat);
            if (resultStat != EvalStatus.OPTIMIZATION && resultStat != EvalStatus.NOTPASS) continue;
            isPass = false;
            errInfo.append(nodeId.replace(type, ""));
            errInfo.append(":");
            errInfo.append(NEWLINE);
            errInfo.append(checkItemResultMap.get("errorInfo") == null ? "" : checkItemResultMap.get("errorInfo"));
            errInfo.append(NEWLINE);
        }
        if (!isPass) {
            fusionExcelSummaryEntry.setErrorInfo(errInfo.toString());
        }
        if (statusList.contains((Object)EvalStatus.NOTPASS)) {
            fusionExcelSummaryEntry.setStatus(EvalStatus.NOTPASS);
        } else if (statusList.contains((Object)EvalStatus.OPTIMIZATION)) {
            fusionExcelSummaryEntry.setStatus(EvalStatus.OPTIMIZATION);
        } else {
            fusionExcelSummaryEntry.setStatus(EvalStatus.PASS);
        }
        fusionExcelSummaryEntry.setInspectTime(inspectTime);
    }

    public static String getNodeDeatailRootPath() {
        return FusionStorageReportService.getHtmlRootPath() + File.separator + "nodes";
    }

    public static String getHtmlRootPath() {
        return Constants.REPORT_TEMP_DIR + File.separator + "data";
    }

    public void terminateThreadPool() {
        if (this.failedNodeExecutor != null) {
            this.failedNodeExecutor.shutdown();
        }
    }

    private static String getLegalString(String str) {
        return str.replaceAll(":", "_");
    }

    class FailedNodesWritterCallable
    implements Callable {
        FailedNodesWritterCallable() {
        }

        public Boolean call() throws Exception {
            while (true) {
                Map.Entry failedResult = (Map.Entry)FusionStorageReportService.this.nodesFailedItemsQueue.poll();
                if (FusionStorageReportService.this.isAllNodesDoneIterating && failedResult == null) {
                    ToolLoggerFactory.getLogger(FusionStorageReportService.class).info("all nodes finished items iteration, quit.");
                    return true;
                }
                if (failedResult != null) {
                    ToolLoggerFactory.getLogger(FusionStorageReportService.class).info(String.format(Locale.ENGLISH, "[packingFailedDetailsListener] take %s node's result.", failedResult.getKey()));
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("nodeTitle", failedResult.getKey());
                    data.put("allItems", failedResult.getValue());
                    TemplateFactory.processorFtl("/fusioneval/single_node_failure_template.html", data, FusionStorageReportService.getHtmlRootPath() + File.separator + "failNode.html");
                    String nodeTempFilePath = FusionStorageReportService.getHtmlRootPath() + File.separator + "failNode.html";
                    byte[] appenders = this.readFile(nodeTempFilePath);
                    if (appenders == null) {
                        appenders = (HtmlResUtils.getStringWithParam("detail.parsed.error", failedResult.getKey()) + "<br><br>").getBytes(StandardCharsets.UTF_8);
                    }
                    this.appendResult2File(appenders, FusionStorageReportService.getHtmlRootPath() + File.separator + "allFailures.html");
                    FileUtils.deleteFile((File)new File(nodeTempFilePath));
                    continue;
                }
                Thread.sleep(500L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendResult2File(byte[] appender, String targetFilePath) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(new File(targetFilePath), true);
                outputStream.write(appender);
            }
            catch (Exception exp) {
                try {
                    LOGGER.error("exception occurred appending content to target file.");
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(outputStream, null);
                    throw throwable;
                }
                StreamUtils.closeStream((OutputStream)outputStream, null);
            }
            StreamUtils.closeStream((OutputStream)outputStream, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFile(String path) {
            File file = new File(path);
            Long fileLength = file.length();
            byte[] fileContent = new byte[fileLength.intValue()];
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                in.read(fileContent);
            }
            catch (Exception e) {
                String errors = String.format(Locale.ENGLISH, "exception:%s", e.toString());
                LOGGER.error(errors);
                fileContent = null;
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)in);
            }
            return fileContent;
        }
    }

    class NodeDetailBuilder
    implements Callable<List<String>> {
        List<String> nodeIds = null;

        public NodeDetailBuilder(List<String> ids) {
            this.nodeIds = ids;
        }

        @Override
        public List<String> call() throws Exception {
            ArrayList<String> faildNodeList = new ArrayList<String>();
            for (String nodeId : this.nodeIds) {
                if (this.buildNodeResult(nodeId)) continue;
                faildNodeList.add(nodeId);
            }
            return faildNodeList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean buildNodeResult(String nodeId) {
            try (ChannelWriteFile file = null;){
                if (StringUtils.isNULLStr((String)nodeId)) {
                    LOGGER.warn("The node id is empty");
                    boolean bl = true;
                    return bl;
                }
                CheckNode node = FusionStorageEvalContext.getInstance().getTaskInfo().getCheckNodes().get(nodeId);
                HashMap<String, Object> data = new HashMap<String, Object>();
                this.checkEvalStatus(nodeId, node, data);
                if (data.containsKey("cubeitems")) {
                    data.put("nodeTitle", HtmlResUtils.getStringWithParam("detail.node.title.fusionStroage", nodeId));
                } else {
                    data.put("nodeTitle", HtmlResUtils.getStringWithParam("detail.node.title", nodeId));
                }
                data.put("isFail", EvalStatus.FAILED.equals((Object)node.getStatus()));
                data.put("node", node);
                TemplateFactory.processorFtl("/fusioneval/eval_detailView.html", data, FusionStorageReportService.getNodeDeatailRootPath() + File.separator + FusionStorageReportService.getLegalString(nodeId) + File.separator + "index.html");
                if (data.containsKey("cubeitems")) {
                    data.put("nodeTitle", HtmlResUtils.getStringWithParam("detail.node.title.fusionCube", nodeId));
                    data.put("allitems", data.get("cubeitems"));
                    TemplateFactory.processorFtl("/fusioneval/eval_detailView.html", data, FusionStorageReportService.getNodeDeatailRootPath() + File.separator + FusionStorageReportService.getLegalString(nodeId) + File.separator + "indexByCube.html");
                }
            }
            return true;
        }

        void checkEvalStatus(String nodeId, CheckNode node, Map<String, Object> data) throws InterruptedException {
            block4: {
                if (!EvalStatus.FAILED.equals((Object)node.getStatus())) {
                    try {
                        LinkedList<DetailEntry> detailEntrys = new LinkedList<DetailEntry>();
                        LinkedList<DetailEntry> cubeDetailEntrys = new LinkedList<DetailEntry>();
                        LinkedList<DetailEntry> failedItems = new LinkedList<DetailEntry>();
                        this.buildDetailList(nodeId, detailEntrys, cubeDetailEntrys, failedItems);
                        if (failedItems.size() > 0) {
                            LOGGER.info("offer one data structure to nodesFailedItemsQueue.");
                            FusionStorageReportService.this.nodesFailedItemsQueue.put(new FailedNodeRecordEntry(nodeId, failedItems));
                        }
                        this.buildNodeDetail(node, data, detailEntrys, cubeDetailEntrys);
                    }
                    catch (ToolException e) {
                        if (FusionStorageEvalContext.getInstance().getTaskInfo().getFailedCheckNode().containsKey(node.getUuid())) break block4;
                        node.setStatus(EvalStatus.FAILED);
                        node.setErrorMsg(e.getErrorLocaleDescription());
                    }
                }
            }
        }

        private void buildDetailList(String nodeId, List<DetailEntry> detailEntrys, List<DetailEntry> cubeDetailEntrys, List<DetailEntry> failedItems) throws ToolException {
            NodeResult result = FusionStorageReportService.parseNodeResult(nodeId);
            ConcurrentHashMap<String, Map<String, Map<String, Object>>> nodeResultMap = FusionStorageEvalContext.getInstance().getNodeResultMap();
            Map<String, CheckResult> detail = result.getDetail();
            HashMap resultMap = new HashMap();
            detail.keySet().forEach(key -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("resultStat", (Object)((CheckResult)detail.get(key)).getResultStat());
                map.put("errorInfo", ((CheckResult)detail.get(key)).getErrorInfo());
                resultMap.put(key, map);
            });
            nodeResultMap.put(nodeId, resultMap);
            Collection<CheckResult> items = result.getDetail().values();
            FusionStorageUserOpData userOpData = FusionStorageEvalContext.getInstance().getTaskInfo().getCurrentUserOpData();
            String nodeType = nodeId.contains("Manager") ? "Manager" : "Agent";
            String cubeType = nodeId.contains("Manager") ? "Cube_FSM" : "Cube_FSA";
            Set<String> cubeItemSet = FusionStorageEvalContext.getInstance().getCheckItemsNodeMapper().get(cubeType);
            if (cubeItemSet == null) {
                cubeItemSet = new HashSet<String>();
            }
            for (CheckResult item : items) {
                DetailEntry entity = this.buildItemDetailEntry(item);
                if (cubeItemSet.contains(item.getCheckItemId())) {
                    cubeDetailEntrys.add(entity);
                } else {
                    detailEntrys.add(entity);
                }
                if (entity.isPass()) continue;
                userOpData.addRiskItem(nodeType, item.getCheckItemId());
                failedItems.add(entity);
            }
        }

        private void buildNodeDetail(CheckNode node, Map<String, Object> data, List<DetailEntry> detailEntrys, List<DetailEntry> cubeDetailEntrys) {
            if (detailEntrys.stream().allMatch(detail -> detail.isPass())) {
                node.setStatusByFusionStorage(EvalStatus.PASS);
            } else {
                node.setStatusByFusionStorage(EvalStatus.NOTPASS);
            }
            data.put("allitems", detailEntrys);
            if (!cubeDetailEntrys.isEmpty()) {
                data.put("cubeitems", cubeDetailEntrys);
                if (cubeDetailEntrys.stream().allMatch(detail -> detail.isPass())) {
                    node.setStatusByFusionCube(EvalStatus.PASS);
                } else {
                    node.setStatusByFusionCube(EvalStatus.NOTPASS);
                }
            }
        }

        private DetailEntry buildItemDetailEntry(CheckResult item) {
            DetailEntry entry = new DetailEntry();
            String nameKey = item.getCheckItemId() + ".name";
            String methodKey = item.getCheckItemId() + ".method";
            String criterionKey = item.getCheckItemId() + ".criterion";
            String suggestionKey = item.getCheckItemId() + ".suggestion";
            String ret = item.getResultStat().toString();
            if (!StringUtils.isNULLStr((String)item.getErrorInfo())) {
                ret = ret + "<br/><xmp>" + item.getErrorInfo() + "</xmp>";
            }
            entry.setName(EvalResourceUtil.getItemDes(nameKey));
            entry.setCheckMethod(EvalResourceUtil.getItemDes(methodKey));
            entry.setCriterion(EvalResourceUtil.getItemDes(criterionKey));
            entry.setSuggestion(EvalResourceUtil.getItemDes(suggestionKey));
            entry.setPasstxt(ret);
            entry.setPass(EvalStatus.PASS.equals((Object)item.getResultStat()));
            entry.setStatus(Integer.parseInt(item.getResultCode()));
            entry.setSourceInfo("<xmp>" + item.getOriginalInfo() + "</xmp>");
            return entry;
        }
    }
}

