/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.conn.HttpConnectionCallback;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.entity.FsaNode;
import com.huawei.ism.tool.fusionstorage.eval.service.BaseService;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.GetRequest;
import com.huawei.ism.tool.protocol.rest.PostRequest;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.StateLessRestCallback;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageRestfulService
implements BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorageRestfulService.class);
    public static final int QUERYTASK_INTERVAL = 8000;
    public static final int TASK_STATUS_FINISHED = 7;
    public static final int TASK_NOT_EXIST = 8;
    private RestConnection restConnection;
    private StateLessRestCallback restCallback;
    private ClusterEvalInfo clusterInfo;
    private String baseUrl = "";

    public FusionStorageRestfulService(ClusterEvalInfo clusterInfo) throws ToolException {
        this.checkIsClusterInfoValid(clusterInfo);
        this.clusterInfo = clusterInfo;
        this.baseUrl = "https://" + RestUtil.processIPByURL((String)clusterInfo.getFloatIp()) + ":" + clusterInfo.getRestPort();
        this.restCallback = new HttpConnectionCallback();
        RequestInfo loginInfo = this.getLoginInfo();
        this.restConnection = RestConnectionManager.getRestConnection((DevNode)clusterInfo.getFloatNode(), (RequestInfo)loginInfo, (StateLessRestCallback)this.restCallback);
    }

    public ClusterEvalInfo fetchFSANodeTopography() throws ToolException {
        JSONArray poolTopo;
        JSONObject clusterTopo;
        String url = "https://" + RestUtil.processIPByURL((String)this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/dsware/service/upgrade/getFsaNodeTopo";
        GetRequest requestInfo = new GetRequest(url);
        this.initRequestInfo((RequestInfo)requestInfo);
        ResponseInfo response = null;
        response = this.restConnection.doRequest((RequestInfo)requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsa.node.topo.fetch.failed");
        }
        JSONObject resultJson = JSON.parseObject((String)response.getContent());
        JSONObject clientTopo = resultJson.getJSONObject("clientTopo");
        if (clientTopo != null) {
            JSONArray clientIPs = clientTopo.getJSONArray("clientIpList");
            this.appendFsaNodeInfos(clientIPs);
        }
        if ((clusterTopo = resultJson.getJSONObject("clusterTopo")) != null) {
            JSONArray mdcIps = clusterTopo.getJSONArray("mdcIpList");
            this.appendFsaNodeInfos(mdcIps);
        }
        if ((poolTopo = resultJson.getJSONArray("poolTopo")) != null && poolTopo.size() > 0) {
            for (int poi = 0; poi < poolTopo.size(); ++poi) {
                JSONArray osdIps = ((JSONObject)poolTopo.get(poi)).getJSONArray("osdIpList");
                this.appendFsaNodeInfos(osdIps);
            }
        }
        return this.clusterInfo;
    }

    public ClusterEvalInfo fetchFSANodeDetails() throws ToolException {
        String url = "https://" + RestUtil.processIPByURL((String)this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/dsware/service/upgrade/getFsaNodeInfo";
        PostRequest requestInfo = new PostRequest(url);
        requestInfo.setHeader("Host", RestUtil.processIPByURL((String)this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort());
        requestInfo.setHeader("Accept", "application/json;version=1.0");
        requestInfo.setHeader("Accept-Language", this.getAcceptLanguage());
        requestInfo.setHeader("Content-Type", "application/json");
        requestInfo.addParam("fsaNodeIpList", (Object)this.getAllFSAIps());
        ResponseInfo response = null;
        response = this.restConnection.doRequest((RequestInfo)requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsa.node.detail.fetch.failed");
        }
        JSONObject resultJson = JSON.parseObject((String)response.getContent());
        JSONArray fsaNodesDetails = resultJson.getJSONArray("fsaNodeInfoList");
        HashSet<String> fsmIps = new HashSet<String>();
        HashSet<String> fsaIps = new HashSet<String>();
        HashSet<String> topoNotExis = new HashSet<String>();
        FusionStorageEvalContext.getInstance().setTopoNotExistNodes(topoNotExis);
        HashSet<String> detailNotExistNodes = new HashSet<String>();
        FusionStorageEvalContext.getInstance().setDetailsNotExistNodes(detailNotExistNodes);
        this.checkFsaNodesDetails(fsaNodesDetails, fsmIps, fsaIps, topoNotExis);
        Map<String, FsaNode> allFsaNode = this.clusterInfo.getFsaNodes();
        if (fsaIps.size() != allFsaNode.size()) {
            detailNotExistNodes.addAll(allFsaNode.keySet());
            for (String fsaIp : fsaIps) {
                detailNotExistNodes.remove(fsaIp);
            }
            detailNotExistNodes.forEach(notExistNode -> this.clusterInfo.getFsaNodes().remove(notExistNode));
            if (!detailNotExistNodes.isEmpty()) {
                LOGGER.error(String.format(Locale.ENGLISH, "Some nodes info are not exist. nodes: %s", ((Object)detailNotExistNodes).toString()));
            }
        }
        if (fsmIps.size() > 1) {
            throw new ToolException("fsa.node.detail.fsmip.not.universal");
        }
        return this.clusterInfo;
    }

    void checkFsaNodesDetails(JSONArray fsaNodesDetails, Set<String> fsmIps, Set<String> fsaIps, Set<String> topoNotExis) throws ToolException {
        for (int poi = 0; poi < fsaNodesDetails.size(); ++poi) {
            JSONObject fsaNode = JSON.parseObject((String)fsaNodesDetails.getString(poi));
            String nodeIp = fsaNode.getString("nodeIp");
            String nodeName = fsaNode.getString("nodeName");
            String fsmIp = fsaNode.getString("fsmIp");
            FsaNode node = this.clusterInfo.getFsaNode(nodeIp);
            if (node == null) {
                topoNotExis.add(nodeIp);
                continue;
            }
            fsmIps.add(fsmIp);
            node.setFsmIp(fsmIp);
            node.setName(nodeName);
            fsaIps.add(nodeIp);
            CheckNode checkNode = new CheckNode(node);
            this.clusterInfo.getCheckNodes().put(checkNode.getUuid(), checkNode);
        }
    }

    public String fetchFSMNodeInfo() throws ToolException {
        String url = this.baseUrl + "/dsware/service/upgrade/getFsmNodeInfo";
        GetRequest requestInfo = new GetRequest(url);
        this.initRequestInfo((RequestInfo)requestInfo);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsm.node.info.fetch.failed");
        }
        return response.getContent();
    }

    public void commitTask(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/ExecuteTask";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("TaskType", (Object)"Commit");
        request.addParam("ID", (Object)taskId);
        JSONArray nodes = new JSONArray();
        String fsaIps = this.clusterInfo.getDistributeSuccessFsaNodesId().replaceAll("Agent", "");
        if (!StringUtils.isNULLStr((String)fsaIps)) {
            JSONObject fsaNodeInfo = new JSONObject();
            fsaNodeInfo.put("NodeList", (Object)fsaIps);
            fsaNodeInfo.put("NodeType", (Object)"Agent");
            fsaNodeInfo.put("LogicNodeType", (Object)"Client");
            fsaNodeInfo.put("AutoBatch", (Object)true);
            fsaNodeInfo.put("ParamList", (Object)"CHECK=Y");
            nodes.add((Object)fsaNodeInfo);
        }
        JSONObject fsmNodeInfo = new JSONObject();
        String fsmIps = this.clusterInfo.getPrimaryNode().getIp();
        if (this.clusterInfo.getMode().equals((Object)ClusterMode.DOUBLE)) {
            fsmIps = String.join((CharSequence)",", Arrays.asList(this.clusterInfo.getStandbyNode().getIp(), fsmIps));
        }
        fsmNodeInfo.put("NodeList", (Object)fsmIps);
        fsmNodeInfo.put("NodeType", (Object)"Manager");
        fsmNodeInfo.put("LogicNodeType", (Object)"FSM");
        fsmNodeInfo.put("AutoBatch", (Object)true);
        fsmNodeInfo.put("ParamList", (Object)"CHECK=Y");
        nodes.add((Object)fsmNodeInfo);
        request.addParam("Nodes", (Object)nodes.toString());
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null) {
            LOGGER.error("commit task but no return");
            throw new ToolException("clear.current.project.failed");
        }
        if (response.getStatusLine() == null) {
            LOGGER.error("commit task but no return status");
            throw new ToolException("clear.current.project.failed");
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            LOGGER.error(String.format(Locale.ENGLISH, "commit task but server returns %s", response.getStatusLine().getStatusCode()));
            throw new ToolException("clear.current.project.failed");
        }
    }

    public String executeEvalTask(String taskId, Set<String> task, String nodeType) throws ToolException {
        String url = this.baseUrl + "/upd/service/ExecuteTask";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("TaskType", (Object)"Precheck");
        request.addParam("ID", (Object)taskId);
        if (task.isEmpty()) {
            throw new ToolException(ResourceUtil.getString((String)"perform.eval.node.empty.error"));
        }
        JSONArray nodes = new JSONArray();
        JSONObject taskInfo = new JSONObject();
        taskInfo.put("NodeList", (Object)String.join((CharSequence)",", task));
        taskInfo.put("NodeType", (Object)nodeType);
        taskInfo.put("LogicNodeType", (Object)("Agent".equals(nodeType) ? "Client" : "FSM"));
        taskInfo.put("AutoBatch", (Object)true);
        taskInfo.put("ParamList", (Object)"CHECK=Y");
        nodes.add((Object)taskInfo);
        request.addParam("Nodes", (Object)nodes.toString());
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("perform.eval.error");
        }
        return response.getContent();
    }

    public String executeEvalTask(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/ExecuteTask";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("TaskType", (Object)"Precheck");
        request.addParam("ID", (Object)taskId);
        if (this.clusterInfo.getExecuteNodes(null).isEmpty()) {
            throw new ToolException(ResourceUtil.getString((String)"perform.eval.node.empty.error"));
        }
        JSONArray nodes = new JSONArray();
        if (!this.clusterInfo.getExecuteNodes("Agent").isEmpty()) {
            JSONObject fsaNodeInfo = new JSONObject();
            fsaNodeInfo.put("NodeList", (Object)this.getNodeIps("Agent"));
            fsaNodeInfo.put("NodeType", (Object)"Agent");
            fsaNodeInfo.put("LogicNodeType", (Object)"Client");
            fsaNodeInfo.put("AutoBatch", (Object)true);
            fsaNodeInfo.put("ParamList", (Object)"CHECK=Y");
            nodes.add((Object)fsaNodeInfo);
        }
        if (!this.clusterInfo.getExecuteNodes("Manager").isEmpty()) {
            JSONObject fsmNodeInfo = new JSONObject();
            fsmNodeInfo.put("NodeList", (Object)this.getNodeIps("Manager"));
            fsmNodeInfo.put("NodeType", (Object)"Manager");
            fsmNodeInfo.put("LogicNodeType", (Object)"FSM");
            fsmNodeInfo.put("AutoBatch", (Object)true);
            fsmNodeInfo.put("ParamList", (Object)"CHECK=Y");
            nodes.add((Object)fsmNodeInfo);
        }
        request.addParam("Nodes", (Object)nodes.toString());
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("perform.eval.error");
        }
        return response.getContent();
    }

    public String queryTaskInfoChangedFlag(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/QueryTaskInfoChangedFlag";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("ID", (Object)taskId);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("perform.eval.error");
        }
        return response.getContent();
    }

    public String queryChangeTaskInfo(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/QueryChangedTaskInfo";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("ID", (Object)taskId);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("failed.to.query.task.detail");
        }
        return response.getContent();
    }

    public String distribtePkg(String taskId, String nodeType) throws ToolException {
        String url = this.baseUrl + "/upd/service/DistribtePkg";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("ID", (Object)taskId);
        request.addParam("NodeType", (Object)nodeType);
        request.addParam("NodeList", (Object)this.getNodeIps(nodeType));
        request.addParam("PackagePath", (Object)(this.clusterInfo.getFsmUploadPath() + FusionStoragePackingService.zipBallRootDir));
        this.initRequestInfo((RequestInfo)request);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("perform.distribte.error");
        }
        this.checkResult(response.getContent());
        return response.getContent();
    }

    public String distribtePkg(String taskId, Set<String> nodeIps, String nodeType) throws ToolException {
        String url = this.baseUrl + "/upd/service/DistribtePkg";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("ID", (Object)taskId);
        request.addParam("NodeType", (Object)nodeType);
        request.addParam("NodeList", (Object)String.join((CharSequence)",", nodeIps));
        request.addParam("PackagePath", (Object)(this.clusterInfo.getFsmUploadPath() + FusionStoragePackingService.zipBallRootDir));
        this.initRequestInfo((RequestInfo)request);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("perform.distribte.error");
        }
        this.checkResult(response.getContent());
        return response.getContent();
    }

    private String getNodeIps(String nodeType) {
        return String.join((CharSequence)",", this.clusterInfo.getExecuteNodes(nodeType));
    }

    public String queryDistributeStatus(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/QueryDistributeStatus?ID=" + taskId;
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("failed.to.query.distribute.status");
        }
        return response.getContent();
    }

    public String clearTask(String taskId) throws ToolException {
        String url = this.baseUrl + "/upd/service/OperateTask";
        PostRequest request = new PostRequest(url);
        this.initRequestInfo((RequestInfo)request);
        request.addParam("ID", (Object)taskId);
        request.addParam("OpType", (Object)"2");
        ResponseInfo response = this.restConnection.doRequest((RequestInfo)request, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("clear.task.failed");
        }
        return response.getContent();
    }

    private RequestInfo getLoginInfo() {
        String url = "https://" + RestUtil.processIPByURL((String)this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/sec/service/login";
        PostRequest loginInfo = new PostRequest(url);
        this.initRequestInfo((RequestInfo)loginInfo);
        loginInfo.setHeader("X-Auth-User", this.clusterInfo.getFloatGateWayUser().getUserName());
        loginInfo.setHeader("X-Auth-Key", this.clusterInfo.getFloatGateWayUser().getPassword());
        return loginInfo;
    }

    private String getAcceptLanguage() {
        Locale lang = LanguageManager.getInstance().getCurrentLanguage();
        return lang.equals(Locale.ENGLISH) ? "en_US" : "zh_CN";
    }

    private void checkIsClusterInfoValid(ClusterEvalInfo clusterInfo2) {
    }

    private void checkResult(String result) throws ToolException {
        String errorCode;
        JSONObject obj = JSON.parseObject((String)result);
        String resultStat = obj.getString("Result");
        if (!(StringUtils.isNULLStr((String)resultStat) || "0".equals(resultStat) || StringUtils.isNULLStr((String)(errorCode = obj.getString("ErrCode"))))) {
            ToolException excep = new ToolException(errorCode, false);
            excep.setDes(EvalResourceUtil.getErrorDes(errorCode));
            throw excep;
        }
    }

    private void appendFsaNodeInfos(JSONArray clientIPs) {
        for (int poi = 0; poi < clientIPs.size(); ++poi) {
            if (this.clusterInfo.getFsaNode(clientIPs.getString(poi)) != null) continue;
            FsaNode node = new FsaNode();
            node.setIp(clientIPs.getString(poi));
            node.setSn(node.getIp() + "Agent");
            this.clusterInfo.putFsaNode(node);
        }
    }

    private String getAllFSAIps() {
        if (this.clusterInfo.getFsaNodes().isEmpty()) {
            return "[]";
        }
        return "[\"" + String.join((CharSequence)"\",\"", this.clusterInfo.getFsaNodes().keySet()) + "\"]";
    }

    private void initRequestInfo(RequestInfo requestInfo) {
        requestInfo.setHeader("Host", RestUtil.processIPByURL((String)this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort());
        requestInfo.setHeader("Accept", "application/json;version=1.0");
        requestInfo.setHeader("Accept-Language", this.getAcceptLanguage());
    }

    public void closeConnection() {
        RestConnectionManager.releaseConn((DevNode)this.clusterInfo.getFloatNode());
    }
}

