/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.card;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.UpgradePathConfigDto;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.layout.EvalSelectDeviceLayout;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.ShowSupportListener;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.ConnClusterCard;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.ConnClusterCardLayout;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EvalSelectDeviceCard
extends ConnClusterCard {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalSelectDeviceCard.class);
    private static final CardModelEnum CARDMODE = CardModelEnum.EVALSELECTDEVICE;
    private Map<String, UpgradePathConfigDto> upgradePath;
    private static final long serialVersionUID = 2406391829340484099L;

    public EvalSelectDeviceCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.layout = new EvalSelectDeviceLayout();
        this.initUpdEvlData();
        this.addLayout(this.layout);
        this.bindListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUpdEvlData() {
        this.upgradePath = new HashMap<String, UpgradePathConfigDto>();
        File xmlFile = new File(FusionStoragePackingService.getCurPackageRootDir() + "sysConf.xml");
        FileInputStream filedInput = null;
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        try {
            filedInput = new FileInputStream(xmlFile);
            Document document = XmlUtils.parseDocument((InputStream)filedInput);
            Element root = document.getDocumentElement();
            Collection productList = XmlUtils.getChildren((Element)root, (String)"product");
            for (Element element : productList) {
                Collection supportPaths;
                Object ele2;
                String packagePath = null;
                String uploadPath = null;
                Collection packagePathElement = XmlUtils.getChildren((Element)element, (String)"packagePath");
                for (Object ele2 : packagePathElement) {
                    Matcher m = p.matcher(ele2.getTextContent());
                    packagePath = m.replaceAll("");
                }
                Collection uploadPathElement = XmlUtils.getChildren((Element)element, (String)"uploadpath");
                ele2 = uploadPathElement.iterator();
                while (ele2.hasNext()) {
                    Element ele3 = (Element)ele2.next();
                    Matcher m = p.matcher(ele3.getTextContent());
                    uploadPath = m.replaceAll("");
                }
                if (!InspectUtils.isFusionCubeEval()) {
                    supportPaths = XmlUtils.getChildren((Element)element, (String)"supportPaths");
                    this.initUpgradePath(packagePath, uploadPath, supportPaths, this.upgradePath);
                    FusionStorageEvalContext.getInstance().setSupportedEvalPathMap(this.upgradePath);
                    continue;
                }
                supportPaths = XmlUtils.getChildren((Element)element, (String)"supportPathsForCube");
                this.initUpgradePath(packagePath, uploadPath, supportPaths, this.upgradePath);
                FusionStorageEvalContext.getInstance().setSupportedEvalPathMap(this.upgradePath);
                supportPaths = XmlUtils.getChildren((Element)element, (String)"supportPaths");
                HashMap<String, UpgradePathConfigDto> upgradePathForStorage = new HashMap<String, UpgradePathConfigDto>();
                this.initUpgradePath(packagePath, uploadPath, supportPaths, upgradePathForStorage);
                FusionStorageEvalContext.getInstance().setSupportedEvalPathForStorageInCubeScene(upgradePathForStorage);
            }
        }
        catch (Exception e) {
            LOGGER.error("read sysconfig.xml error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)filedInput);
        }
    }

    private void initUpgradePath(String packagePath, String uploadPath, Collection<Element> supportPaths, Map<String, UpgradePathConfigDto> upgradePath) {
        for (Element sp : supportPaths) {
            Collection targetPath = XmlUtils.getChildren((Element)sp, (String)"targetPath");
            for (Element tp : targetPath) {
                String from = XmlUtils.getAttribute((Element)tp, (String)"from");
                String target = XmlUtils.getAttribute((Element)tp, (String)"targets");
                UpgradePathConfigDto upgradePathCfg = new UpgradePathConfigDto();
                upgradePathCfg.setFromVersion(from);
                upgradePathCfg.setLocalScriptPath(packagePath);
                upgradePathCfg.setUploadToRemotePath(uploadPath);
                upgradePathCfg.setToVersions(target);
                upgradePath.put(from, upgradePathCfg);
            }
        }
    }

    @Override
    protected void bindListener() {
        super.bindListener();
        ConnClusterCardLayout.getShowSupportLink().addClickListener((ToolHyperLinkLabel.ClickListener)new ShowSupportListener());
    }

    public String getTitle() {
        return CARDMODE.getTittle();
    }

    public int getStep() {
        return super.getStep(CARDMODE);
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (this.verifyInput()) {
            this.initTaskInfo();
            if (this.queryDeviceInfo() && this.checkVersion()) {
                FusionStorageEvalContext.getInstance().getNodeResultMap().clear();
                return InspectUIUtil.getNextCard(CARDMODE, this);
            }
        }
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    private boolean checkVersion() {
        String currentVersion = FusionStorageEvalContext.getInstance().getTaskInfo().getShowVersion();
        UpgradePathConfigDto pathConfig = this.upgradePath.get(currentVersion);
        if (pathConfig == null || StringUtils.isNULLStr((String)pathConfig.getToVersions())) {
            DialogUtils.showInfoDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getStringWithParams((String)"added.fusionstorage.is.not.supported", (Object[])new Object[]{currentVersion}));
            return false;
        }
        FusionStorageEvalContext.getInstance().getTaskInfo().setPackagePath(pathConfig.getLocalScriptPath());
        FusionStorageEvalContext.getInstance().getTaskInfo().setFsmUploadPath(pathConfig.getUploadToRemotePath());
        this.initCheckItemBelongings();
        return true;
    }

    private void initCheckItemBelongings() {
        StringBuffer checkItemSavePath = new StringBuffer(FusionStoragePackingService.getCurPackageRootDir());
        String[] versionContrlDir = FusionStorageEvalContext.getInstance().getTaskInfo().getPackagePath().split("/");
        HashMap<String, Set<String>> checkNodeMapper = new HashMap<String, Set<String>>();
        checkNodeMapper.put("Manager", new HashSet());
        checkNodeMapper.put("Agent", new HashSet());
        checkNodeMapper.put("Cube_FSM", new HashSet());
        checkNodeMapper.put("Cube_FSA", new HashSet());
        for (int i = 0; i < versionContrlDir.length; ++i) {
            if (StringUtils.isNULLStr((String)versionContrlDir[i])) continue;
            checkItemSavePath.append(versionContrlDir[i] + File.separator);
        }
        checkItemSavePath.append("checkItems.xml");
        LOGGER.info(String.format(Locale.ENGLISH, "parsing check items and node type mappings on path: %s", checkItemSavePath.toString()));
        File checkItmFile = new File(checkItemSavePath.toString());
        try (FileInputStream filedInput = new FileInputStream(checkItmFile);){
            Document document = XmlUtils.parseDocument((InputStream)filedInput);
            Element root = document.getDocumentElement();
            Collection productList = XmlUtils.getChildren((Element)root, (String)"checkItem");
            for (Element element : productList) {
                String id = XmlUtils.getAttribute((Element)element, (String)"id");
                String belongNodeType = XmlUtils.getAttribute((Element)element, (String)"supportNodeTypes");
                if (belongNodeType.contains("Agent")) {
                    ((Set)checkNodeMapper.get("Agent")).add(id);
                }
                if (belongNodeType.contains("Manager")) {
                    ((Set)checkNodeMapper.get("Manager")).add(id);
                }
                if (belongNodeType.contains("Cube_FSM")) {
                    ((Set)checkNodeMapper.get("Cube_FSM")).add(id);
                }
                if (!belongNodeType.contains("Cube_FSA")) continue;
                ((Set)checkNodeMapper.get("Cube_FSA")).add(id);
            }
        }
        catch (Exception e) {
            LOGGER.error("CHECK ITMES parsed failed", (Throwable)e);
            DialogUtils.showErrorDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"fusion.storage.business.package.broken"));
            FusionStorageEvalContext.getInstance().getMainDialog().dispose();
        }
        FusionStorageEvalContext.getInstance().setCheckItemsNodeMapper(checkNodeMapper);
    }
}

