/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.card;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.UpgradePathConfigDto;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.ManuallyInputDialog;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.layout.EvalSettingLayout;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.SettingCard;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalSettingCard
extends SettingCard {
    private static final long serialVersionUID = -7592951366783632289L;
    private static final CardModelEnum CARDMODE = CardModelEnum.EVALSETTING;
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalSettingCard.class);
    private EvalSettingLayout evalSettingLayout = new EvalSettingLayout(new JComboBox<String>());

    public EvalSettingCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.layout = this.evalSettingLayout;
        this.taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        this.addLayout(this.evalSettingLayout);
        this.setDefaultResultSavePath();
        this.bindLisenter();
    }

    @Override
    protected void bindLisenter() {
        super.bindLisenter();
        this.evalSettingLayout.getTargetVesionBox().addActionListener(new ComboBoxChangedListener(this.evalSettingLayout.getTargetVesionBox()));
    }

    public String getTitle() {
        return CARDMODE.getTittle();
    }

    public int getStep() {
        return super.getStep(CARDMODE);
    }

    protected ToolWizardDialog.Card getNextCard() {
        JDialog mainDialog = FusionStorageEvalContext.getInstance().getMainDialog();
        if (((String)this.evalSettingLayout.getTargetVesionBox().getSelectedItem()).equals(ResourceUtil.getString((String)"input.destination.version.manually")) || ((String)this.evalSettingLayout.getTargetVesionBox().getSelectedItem()).equals(ResourceUtil.getString((String)"please.select"))) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"target.version.not.valid"));
            return null;
        }
        if (!this.resultDirCheck()) {
            return null;
        }
        this.modifyFileContent();
        this.taskInfo.initExecuteNodes();
        return InspectUIUtil.getNextCard(CARDMODE, this);
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Previous.equals((Object)navigation)) {
            RestConnectionManager.releaseConn((DevNode)this.taskInfo.getFloatNode());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void modifyFileContent() {
        FusionStorageEvalContext.getInstance().getTaskInfo().setTargetVersion((String)this.evalSettingLayout.getTargetVesionBox().getSelectedItem());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FusionStoragePackingService.getCurPackageRootDir());
        String[] getPackagePathList = FusionStorageEvalContext.getInstance().getTaskInfo().getPackagePath().split("/");
        for (int poi = 1; poi < getPackagePathList.length; ++poi) {
            stringBuilder.append(getPackagePathList[poi]);
            stringBuilder.append(File.separator);
        }
        stringBuilder.append(FusionStoragePackingService.zipBallRootDir);
        stringBuilder.append(File.separator);
        stringBuilder.append("package.cfg");
        String filePath = stringBuilder.toString();
        FusionStorageEvalContext context = FusionStorageEvalContext.getInstance();
        Map<String, Set<String>> itemMap = context.getCheckItemsNodeMapper();
        Set<String> fsmItems = itemMap.get("Manager");
        Set<String> fsaItems = itemMap.get("Agent");
        if (InspectUtils.isFusionCubeEval()) {
            fsmItems.addAll(itemMap.getOrDefault("Cube_FSM", Collections.emptySet()));
            fsaItems.addAll(itemMap.getOrDefault("Cube_FSA", Collections.emptySet()));
        }
        FileReader reader = null;
        Properties config = this.taskInfo.getConfig();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                LOGGER.error("package.conf is not exsit.");
            }
            reader = new FileReader(file);
            config.load(reader);
            String targetVersion = "\"" + FusionStorageEvalContext.getInstance().getTaskInfo().getTargetVersion() + "\"";
            if (InspectUtils.isFusionCubeEval()) {
                String cubeTargetVersion = targetVersion;
                ClusterEvalInfo info = FusionStorageEvalContext.getInstance().getTaskInfo();
                targetVersion = FusionStorageEvalContext.getInstance().getSupportedEvalPathForStorageInCubeScene().getOrDefault(info.getOriginalVersion(), new UpgradePathConfigDto()).getToVersions();
                config.setProperty("cubeTargetVersion", cubeTargetVersion);
            }
            config.setProperty("targetVersion", targetVersion);
            config.setProperty("ManagerCheckItems", String.join((CharSequence)",", fsmItems));
            config.setProperty("AgentCheckItems", String.join((CharSequence)",", fsaItems));
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        catch (Exception e) {
            LOGGER.error("modify conf failed.", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, reader);
        }
    }

    class ComboBoxChangedListener
    implements ActionListener {
        JComboBox<String> comboBox;

        public ComboBoxChangedListener(JComboBox<String> targetVesionBox) {
            this.comboBox = targetVesionBox;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LOGGER.info("Change target version.");
            if (((String)this.comboBox.getSelectedItem()).equals(ResourceUtil.getString((String)"input.destination.version.manually"))) {
                ManuallyInputDialog dialog = new ManuallyInputDialog(FusionStorageEvalContext.getInstance().getMainDialog(), ResourceUtil.getString((String)"target.version.not.input"));
                dialog.setVisible(true);
                String userInput = FusionStorageEvalContext.getInstance().getTaskInfo().getTargetVersion();
                for (int i = 0; i < EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().getItemCount(); ++i) {
                    if (!EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().getItemAt(i).equals(userInput)) continue;
                    EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().setSelectedIndex(i);
                    return;
                }
                if (!StringUtils.isNULLStr((String)userInput)) {
                    LOGGER.info(String.format(Locale.ENGLISH, "Change target version by user modify. version is %s", userInput));
                    EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().addItem(userInput);
                    EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().setSelectedItem(FusionStorageEvalContext.getInstance().getTaskInfo().getTargetVersion());
                    return;
                }
                EvalSettingCard.this.evalSettingLayout.getTargetVesionBox().setSelectedItem(ResourceUtil.getString((String)"please.select"));
            }
        }
    }
}

