/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.card;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.layout.GetFusionUpdateToolLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetFusionUpdateToolDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFusionUpdateToolDialog.class);
    private static GetFusionUpdateToolLayout layout;
    private static final long serialVersionUID = -4611882961308068341L;

    public GetFusionUpdateToolDialog() {
        this.setTitle(ResourceUtil.getString((String)"fusion.storage.get.fusion.update.tool"));
        this.setResizable(false);
        this.add(this.init(), "Center");
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setSize(430, 310);
        this.setAlwaysOnTop(true);
        this.initListener();
    }

    private void initListener() {
        layout.getCloseBtn().addActionListener(arg0 -> {
            this.packingSceneData();
            Runtime.getRuntime().halt(0);
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GetFusionUpdateToolDialog.this.packingSceneData();
                Runtime.getRuntime().halt(0);
            }
        });
    }

    private void packingSceneData() {
        if (SceneUtils.isScene()) {
            ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("executeType", "0");
            result.put("status", String.valueOf(TaskResult.Result.SUCCESS));
            result.put("fileName", "");
            result.put("toolId", "toUpdateTool");
            result.put("isSkipDeviceAdd", "SUCCESS");
            resultList.add(result);
            InspectContext.getInstance().finishedSceneTask(resultList);
        }
    }

    private Component init() {
        this.setLayout(new BorderLayout());
        layout = new GetFusionUpdateToolLayout();
        this.initData();
        this.initTable();
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        String resultScenePath = SceneUtils.getSceneFilePath((String)"fusion_strg_evl_result.xml");
        File evalResult = new File(resultScenePath);
        if (!evalResult.exists()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"data.not.exist.please.restry"));
            this.dispose();
        }
        FileInputStream filedInput = null;
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        try {
            filedInput = new FileInputStream(evalResult);
            Document document = XmlUtils.parseDocument((InputStream)filedInput);
            Element root = document.getDocumentElement();
            Collection fromVersions = XmlUtils.getChildren((Element)root, (String)"from");
            String from = null;
            String to = null;
            Iterator iterator = fromVersions.iterator();
            if (iterator.hasNext()) {
                Element ele = (Element)iterator.next();
                Matcher m = p.matcher(ele.getTextContent());
                from = m.replaceAll("");
                layout.getCurrentVer().setText(from);
            }
            Collection toVersions = XmlUtils.getChildren((Element)root, (String)"to");
            for (Element ele : toVersions) {
                Matcher m = p.matcher(ele.getTextContent());
                to = m.replaceAll("");
                layout.getTargetVer().setText(to);
            }
        }
        catch (Exception e) {
            LOGGER.error("read scene xml error." + e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)filedInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTable() {
        String configFilePath = FusionStoragePackingService.getCurPackageRootDir() + "fusionUpdateToolMapper.xml";
        File evalResult = new File(configFilePath);
        if (!evalResult.exists()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"system.package.incomplete"));
            this.dispose();
        }
        FileInputStream filedInput = null;
        String targetName = null;
        String fileLink = null;
        try {
            filedInput = new FileInputStream(configFilePath);
            Document document = XmlUtils.parseDocument((InputStream)filedInput);
            Element root = document.getDocumentElement();
            Collection productList = XmlUtils.getChildren((Element)root, (String)"updateTool");
            block5: for (Element element : productList) {
                String target = XmlUtils.getAttribute((Element)element, (String)"targetVersion");
                if (!target.equals(layout.getTargetVer().getText().trim())) continue;
                Collection packagePathElement = XmlUtils.getChildren((Element)element, (String)"toolName");
                for (Element ele : packagePathElement) {
                    if (StringUtils.isNULLStr((String)ele.getTextContent())) continue;
                    targetName = ele.getTextContent().trim();
                    break;
                }
                Collection<Element> uploadPathElement = null;
                uploadPathElement = this.setUploadPathElement(element);
                for (Element ele : uploadPathElement) {
                    if (StringUtils.isNULLStr((String)ele.getTextContent())) continue;
                    fileLink = ele.getTextContent().trim();
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("read scene xml error." + e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)filedInput);
        }
        if (this.checkRunTime(targetName, fileLink)) {
            return;
        }
        this.createRow(targetName, fileLink);
    }

    private Collection<Element> setUploadPathElement(Element element) {
        Collection uploadPathElement = ApplicationContext.getInstance().getCurrentLanguage().equals(Locale.ENGLISH) ? XmlUtils.getChildren((Element)element, (String)"linkEn") : XmlUtils.getChildren((Element)element, (String)"linkZh");
        return uploadPathElement;
    }

    private boolean checkRunTime(String targetName, String fileLink) {
        if (targetName == null || fileLink == null) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"the.path.is.not.configured"));
            this.dispose();
            Runtime.getRuntime().halt(0);
            return true;
        }
        return false;
    }

    private void createRow(String targetName, final String fileLink) {
        DefaultTableRow row = new DefaultTableRow(2, (Object)targetName);
        row.setValueAt(0, (Object)targetName);
        row.setValueAt(1, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"get.software.link"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    URL link = new URL(fileLink);
                    Desktop.getDesktop().browse(link.toURI());
                }
                catch (IOException | URISyntaxException e1) {
                    LOGGER.error("open link error." + e1);
                }
            }
        }));
        layout.getTableModel().addRow(new TableRow[]{row});
    }
}

