/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckResult;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.EvalDetailLayout;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.ItemDetailInfoDialog;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;

public class EvalDetailDialog
extends JDialog {
    private static final long serialVersionUID = -1200952291372388205L;
    EvalDetailLayout detailLayout = new EvalDetailLayout();

    public EvalDetailDialog(JDialog parent, String nodeId, String itemId) {
        super((Dialog)parent, true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.detailLayout, "Center");
        this.setTitle(ResourceUtil.getString((String)"perform.eval.detail.view"));
        this.initData(nodeId, itemId);
        this.pack();
        this.setResizable(true);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.bindListener();
    }

    private void initData(String nodeId, String itemId) {
        ClusterEvalInfo evalInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        String method = EvalResourceUtil.getItemDes(itemId + ".method");
        String criterion = EvalResourceUtil.getItemDes(itemId + ".criterion");
        String suggestion = EvalResourceUtil.getItemDes(itemId + ".suggestion");
        CheckResult checkResult = evalInfo.getNodesResult().get(nodeId).getDetail().get(itemId);
        StringBuffer context = new StringBuffer();
        context.append("<div class=\"exp\">").append(ResourceUtil.getString((String)"perform.eval.detail.method")).append("</div>").append(this.detailLayout.htmlEncode(method)).append(System.lineSeparator()).append(System.lineSeparator()).append("<div class=\"exp\">").append(ResourceUtil.getString((String)"perform.eval.detail.criterion")).append("</div>").append(this.detailLayout.htmlEncode(criterion));
        if (!EvalStatus.PASS.equals((Object)checkResult.getResultStat())) {
            context.append(System.lineSeparator()).append(System.lineSeparator()).append("<div class=\"exp\">").append(ResourceUtil.getString((String)"perform.eval.detail.suggestion")).append("</div>").append(suggestion);
        }
        JEditorPane reference = this.detailLayout.getReference();
        this.detailLayout.getReference().setContentType("text/html;charset=\"UTF-8\"");
        reference.setText(this.detailLayout.getHtml(context.toString()));
        reference.setEditable(false);
        JEditorPane result = this.detailLayout.getResult();
        result.setContentType("text/html;charset=\"UTF-8\"");
        String ret = checkResult.getResultStat().toString();
        if (!StringUtils.isNULLStr((String)checkResult.getErrorInfo())) {
            ret = ret + "<br/><br/>" + checkResult.getErrorInfo();
        }
        result.setText(this.detailLayout.getHtml(ret));
        this.detailLayout.setShowMoreText(this.detailLayout.processHtmlText(checkResult.getOriginalInfo()));
        this.detailLayout.scorll2top();
    }

    private void bindListener() {
        this.detailLayout.getClose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalDetailDialog.this.dispose();
            }
        });
        this.detailLayout.getShowMore().addClickListener(new ToolHyperLinkLabel.ClickListener(){

            public void clickLink(MouseEvent e) {
                ItemDetailInfoDialog detailInfoDialog = new ItemDetailInfoDialog(EvalDetailDialog.this.detailLayout.getShowMoreText(), EvalDetailDialog.this);
                detailInfoDialog.setVisible(true);
            }
        });
    }
}

