/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ManuallyInputDialog
extends JDialog {
    private static final long serialVersionUID = 7844437339532107074L;
    String tips = null;
    JTextField input = null;
    JButton confirmBtn = null;

    public ManuallyInputDialog(JDialog parent, String tips1) {
        super((Dialog)parent, true);
        this.tips = tips1;
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"input.manually.dialog.title"));
        this.setResizable(false);
        this.add((Component)this.init(), "Center");
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setSize(300, 185);
        this.initListener();
        this.confirmBtn.requestFocus();
    }

    private JComponent init() {
        JComponent view = null;
        JLabel panel = new JLabel(this.tips);
        ImageIcon icon = ResourceManager.getImage((String)"config/images/info.png");
        panel.setIcon(icon);
        this.input = new JTextField();
        this.input.setEditable(true);
        this.input.setText(ResourceUtil.getString((String)"manually.input.version.placeholder"));
        this.input.setForeground(new Color(150, 150, 150));
        this.input.setToolTipText(ResourceUtil.getString((String)"manually.input.version.tooltip"));
        UCD.setSameWidth((JComponent[])new JComponent[]{panel, this.input});
        this.confirmBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"ui.button.title.confirm"), (char)'C');
        view = UCD.buildVerticalBox((Border)BorderFactory.createEmptyBorder(), (int)0, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)panel, (int)12), this.input, Box.createVerticalStrut(12), new JSeparator(), UiMethod.buildFrameSpace((JComponent)UiMethod.buildCompsRight((int)0, (Component[])new Component[]{this.confirmBtn}), (int)12)});
        this.confirmBtn.requestFocus();
        return view;
    }

    private void initListener() {
        this.input.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (StringUtils.isNULLStr((String)ManuallyInputDialog.this.input.getText())) {
                    ManuallyInputDialog.this.input.setText(ResourceUtil.getString((String)"manually.input.version.placeholder"));
                    ManuallyInputDialog.this.input.setForeground(new Color(150, 150, 150));
                }
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                if (ResourceUtil.getString((String)"manually.input.version.placeholder").equals(ManuallyInputDialog.this.input.getText())) {
                    ManuallyInputDialog.this.input.setText("");
                    ManuallyInputDialog.this.input.setForeground(Color.BLACK);
                }
            }
        });
        this.getConfirmBtn().addActionListener(arg0 -> {
            String ver = this.getInput().getText();
            if (StringUtils.isNULLStr((String)ver)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"target.version.not.input"));
                return;
            }
            if (InspectUtils.isFusionCubeEval()) {
                FusionStorageEvalContext.getInstance().getTaskInfo().setTargetVersion(this.getInput().getText().toUpperCase(Locale.ENGLISH));
                this.dispose();
                return;
            }
            Pattern pattern = Pattern.compile("^[V|v][0-9]{1}00[R|r]00[0-9]{1}[C|c][0-9A-Za-z]+");
            Matcher matcher = pattern.matcher(ver);
            if (!matcher.matches()) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"target.version.not.valid"));
                return;
            }
            FusionStorageEvalContext.getInstance().getTaskInfo().setTargetVersion(this.getInput().getText().toUpperCase(Locale.ENGLISH));
            this.dispose();
        });
    }

    public JTextField getInput() {
        return this.input;
    }

    public void setInput(JTextField input) {
        this.input = input;
    }

    public JButton getConfirmBtn() {
        return this.confirmBtn;
    }

    public void setConfirmBtn(JButton confirmBtn) {
        this.confirmBtn = confirmBtn;
    }
}

