/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs;

import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.entity.FsaNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowClusterTopoDialog
extends JDialog {
    private static final long serialVersionUID = 7844437339532107074L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowClusterTopoDialog.class);
    private ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
    private static final int TABLE_WIDHT = 410;
    private FilterPanel filterField;
    private static String[] tableHeader = new String[]{ResourceUtil.getString((String)"fusion.storage.node.name"), ResourceUtil.getString((String)"fusion.storage.node.ipaddr")};
    private TreeTableModel treeTableModel;
    private TreeTable treeTable;
    private JComponent detailTable;

    public ShowClusterTopoDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"cluster.summary"));
        this.setResizable(false);
        this.add((Component)this.init(), "Center");
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setSize(450, 600);
        this.treeTable.requestFocus();
        this.initListener();
    }

    private JComponent init() {
        this.initTablePanel();
        this.drawTreeTables();
        JComponent view = UCD.buildVerticalBox(null, (int)20, (Component[])new Component[]{this.detailTable});
        return view;
    }

    private void initListener() {
        this.getFilterField().getInputField().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                try {
                    if (ShowClusterTopoDialog.this.getFilterField().getInputField().getDocument().getText(0, ShowClusterTopoDialog.this.getFilterField().getInputField().getDocument().getLength()).equals(ResourceUtil.getString((String)"input.here.to.find"))) {
                        ShowClusterTopoDialog.this.getFilterField().getInputField().setText("");
                        ShowClusterTopoDialog.this.getFilterField().getInputField().setForeground(Color.BLACK);
                        ShowClusterTopoDialog.this.getFilterField().getInputField().setBackground(Color.WHITE);
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.error("the user input is invalid.", (Throwable)e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.setFilterField();
    }

    private void setFilterField() {
        this.getFilterField().getInputField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.repaintTreeTable(event);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.repaintTreeTable(event);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.repaintTreeTable(event);
            }

            void repaintTreeTable(DocumentEvent event) {
                String filterText;
                try {
                    filterText = event.getDocument().getText(0, event.getDocument().getLength());
                }
                catch (BadLocationException e) {
                    ShowClusterTopoDialog.this.drawTreeTables();
                    return;
                }
                ShowClusterTopoDialog.this.drawTreeTables(filterText);
            }
        });
    }

    private void initTablePanel() {
        JLabel sumTipComp = new JLabel("<html><div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + ResourceUtil.getString((String)"nodes.total.number") + ":" + this.getFsaNodesCheckSum() + "</div></html>");
        this.treeTableModel = new TreeTableModel(tableHeader);
        this.treeTable = new TreeTable(this.treeTableModel);
        this.treeTable.setSelectionMode(0);
        JScrollPane tablePan = new JScrollPane((Component)this.treeTable);
        UiMethod.setComponentSize((Dimension)new Dimension(410, 500), (Component[])new Component[]{tablePan});
        this.filterField = new FilterPanel();
        JComponent filter = UiMethod.buildCompsRight((int)12, (Component[])new Component[]{sumTipComp, this.filterField});
        UiMethod.setComponentSize((Dimension)new Dimension(410, 25), (Component[])new Component[]{filter});
        this.detailTable = UCD.buildVerticalBox(null, (int)1, (Component[])new Component[]{Box.createHorizontalStrut(1), filter, Box.createHorizontalStrut(5), tablePan, Box.createHorizontalStrut(12)});
    }

    private ITreeTableRow<String, String> createRow(String keywords, String name, String ipaddr) {
        DefaultTreeTableRow row = new DefaultTreeTableRow(tableHeader.length, (Object)keywords, (Object)ipaddr);
        row.setValue(0, (Object)name);
        row.setValue(1, (Object)ipaddr);
        return row;
    }

    private int getFsaNodesCheckSum() {
        int fsaNodes = FusionStorageEvalContext.getInstance().getTaskInfo().getFsaNodes().size();
        fsaNodes = FusionStorageEvalContext.getInstance().getTaskInfo().getMode().equals((Object)ClusterMode.DOUBLE) ? (fsaNodes += 2) : ++fsaNodes;
        return fsaNodes;
    }

    private FilterPanel getFilterField() {
        return this.filterField;
    }

    private TreeTable getTreeTable() {
        return this.treeTable;
    }

    private void drawTreeTables(String filter) {
        if (StringUtils.isNULLStr((String)filter)) {
            this.drawTreeTables();
            return;
        }
        for (ITreeTableRow row : this.getTreeTableModel().getAllTableRows()) {
            this.getTreeTableModel().deleteRow(row);
        }
        ArrayList<ITreeTableRow> rows = new ArrayList<ITreeTableRow>();
        ITreeTableRow<String, String> fsmRow = this.createRow("Manager", "Manager", "");
        for (DevNode node : Arrays.asList(this.taskInfo.getPrimaryNode(), this.taskInfo.getStandbyNode())) {
            if (node == null || !(node.getDeviceName() + node.getIp()).toUpperCase(Locale.ENGLISH).contains(filter.toUpperCase(Locale.ENGLISH))) continue;
            fsmRow.addSubRow(this.createRow(node.toString(), node.getDeviceName(), node.getIp()));
        }
        ITreeTableRow<String, String> fsaRow = this.createRow("Agent", "Agent", "");
        for (Map.Entry<String, FsaNode> node : this.taskInfo.getFsaNodes().entrySet()) {
            if (node == null || !(node.getValue().getIp() + node.getValue().getName()).toUpperCase(Locale.ENGLISH).contains(filter.toUpperCase(Locale.ENGLISH))) continue;
            fsaRow.addSubRow(this.createRow(node.getValue().getName() + node.getValue().getIp(), node.getValue().getName(), node.getValue().getIp()));
        }
        for (ITreeTableRow row : Arrays.asList(fsmRow, fsaRow)) {
            if (row.getSubRowList().isEmpty()) continue;
            rows.add(row);
        }
        if (!rows.isEmpty()) {
            this.getTreeTableModel().setRows(rows.toArray(new ITreeTableRow[0]));
            this.getTreeTable().addRowSelectionInterval(1, 1);
        }
    }

    private void drawTreeTables() {
        ArrayList<ITreeTableRow<String, String>> rows = new ArrayList<ITreeTableRow<String, String>>();
        ITreeTableRow<String, String> fsmRow = this.createRow("Manager", "Manager", "");
        for (DevNode node : Arrays.asList(this.taskInfo.getPrimaryNode(), this.taskInfo.getStandbyNode())) {
            if (node == null) continue;
            fsmRow.addSubRow(this.createRow(node.toString(), node.getDeviceName(), node.getIp()));
        }
        rows.add(fsmRow);
        ITreeTableRow<String, String> fsaRow = this.createRow("Agent", "Agent", "");
        for (Map.Entry<String, FsaNode> node : this.taskInfo.getFsaNodes().entrySet()) {
            if (node == null) continue;
            fsaRow.addSubRow(this.createRow(node.getValue().getName() + node.getValue().getIp(), node.getValue().getName(), node.getValue().getIp()));
        }
        rows.add(fsaRow);
        this.getTreeTableModel().setRows(rows.toArray(new ITreeTableRow[0]));
        this.getTreeTable().addRowSelectionInterval(1, 1);
    }

    private TreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public class FilterPanel
    extends JPanel {
        private static final long serialVersionUID = 8496766696642720946L;
        private static final int FILTER_FIELD_WIDTH = 180;
        private static final int FILTER_FIELD_HIGH = 21;
        private JTextArea inputField;
        private JLabel filterButton;

        public FilterPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(180, 21));
            this.setMaximumSize(new Dimension(180, 21));
            this.filterButton = new JLabel(new ImageIcon(ShowClusterTopoDialog.class.getResource("/config/images/filter.png")));
            this.filterButton.setBorder(BorderFactory.createEmptyBorder());
            this.add(this.filterButton);
            this.add(Box.createHorizontalStrut(8));
            this.inputField = new JTextArea();
            this.inputField.setText(ResourceUtil.getString((String)"input.here.to.find"));
            this.inputField.setSize(new Dimension(150, 20));
            this.inputField.setPreferredSize(new Dimension(150, 20));
            this.inputField.setMinimumSize(new Dimension(150, 20));
            this.inputField.setMaximumSize(new Dimension(150, 20));
            this.inputField.setForeground(Color.GRAY);
            this.inputField.setBackground(Color.WHITE);
            this.add(this.inputField);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setEnabled(true);
        }

        JTextArea getInputField() {
            return this.inputField;
        }
    }
}

